/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import com.oracle.truffle.tools.dap.types.DebugProtocolClient;
import com.oracle.truffle.tools.dap.types.LoadedSourceEvent;
import com.oracle.truffle.tools.dap.types.Source;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class LoadedSourcesHandler
implements LoadSourceListener {
    private final ExecutionContext context;
    private final DebuggerSession debuggerSession;
    private final Map<com.oracle.truffle.api.source.Source, Integer> sourceIDs = new HashMap<com.oracle.truffle.api.source.Source, Integer>(100);
    private final List<com.oracle.truffle.api.source.Source> sources = new ArrayList<com.oracle.truffle.api.source.Source>(100);
    private final Map<String, Consumer<com.oracle.truffle.api.source.Source>> toRunOnLoad = new HashMap<String, Consumer<com.oracle.truffle.api.source.Source>>();

    public LoadedSourcesHandler(ExecutionContext context, DebuggerSession debuggerSession) {
        this.context = context;
        this.debuggerSession = debuggerSession;
    }

    public void onLoad(LoadSourceEvent event) {
        com.oracle.truffle.api.source.Source source = event.getSource();
        if (this.context.isInspectInternal() || !source.isInternal()) {
            this.assureLoaded(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScriptId(com.oracle.truffle.api.source.Source source) {
        Map<com.oracle.truffle.api.source.Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            Integer id = this.sourceIDs.get(source);
            if (id != null) {
                return id;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.oracle.truffle.api.source.Source getSource(int id) {
        Map<com.oracle.truffle.api.source.Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            return this.sources.get(id - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.oracle.truffle.api.source.Source getSource(String path) {
        Map<com.oracle.truffle.api.source.Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            return this.sources.stream().filter(source -> Objects.equals(path, LoadedSourcesHandler.getPath(source))).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Source> getLoadedSources() {
        Map<com.oracle.truffle.api.source.Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            return Collections.unmodifiableList(this.sources.stream().map(this::from).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOnLoad(String path, Consumer<com.oracle.truffle.api.source.Source> task) {
        Map<com.oracle.truffle.api.source.Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            com.oracle.truffle.api.source.Source source = this.getSource(path);
            if (source != null) {
                if (task != null) {
                    task.accept(source);
                }
            } else if (task != null) {
                this.toRunOnLoad.put(path, task);
            } else {
                this.toRunOnLoad.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int assureLoaded(com.oracle.truffle.api.source.Source sourceLoaded) {
        DebugProtocolClient client;
        Consumer<com.oracle.truffle.api.source.Source> task;
        int id;
        com.oracle.truffle.api.source.Source sourceResolved = this.debuggerSession.resolveSource(sourceLoaded);
        com.oracle.truffle.api.source.Source source = sourceResolved != null ? sourceResolved : sourceLoaded;
        Map<com.oracle.truffle.api.source.Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            Integer eid = this.sourceIDs.get(source);
            if (eid != null) {
                return eid;
            }
            id = this.sources.size() + 1;
            this.sourceIDs.put(source, id);
            this.sources.add(source);
            task = this.toRunOnLoad.remove(LoadedSourcesHandler.getPath(source));
        }
        if (task != null) {
            task.accept(sourceLoaded);
        }
        if ((client = this.context.getClient()) != null) {
            client.loadedSource(LoadedSourceEvent.EventBody.create("new", this.from(source)));
        }
        return id;
    }

    public Source from(com.oracle.truffle.api.source.Source source) {
        if (source == null) {
            return null;
        }
        Source src = Source.create().setName(source.getName());
        String path = LoadedSourcesHandler.getPath(source);
        if (path != null) {
            src.setPath(path);
        } else {
            src.setSourceReference(this.sourceIDs.get(source));
        }
        return src;
    }

    private static String getPath(com.oracle.truffle.api.source.Source source) {
        URI uri;
        String path = source.getPath();
        if (path == null && (uri = source.getURI()).isAbsolute()) {
            path = uri.getPath();
        }
        return path;
    }
}

