/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import java.util.Collection;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptType;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleObjectsView;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleSummaryView;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleThreadsView;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

final class JavaScriptViews {
    JavaScriptViews() {
    }

    public static class ThreadsViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return new TruffleThreadsView(JavaScriptLanguage.instance(), context, actions);
            }
            return null;
        }
    }

    public static class ObjectsViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return new TruffleObjectsView(JavaScriptLanguage.instance(), context, actions);
            }
            return null;
        }
    }

    public static class SummaryObjectsProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return new TruffleSummaryView.ObjectsSection(JavaScriptLanguage.instance(), context, actions, actionProviders);
            }
            return null;
        }
    }

    private static class SummaryOverview
    extends TruffleSummaryView.OverviewSection {
        SummaryOverview(HeapContext context) {
            super(context, 3, 3);
        }

        @Override
        protected void computeEnvironmentData(Object[][] environmentData) {
            JavaScriptObject process;
            super.computeEnvironmentData(environmentData);
            environmentData[1][0] = "Node.js:";
            environmentData[2][0] = Bundle.JavaScriptViews_Platform();
            JavaScriptHeapFragment fragment = (JavaScriptHeapFragment)this.getContext().getFragment();
            JavaScriptType processType = (JavaScriptType)fragment.getType("process", null);
            JavaScriptObject javaScriptObject = process = processType == null || processType.getObjectsCount() == 0 ? null : (JavaScriptObject)processType.getObjectsIterator().next();
            if (process == null) {
                environmentData[1][1] = Bundle.JavaScriptViews_NotPresent();
                environmentData[2][1] = Bundle.JavaScriptViews_Unknown();
            } else {
                Heap heap = fragment.getHeap();
                FieldValue releaseFV = process.getFieldValue("release");
                if (releaseFV instanceof ObjectFieldValue) {
                    JavaScriptObject releaseO;
                    Instance releaseI = ((ObjectFieldValue)releaseFV).getInstance();
                    if (JavaScriptObject.isJavaScriptObject(releaseI) && "node".equals(SummaryOverview.fieldValue(releaseO = new JavaScriptObject(releaseI), "name", heap))) {
                        String versionFV = SummaryOverview.fieldValue(process, "version", heap);
                        String node = versionFV != null ? "node " + versionFV : Bundle.JavaScriptViews_Unknown();
                        String ltsFV = SummaryOverview.fieldValue(releaseO, "lts", heap);
                        if (ltsFV != null) {
                            node = node + " (" + ltsFV + ")";
                        }
                        environmentData[1][1] = node;
                        String platformFV = SummaryOverview.fieldValue(process, "platform", heap);
                        String archFV = SummaryOverview.fieldValue(process, "arch", heap);
                        if (platformFV == null && archFV == null) {
                            environmentData[2][1] = Bundle.JavaScriptViews_Unknown();
                        } else {
                            String platform = platformFV;
                            if (archFV != null) {
                                platform = platform != null ? platform + " " : "";
                                platform = platform + archFV;
                            }
                            environmentData[2][1] = platform;
                        }
                        return;
                    }
                    environmentData[1][1] = Bundle.JavaScriptViews_Unknown();
                    environmentData[2][1] = Bundle.JavaScriptViews_Unknown();
                    return;
                }
                environmentData[1][1] = Bundle.JavaScriptViews_NotPresent();
                environmentData[2][1] = Bundle.JavaScriptViews_Unknown();
            }
        }

        private static String fieldValue(JavaScriptObject object, String field, Heap heap) {
            FieldValue value = object == null ? null : object.getFieldValue(field);
            Instance instance = value instanceof ObjectFieldValue ? ((ObjectFieldValue)value).getInstance() : null;
            return instance == null ? null : DetailsSupport.getDetailsString((Instance)instance, (Heap)heap);
        }
    }

    public static class SummaryOverviewProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return new SummaryOverview(context);
            }
            return null;
        }
    }

    public static class SummaryViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (JavaScriptHeapFragment.isJavaScriptHeap(context)) {
                return new TruffleSummaryView(JavaScriptLanguage.instance(), context, actions);
            }
            return null;
        }
    }
}

