/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.dynamicobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveType;
import org.graalvm.visualvm.lib.jfluid.heap.Type;
import org.graalvm.visualvm.lib.jfluid.heap.Value;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class DynamicObject
extends TruffleObject.InstanceBased {
    static final String DYNAMIC_OBJECT_FQN = "com.oracle.truffle.api.object.DynamicObject";
    private static final String LOCATION_FQN = "com.oracle.truffle.api.object.Location";
    private static final String ENTERPRISE_PACKAGE = "com.oracle.truffle.object.enterprise";
    private static final String ENTERPRISE_LOCATION_TOP_CLASS = "com.oracle.truffle.object.enterprise.EnterpriseLocations";
    private static final String ENTERPRISE_FIELD_LOCATION_FQN = "com.oracle.truffle.object.enterprise.EnterpriseLocations$FieldLocation";
    private static final String PROPERTY_MAP_FQN = "com.oracle.truffle.object.ConsListPropertyMap";
    private static final String TRIE_PROPERTY_MAP_FQN = "com.oracle.truffle.object.TriePropertyMap";
    private static final String PROPERTY_FQN = "com.oracle.truffle.object.PropertyImpl";
    private static final String OBJECT_TYPE_FQN = "com.oracle.truffle.api.object.ObjectType";
    private final Instance instance;
    private Instance shape;
    private String type;
    private long size = -1L;
    private List<FieldValue> values;
    private List<FieldValue> staticValues;

    public DynamicObject(Instance instance) {
        this(null, instance);
    }

    public DynamicObject(String type, Instance instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        this.instance = instance;
        this.type = type;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    public List<FieldValue> getReferences() {
        ArrayList dynObjRefs = new ArrayList();
        if (this.getShape() != null) {
            List refs = this.instance.getReferences();
            HashSet<Instance> foundRefs = new HashSet<Instance>();
            for (Value ref : refs) {
                Instance instanceRef = ref.getDefiningInstance();
                if (ref instanceof ObjectFieldValue && foundRefs.add(instanceRef)) {
                    this.addReferences(instanceRef, dynObjRefs);
                }
                if (!(ref instanceof ArrayItemValue)) continue;
                List arrRefs = instanceRef.getReferences();
                for (Value arrRef : arrRefs) {
                    Instance arrInstanceRef = arrRef.getDefiningInstance();
                    if (!foundRefs.add(arrInstanceRef)) continue;
                    this.addReferences(instanceRef, arrInstanceRef, dynObjRefs);
                }
            }
        }
        return Collections.unmodifiableList(dynObjRefs);
    }

    public List<FieldValue> getFieldValues() {
        if (this.values == null) {
            this.initFields();
        }
        return this.values;
    }

    public FieldValue getFieldValue(String name) {
        for (FieldValue value : this.getFieldValues()) {
            if (!name.equals(value.getField().getName())) continue;
            return value;
        }
        return null;
    }

    public FieldValue[] getFieldValues(String ... names) {
        FieldValue[] values = new FieldValue[names.length];
        for (FieldValue value : this.getFieldValues()) {
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(value.getField().getName())) continue;
                values[i] = value;
            }
        }
        return values;
    }

    public List<FieldValue> getStaticFieldValues() {
        if (this.staticValues == null) {
            this.initFields();
        }
        return this.staticValues;
    }

    public Instance getShape() {
        if (this.shape == null) {
            this.shape = DynamicObject.getShape(this.instance);
        }
        return this.shape;
    }

    public static Instance getShape(Instance instance) {
        return (Instance)instance.getValueOfField("shape");
    }

    @Override
    public String getType(Heap heap) {
        if (this.type == null) {
            this.type = this.computeType(heap);
            if (this.type == null) {
                this.type = "<unknown type>";
            }
        }
        return this.type;
    }

    @Override
    public long getTypeId(Heap heap) {
        return this.getShape().getInstanceId();
    }

    protected String computeType(Heap heap) {
        return DetailsSupport.getDetailsString((Instance)this.getShape(), (Heap)heap);
    }

    public static String getType(Instance instance, Heap heap) {
        Instance shape = DynamicObject.getShape(instance);
        return DetailsSupport.getDetailsString((Instance)shape, (Heap)heap);
    }

    @Override
    public long getSize() {
        if (this.size == -1L) {
            this.size = this.instance.getSize();
            for (Object fv : this.instance.getFieldValues()) {
                if (!(fv instanceof ObjectFieldValue)) continue;
                ObjectFieldValue ofv = (ObjectFieldValue)fv;
                Instance value = ofv.getInstance();
                if (value instanceof ObjectArrayInstance) {
                    this.size += value.getSize();
                }
                if (!(value instanceof PrimitiveArrayInstance)) continue;
                this.size += value.getSize();
            }
        }
        return this.size;
    }

    @Override
    public long getRetainedSize() {
        return this.instance.getRetainedSize();
    }

    public JavaClass getLanguageId() {
        return DynamicObject.getLanguageIdFromShape(this.getShape());
    }

    public static JavaClass getLanguageId(Instance instance) {
        return DynamicObject.getLanguageIdFromShape(DynamicObject.getShape(instance));
    }

    private void initFields() {
        Instance propertyMap = DynamicObject.getValueofFields(this.instance, "shape", "fastMapRef", "referent");
        if (propertyMap == null) {
            propertyMap = DynamicObject.getValueofFields(this.instance, "shape", "propertyMap");
        }
        if (propertyMap != null) {
            this.values = new ArrayList<FieldValue>();
            this.staticValues = new ArrayList<FieldValue>();
            boolean hasExtRef = this.hasField(this.instance.getJavaClass(), "extRef");
            boolean hasShortNames = this.hasField(this.instance.getJavaClass(), "o0");
            for (Instance ip : DynamicObject.getMapValues(propertyMap)) {
                Property p = new Property(ip, hasExtRef, hasShortNames);
                if (p.isStatic()) {
                    this.staticValues.add(p.getValue(this.instance));
                    continue;
                }
                this.values.add(p.getValue(this.instance));
            }
        } else {
            this.values = Collections.EMPTY_LIST;
            this.staticValues = Collections.EMPTY_LIST;
        }
    }

    private void addReferences(Instance instanceRef, List dynObjRefs) {
        this.addReferences(null, instanceRef, dynObjRefs);
    }

    private void addReferences(Instance baseInstance, Instance instanceRef, List dynObjRefs) {
        if (DynamicObject.isDynamicObject(instanceRef)) {
            DynamicObject dynObj = new DynamicObject(instanceRef);
            List<FieldValue> fieldValues = dynObj.getFieldValues();
            for (FieldValue fieldVal : fieldValues) {
                if (!(fieldVal instanceof ObjectFieldValue)) continue;
                ObjectFieldValue fieldValObj = (ObjectFieldValue)fieldVal;
                if (this.instance.equals(fieldValObj.getInstance())) {
                    dynObjRefs.add(fieldVal);
                }
                if (baseInstance == null || !baseInstance.equals(fieldValObj.getInstance())) continue;
                dynObjRefs.add(fieldVal);
            }
        }
    }

    private boolean hasField(JavaClass jcls, String name) {
        List fields = jcls.getFields();
        for (int i = fields.size() - 1; i >= 0; --i) {
            Field f = (Field)fields.get(i);
            if (!f.getName().equals(name)) continue;
            return true;
        }
        if ((jcls = jcls.getSuperClass()) != null) {
            return this.hasField(jcls, name);
        }
        return false;
    }

    static JavaClass getLanguageIdFromShape(Instance sh) {
        Instance objectType;
        if (sh != null && (objectType = (Instance)sh.getValueOfField("objectType")) != null) {
            JavaClass objTypeCls = objectType.getJavaClass();
            while (objTypeCls != null) {
                JavaClass superObjType = objTypeCls.getSuperClass();
                if (superObjType == null || OBJECT_TYPE_FQN.equals(superObjType.getName())) {
                    return objTypeCls;
                }
                objTypeCls = superObjType;
            }
        }
        return null;
    }

    private static Instance getValueofFields(Instance instance, String ... fields) {
        if (instance != null) {
            for (String field : fields) {
                Object val = instance.getValueOfField(field);
                if (val == null || !(val instanceof Instance)) {
                    return null;
                }
                instance = (Instance)val;
            }
        }
        return instance;
    }

    private static List<Instance> getMapValues(Instance propertyMap) {
        if (propertyMap != null) {
            String mapClass = propertyMap.getJavaClass().getName();
            if (mapClass.equals(HashMap.class.getName())) {
                return DynamicObject.getHashMapValues(propertyMap);
            }
            if (mapClass.equals(PROPERTY_MAP_FQN)) {
                return DynamicObject.getConsListValues(propertyMap);
            }
            if (mapClass.equals(TRIE_PROPERTY_MAP_FQN)) {
                return DynamicObject.getTrieValues(propertyMap);
            }
        }
        return null;
    }

    private static List<Instance> getHashMapValues(Instance propertyMap) {
        ArrayList<Instance> mapValues = new ArrayList<Instance>();
        Object val = propertyMap.getValueOfField("table");
        if (val != null && val instanceof ObjectArrayInstance) {
            ObjectArrayInstance table = (ObjectArrayInstance)val;
            for (Object el : table.getValues()) {
                for (Instance node = (Instance)el; node != null; node = (Instance)node.getValueOfField("next")) {
                    Object value = node.getValueOfField("value");
                    if (value == null || !(value instanceof Instance)) continue;
                    mapValues.add((Instance)value);
                }
            }
        }
        return mapValues;
    }

    private static List<Instance> getConsListValues(Instance propertyMap) {
        ArrayList<Instance> mapValues = new ArrayList<Instance>();
        for (Instance node = propertyMap; node != null; node = (Instance)node.getValueOfField("car")) {
            Object value = node.getValueOfField("cdr");
            if (value == null || !(value instanceof Instance)) continue;
            mapValues.add((Instance)value);
        }
        return mapValues;
    }

    private static List<Instance> getTrieValues(Instance propertyMap) {
        ArrayList<Instance> mapValues = new ArrayList<Instance>();
        Object root = propertyMap.getValueOfField("root");
        DynamicObject.getNodeValues(root, mapValues);
        return mapValues;
    }

    private static boolean getNodeValues(Object nodeObject, List<Instance> nodeValues) {
        Instance node;
        Object entries;
        if (nodeObject instanceof Instance && (entries = (node = (Instance)nodeObject).getValueOfField("entries")) instanceof ObjectArrayInstance) {
            ObjectArrayInstance table = (ObjectArrayInstance)entries;
            for (Object el : table.getValues()) {
                Object value;
                Instance entry = (Instance)el;
                if (DynamicObject.getNodeValues(entry, nodeValues) || !((value = entry.getValueOfField("value")) instanceof Instance)) continue;
                nodeValues.add((Instance)value);
            }
            return true;
        }
        return false;
    }

    private static String getShortInstanceId(Instance instance) {
        if (instance == null) {
            return "null";
        }
        String name = instance.getJavaClass().getName();
        int last = name.lastIndexOf(46);
        if (last != -1) {
            name = name.substring(last + 1);
        }
        return name + "#" + instance.getInstanceNumber();
    }

    private static boolean isSubClassOf(Instance i, String superClassName) {
        if (i != null) {
            for (JavaClass superCls = i.getJavaClass().getSuperClass(); superCls != null; superCls = superCls.getSuperClass()) {
                if (!superCls.getName().equals(superClassName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDynamicObject(Instance dynObj) {
        return DynamicObject.isSubClassOf(dynObj, DYNAMIC_OBJECT_FQN);
    }

    public static boolean hasDynamicObject(Heap heap) {
        JavaClass dynClass = heap.getJavaClassByName(DYNAMIC_OBJECT_FQN);
        return dynClass != null;
    }

    private static boolean isLocationObjSubClass(Instance dynObj) {
        return DynamicObject.isSubClassOf(dynObj, LOCATION_FQN);
    }

    private static boolean isEterpriseFieldLocationObjSubClass(Instance dynObj) {
        return DynamicObject.isSubClassOf(dynObj, ENTERPRISE_FIELD_LOCATION_FQN);
    }

    private static abstract class DynObjObjectFieldValue
    extends DynObjFieldValue
    implements ObjectFieldValue {
        private DynObjObjectFieldValue(Instance i, Property p) {
            super(i, p);
        }
    }

    private static abstract class DynObjFieldValue
    implements FieldValue {
        Instance definingInstance;
        Property field;

        private DynObjFieldValue(Instance i, Property p) {
            this.definingInstance = i;
            this.field = p;
        }

        public Field getField() {
            return this.field;
        }

        public Instance getDefiningInstance() {
            return this.definingInstance;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DynObjFieldValue) {
                DynObjFieldValue dfv = (DynObjFieldValue)obj;
                return this.definingInstance.equals(dfv.definingInstance) && this.field.equals(dfv.field);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.definingInstance.hashCode() + this.field.hashCode();
        }
    }

    private static class PType
    implements PrimitiveType {
        static final PrimitiveType BOOLEAN = new PType("boolean");
        static final PrimitiveType CHAR = new PType("char");
        static final PrimitiveType FLOAT = new PType("float");
        static final PrimitiveType DOUBLE = new PType("double");
        static final PrimitiveType BYTE = new PType("byte");
        static final PrimitiveType SHORT = new PType("short");
        static final PrimitiveType INT = new PType("int");
        static final PrimitiveType LONG = new PType("long");
        private String name;

        PType(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class ObjType
    implements Type {
        static final Type OBJECT = new ObjType();

        private ObjType() {
        }

        public String getName() {
            return "object";
        }
    }

    private static class Property
    implements Field {
        Instance property;
        Instance location;
        String propertyName;
        boolean isStatic;
        boolean hasExtRef;
        boolean hasShortNames;

        private Property(Instance p, boolean extRef, boolean shortNames) {
            assert (p.getJavaClass().getName().equals(DynamicObject.PROPERTY_FQN));
            this.property = p;
            this.propertyName = DetailsUtils.getInstanceString((Instance)p, null);
            this.location = (Instance)this.property.getValueOfField("location");
            this.hasExtRef = extRef;
            this.hasShortNames = shortNames;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        FieldValue getValue(Instance dynamicObject) {
            return this.getValueImpl(this.location, dynamicObject);
        }

        FieldValue getValueImpl(Instance loc, Instance dynamicObject) {
            String superClassName;
            JavaClass locClass = loc.getJavaClass();
            final String className = locClass.getName();
            if (className.contains("Constant")) {
                this.isStatic = true;
                return this.getInstanceFieldValue(dynamicObject, loc, "value");
            }
            if (className.contains("Declared")) {
                this.isStatic = true;
                return this.getInstanceFieldValue(dynamicObject, loc, "value");
            }
            if (className.startsWith(DynamicObject.ENTERPRISE_PACKAGE)) {
                FieldValue val = this.getEnterpriseValue(loc, className, dynamicObject);
                if (val != null) {
                    return val;
                }
            } else {
                if (className.endsWith("Decorator")) {
                    Instance actualLoc = (Instance)loc.getValueOfField("longLocation");
                    FieldValue longValue = this.getValueImpl(actualLoc, dynamicObject);
                    String valString = longValue.getValue();
                    if (className.contains("DoubleLocation")) {
                        Double d = Double.longBitsToDouble(Long.parseLong(valString));
                        valString = d.toString();
                    }
                    if (className.contains("BooleanLocation")) {
                        valString = Boolean.toString(Long.parseLong(valString) != 0L);
                    }
                    return this.getFieldValue(dynamicObject, valString);
                }
                if (className.contains("ObjectArrayLocation")) {
                    Integer index = (Integer)loc.getValueOfField("index");
                    ObjectArrayInstance arr = this.getObjectStore(dynamicObject);
                    return this.getObjectFieldValue(dynamicObject, (Instance)arr.getValues().get(index));
                }
                if (className.contains("LongArrayLocation")) {
                    Integer index = (Integer)loc.getValueOfField("index");
                    if (this.hasExtRef) {
                        PrimitiveArrayInstance arr = (PrimitiveArrayInstance)dynamicObject.getValueOfField("extVal");
                        return this.getFieldValue(dynamicObject, Long.toString(Property.getLong(arr, (int)index)));
                    }
                    PrimitiveArrayInstance arr = (PrimitiveArrayInstance)dynamicObject.getValueOfField("primext");
                    return this.getFieldValue(dynamicObject, (String)arr.getValues().get(index));
                }
            }
            if ((superClassName = locClass.getSuperClass().getName()).contains("SimpleObjectFieldLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                return this.getObjectInstanceFieldValue(dynamicObject, index);
            }
            if (superClassName.contains("SimpleLongFieldLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                return this.getPrimitiveInstanceFieldValue(dynamicObject, index);
            }
            if (superClassName.contains("BasicObjectFieldLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                return this.getObjectInstanceFieldValue(dynamicObject, index);
            }
            if (superClassName.contains("BasicLongFieldLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                return this.getPrimitiveInstanceFieldValue(dynamicObject, index);
            }
            return new DynObjFieldValue(dynamicObject, this){

                public String getValue() {
                    return "Not implemented for " + className;
                }
            };
        }

        private ObjectArrayInstance getObjectStore(Instance dynamicObject) {
            String fieldName = this.hasExtRef ? "extRef" : "objext";
            return (ObjectArrayInstance)dynamicObject.getValueOfField(fieldName);
        }

        private FieldValue getObjectInstanceFieldValue(Instance dynObj, int index) {
            String fieldName = this.getObjectFieldName(index);
            return this.getInstanceFieldValue(dynObj, dynObj, fieldName);
        }

        private FieldValue getPrimitiveInstanceFieldValue(Instance dynObj, int index) {
            String fieldName = this.getPrimitiveFieldName(index);
            return this.getInstanceFieldValue(dynObj, dynObj, fieldName);
        }

        private FieldValue getInstanceFieldValue(Instance dynObj, String fieldName) {
            return this.getInstanceFieldValue(dynObj, dynObj, fieldName);
        }

        private FieldValue getInstanceFieldValue(Instance dynObj, Instance i, String fieldName) {
            for (Object f : i.getFieldValues()) {
                FieldValue fieldValue = (FieldValue)f;
                if (!fieldValue.getField().getName().equals(fieldName)) continue;
                return this.createFieldValue(dynObj, fieldValue);
            }
            return null;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public JavaClass getDeclaringClass() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getName() {
            return this.propertyName;
        }

        public Type getType() {
            String locationClassName = this.location.getJavaClass().getName();
            if (locationClassName.contains("Object")) {
                return ObjType.OBJECT;
            }
            if (locationClassName.contains("Boolean")) {
                return PType.BOOLEAN;
            }
            if (locationClassName.contains("Byte")) {
                return PType.BYTE;
            }
            if (locationClassName.contains("Char")) {
                return PType.CHAR;
            }
            if (locationClassName.contains("Double")) {
                return PType.DOUBLE;
            }
            if (locationClassName.contains("Float")) {
                return PType.FLOAT;
            }
            if (locationClassName.contains("Int")) {
                return PType.INT;
            }
            if (locationClassName.contains("Long")) {
                return PType.LONG;
            }
            if (locationClassName.contains("Short")) {
                return PType.SHORT;
            }
            return ObjType.OBJECT;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Property) {
                Property p = (Property)obj;
                return this.property.equals(p.property);
            }
            return false;
        }

        public int hashCode() {
            return this.property.hashCode();
        }

        private FieldValue createFieldValue(Instance i, final FieldValue fieldValue) {
            if (fieldValue instanceof ObjectFieldValue) {
                return new DynObjObjectFieldValue(i, this){

                    public Instance getInstance() {
                        return ((ObjectFieldValue)fieldValue).getInstance();
                    }

                    public String getValue() {
                        return fieldValue.getValue();
                    }
                };
            }
            return new DynObjFieldValue(i, this){

                public String getValue() {
                    return fieldValue.getValue();
                }
            };
        }

        private FieldValue getFieldValue(Instance dynamicObject, final String value) {
            return new DynObjFieldValue(dynamicObject, this){

                public String getValue() {
                    return value;
                }
            };
        }

        private ObjectFieldValue getObjectFieldValue(Instance dynamicObject, final Instance value) {
            return new DynObjObjectFieldValue(dynamicObject, this){

                public Instance getInstance() {
                    return value;
                }

                public String getValue() {
                    return String.valueOf(value.getInstanceId());
                }
            };
        }

        private FieldValue getEnterpriseValue(Instance loc, String className, Instance dynamicObject) {
            if (className.length() - DynamicObject.ENTERPRISE_PACKAGE.length() < 5) {
                return this.getObfuscatedEnperpriseValue(loc, className, dynamicObject);
            }
            if (className.length() - DynamicObject.ENTERPRISE_LOCATION_TOP_CLASS.length() < 4) {
                return this.getObfuscatedEnperpriseValue(loc, className, dynamicObject);
            }
            if (className.endsWith("Decorator")) {
                Instance actualLoc = (Instance)loc.getValueOfField("actualLocation");
                return this.getValueImpl(actualLoc, dynamicObject);
            }
            if (className.contains("ObjectFieldLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                int objectIndex = this.hasExtRef ? index : index + 2;
                String prefix = this.hasShortNames ? "o" : "object";
                FieldValue ret = this.getInstanceFieldValue(dynamicObject, prefix + objectIndex);
                if (ret == null) {
                    return this.getObjectFieldValue(dynamicObject, (Instance)dynamicObject.getValueOfField("extVal"));
                }
                return ret;
            }
            if (className.contains("IntFieldLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                int objectIndex = this.hasExtRef ? index : index + 1;
                String prefix = this.hasShortNames ? "p" : "primitive";
                return this.getInstanceFieldValue(dynamicObject, prefix + objectIndex);
            }
            if (className.contains("BooleanFieldLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                int objectIndex = this.hasExtRef ? index : index + 1;
                String prefix = this.hasShortNames ? "p" : "primitive";
                Integer i1 = (Integer)dynamicObject.getValueOfField(prefix + objectIndex);
                return this.getFieldValue(dynamicObject, Boolean.toString(i1 != 0));
            }
            if (className.contains("DoubleFieldLocation")) {
                long val;
                Integer index = (Integer)loc.getValueOfField("index");
                int objectIndex = this.hasExtRef ? index : index + 1;
                String prefix = this.hasShortNames ? "p" : "primitive";
                Number i1 = (Number)dynamicObject.getValueOfField(prefix + objectIndex);
                if (i1 instanceof Long) {
                    val = i1.longValue();
                } else {
                    Integer i2 = (Integer)dynamicObject.getValueOfField(prefix + (objectIndex + 1));
                    val = Property.getLong(i1.intValue(), i2);
                }
                return this.getFieldValue(dynamicObject, Property.getDouble(val));
            }
            if (className.contains("LongFieldLocation")) {
                long val;
                Integer index = (Integer)loc.getValueOfField("index");
                int objectIndex = this.hasExtRef ? index : index + 1;
                String prefix = this.hasShortNames ? "p" : "primitive";
                Number i1 = (Number)dynamicObject.getValueOfField(prefix + objectIndex);
                if (i1 instanceof Long) {
                    val = i1.longValue();
                } else {
                    Integer i2 = (Integer)dynamicObject.getValueOfField(prefix + (objectIndex + 1));
                    val = Property.getLong(i1.intValue(), i2);
                }
                return this.getFieldValue(dynamicObject, Long.toString(val));
            }
            if (className.contains("ObjectArrayLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                ObjectArrayInstance arr = this.getEnterpriseObjectStore(dynamicObject);
                return this.getObjectFieldValue(dynamicObject, (Instance)arr.getValues().get(index));
            }
            if (className.contains("IntArrayLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                Instance actualLoc = (Instance)loc.getValueOfField("arrayLocation");
                ObjectFieldValue arrayVal = (ObjectFieldValue)this.getValueImpl(actualLoc, dynamicObject);
                PrimitiveArrayInstance arr = (PrimitiveArrayInstance)arrayVal.getInstance();
                return this.getFieldValue(dynamicObject, (String)arr.getValues().get(index));
            }
            if (className.contains("DoubleArrayLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                Instance actualLoc = (Instance)loc.getValueOfField("arrayLocation");
                ObjectFieldValue arrayVal = (ObjectFieldValue)this.getValueImpl(actualLoc, dynamicObject);
                PrimitiveArrayInstance arr = (PrimitiveArrayInstance)arrayVal.getInstance();
                return this.getFieldValue(dynamicObject, Property.getDouble(Property.getLong(arr, (int)index)));
            }
            if (className.contains("LongArrayLocation")) {
                Integer index = (Integer)loc.getValueOfField("index");
                Instance actualLoc = (Instance)loc.getValueOfField("arrayLocation");
                ObjectFieldValue arrayVal = (ObjectFieldValue)this.getValueImpl(actualLoc, dynamicObject);
                PrimitiveArrayInstance arr = (PrimitiveArrayInstance)arrayVal.getInstance();
                return this.getFieldValue(dynamicObject, Long.toString(Property.getLong(arr, (int)index)));
            }
            return null;
        }

        private ObjectArrayInstance getEnterpriseObjectStore(Instance dynamicObject) {
            String fieldName = this.hasExtRef ? "extRef" : "object1";
            return (ObjectArrayInstance)dynamicObject.getValueOfField(fieldName);
        }

        private FieldValue getObfuscatedEnperpriseValue(Instance loc, String className, Instance dynamicObject) {
            String typeName;
            Field f;
            FieldValue fv;
            Boolean locAllowInt;
            Integer locIndex;
            Boolean allowInt;
            Integer index;
            List fields = loc.getFieldValues();
            if (fields.size() == 2) {
                FieldValue v0 = (FieldValue)fields.get(0);
                FieldValue v1 = (FieldValue)fields.get(1);
                Type t0 = v0.getField().getType();
                Type t1 = v1.getField().getType();
                if (t0.getName().equals("object") && t1.getName().equals("object")) {
                    Instance i0 = ((ObjectFieldValue)v0).getInstance();
                    Instance i1 = ((ObjectFieldValue)v1).getInstance();
                    if (DynamicObject.isLocationObjSubClass(i0)) {
                        return this.getValueImpl(i0, dynamicObject);
                    }
                    if (DynamicObject.isLocationObjSubClass(i1)) {
                        return this.getValueImpl(i1, dynamicObject);
                    }
                }
            }
            if (loc.getValueOfField("arrayLocation") != null && loc.getValueOfField("index") != null) {
                index = (Integer)loc.getValueOfField("index");
                Instance actualLoc = (Instance)loc.getValueOfField("arrayLocation");
                allowInt = (Boolean)loc.getValueOfField("allowInt");
                return this.getObfuscatedEnterpriseArrayLocation(dynamicObject, loc, index, actualLoc, allowInt);
            }
            if (loc.getValueOfField("index") != null && loc.getValueOfField("offset") != null) {
                index = (Integer)loc.getValueOfField("index");
                Instance type = (Instance)loc.getValueOfField("type");
                allowInt = (Boolean)loc.getValueOfField("allowInt");
                return this.getObfuscatedEnterpriseFieldLocation(dynamicObject, loc, index, type, allowInt);
            }
            if (DynamicObject.isEterpriseFieldLocationObjSubClass(loc) && loc.getValueOfField("offset") != null) {
                locIndex = null;
                Instance locType = null;
                locAllowInt = null;
                for (Object obj : fields) {
                    fv = (FieldValue)obj;
                    f = fv.getField();
                    typeName = f.getType().getName();
                    if ("object".equals(typeName) && !f.getName().equals("tclass")) {
                        locType = ((ObjectFieldValue)fv).getInstance();
                    }
                    if ("boolean".equals(typeName) && fields.size() == 3 && f.getDeclaringClass().getSubClasses().size() == 1) {
                        locAllowInt = (Boolean)loc.getValueOfField(f.getName());
                    }
                    if (!"int".equals(typeName) || f.getName().equals("offset")) continue;
                    locIndex = (Integer)loc.getValueOfField(f.getName());
                }
                if (locIndex != null) {
                    return this.getObfuscatedEnterpriseFieldLocation(dynamicObject, loc, locIndex, locType, locAllowInt);
                }
            }
            if (fields.size() >= 2) {
                locIndex = null;
                Instance locArrayLocation = null;
                locAllowInt = null;
                for (Object obj : fields) {
                    Instance val;
                    fv = (FieldValue)obj;
                    f = fv.getField();
                    typeName = f.getType().getName();
                    if ("object".equals(typeName) && DynamicObject.isLocationObjSubClass(val = ((ObjectFieldValue)fv).getInstance())) {
                        locArrayLocation = val;
                    }
                    if ("boolean".equals(typeName) && fields.size() == 3 && f.getDeclaringClass().getSubClasses().size() == 2) {
                        locAllowInt = (Boolean)loc.getValueOfField(f.getName());
                    }
                    if (!"int".equals(typeName)) continue;
                    locIndex = (Integer)loc.getValueOfField(f.getName());
                }
                if (locIndex != null && locArrayLocation != null) {
                    return this.getObfuscatedEnterpriseArrayLocation(dynamicObject, loc, locIndex, locArrayLocation, locAllowInt);
                }
            }
            if (fields.size() == 1) {
                this.isStatic = true;
                FieldValue staticFieldVal = (FieldValue)fields.get(0);
                return this.createFieldValue(dynamicObject, staticFieldVal);
            }
            return null;
        }

        private FieldValue getObfuscatedEnterpriseArrayLocation(Instance dynamicObject, Instance loc, Integer index, Instance actualLoc, Boolean allowInt) {
            ObjectFieldValue arrayVal = (ObjectFieldValue)this.getValueImpl(actualLoc, dynamicObject);
            Instance array = arrayVal.getInstance();
            if (array instanceof PrimitiveArrayInstance) {
                PrimitiveArrayInstance arr = (PrimitiveArrayInstance)array;
                if (allowInt != null) {
                    return this.getFieldValue(dynamicObject, Property.getDouble(Property.getLong(arr, (int)index)));
                }
                return this.getFieldValue(dynamicObject, (String)arr.getValues().get(index));
            }
            if (array instanceof ObjectArrayInstance) {
                ObjectArrayInstance arr = (ObjectArrayInstance)array;
                return this.getObjectFieldValue(dynamicObject, (Instance)arr.getValues().get(index));
            }
            return null;
        }

        private FieldValue getObfuscatedEnterpriseFieldLocation(Instance dynamicObject, Instance loc, Integer index, Instance type, Boolean allowInt) {
            if (type != null) {
                if (index == 0) {
                    ObjectFieldValue valarr;
                    Instance valueArr;
                    long typeClassId = type.getInstanceId();
                    ObjectFieldValue val = (ObjectFieldValue)this.getDynamicObjectField(dynamicObject, index + 1);
                    Instance value = val.getInstance();
                    if (value != null) {
                        for (JavaClass valueClass = value.getJavaClass(); valueClass != null; valueClass = valueClass.getSuperClass()) {
                            if (valueClass.getJavaClassId() != typeClassId) continue;
                            if (this.isLayoutObjectArrayLocation(loc, valueClass, dynamicObject)) break;
                            return val;
                        }
                    }
                    if ((valueArr = (valarr = (ObjectFieldValue)this.getDynamicObjectField(dynamicObject, index)).getInstance()) != null && valueArr.getJavaClass().getJavaClassId() == typeClassId) {
                        return valarr;
                    }
                    return val;
                }
                return this.getDynamicObjectField(dynamicObject, index + 1);
            }
            if (loc.getFieldValues().size() > 2) {
                if (allowInt != null) {
                    FieldValue fv1 = this.getDynamicObjectPrimitiveField(dynamicObject, index);
                    FieldValue fv2 = this.getDynamicObjectPrimitiveField(dynamicObject, index + 1);
                    Integer i1 = Integer.valueOf(fv1.getValue());
                    Integer i2 = Integer.valueOf(fv2.getValue());
                    return this.getFieldValue(dynamicObject, Property.getDouble(Property.getLong(i1, i2)));
                }
                if (loc.getFieldValues().size() == 3 && loc.getValueOfField("tclass") != null) {
                    return this.getDynamicObjectPrimitiveField(dynamicObject, index);
                }
                return this.getDynamicObjectField(dynamicObject, index + 1);
            }
            return this.getDynamicObjectPrimitiveField(dynamicObject, index);
        }

        private boolean isLayoutObjectArrayLocation(Instance location, JavaClass valueClass, Instance dynamicObject) {
            if (valueClass.isArray() && "java.lang.Object[]".equals(valueClass.getName())) {
                Instance layout = (Instance)DynamicObject.getShape(dynamicObject).getValueOfField("layout");
                for (Object fv : layout.getFieldValues()) {
                    if (!(fv instanceof ObjectFieldValue) || !location.equals(((ObjectFieldValue)fv).getInstance())) continue;
                    return true;
                }
            }
            return false;
        }

        private FieldValue getDynamicObjectPrimitiveField(Instance dynamicObject, int index) {
            return this.getDynamicObjectField(dynamicObject, index, false);
        }

        private FieldValue getDynamicObjectField(Instance dynamicObject, int index) {
            return this.getDynamicObjectField(dynamicObject, index, true);
        }

        private FieldValue getDynamicObjectField(Instance dynamicObject, int index, boolean objectType) {
            List fields = dynamicObject.getJavaClass().getFields();
            for (int i = fields.size() - 1; i >= 0; --i) {
                Field f = (Field)fields.get(i);
                if (f.getType().getName().equals("object") != objectType) continue;
                if (index == 0) {
                    return this.createFieldValue(dynamicObject, this.getValueOfField(dynamicObject, f));
                }
                --index;
            }
            throw new IllegalArgumentException();
        }

        private FieldValue getValueOfField(Instance dynamicObject, Field field) {
            List fieldVals = dynamicObject.getFieldValues();
            for (int i = 0; i < fieldVals.size(); ++i) {
                FieldValue fv = (FieldValue)fieldVals.get(i);
                if (!fv.getField().equals(field)) continue;
                return fv;
            }
            throw new IllegalArgumentException(field.getName());
        }

        private static long getLong(Integer i1, Integer i2) {
            return i2.longValue() << 32 | i1.longValue() & 0xFFFFFFFFL;
        }

        private static long getLong(PrimitiveArrayInstance arr, int index) {
            List vals = arr.getValues();
            Integer i1 = Integer.valueOf((String)vals.get(index));
            Integer i2 = Integer.valueOf((String)vals.get(index + 1));
            return Property.getLong(i1, i2);
        }

        private static String getDouble(long l) {
            double d = Double.longBitsToDouble(l);
            return Double.toString(d);
        }

        private String getObjectFieldName(int index) {
            if (this.hasShortNames) {
                return "o" + index;
            }
            return "object" + (index + 1);
        }

        private String getPrimitiveFieldName(int index) {
            if (this.hasShortNames) {
                return "p" + index;
            }
            return "primitive" + (index + 1);
        }
    }
}

