/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.impl.FunctionExecuteNode;
import com.oracle.truffle.nfi.impl.FunctionExecuteNodeGen;
import com.oracle.truffle.nfi.impl.LibFFISignature;
import com.oracle.truffle.nfi.impl.NFIContext;
import com.oracle.truffle.nfi.impl.NFILanguageImpl;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LibFFISignature.class)
final class LibFFISignatureGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private LibFFISignatureGen() {
    }

    static {
        LibraryExport.register(LibFFISignature.class, (LibraryExport[])new LibraryExport[]{new NFIBackendSignatureLibraryExports()});
    }

    @GeneratedBy(value=LibFFISignature.class)
    private static final class NFIBackendSignatureLibraryExports
    extends LibraryExport<NFIBackendSignatureLibrary> {
        private NFIBackendSignatureLibraryExports() {
            super(NFIBackendSignatureLibrary.class, LibFFISignature.class, false);
        }

        protected NFIBackendSignatureLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFISignature);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected NFIBackendSignatureLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFISignature);
            return new Cached();
        }

        @GeneratedBy(value=LibFFISignature.class)
        private static final class Uncached
        extends NFIBackendSignatureLibrary {
            private final TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_ = this.lookupContextReference(NFILanguageImpl.class);

            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                return arg0Value.call(arg1Value, arg2Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), BranchProfile.getUncached(), BranchProfile.getUncached(), FunctionExecuteNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                return LibFFISignature.createClosure(arg0Value, arg1Value, this.nFILanguageImplContextReference_);
            }
        }

        @GeneratedBy(value=LibFFISignature.class)
        private static final class Cached
        extends NFIBackendSignatureLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference_;
            @Node.Child
            private CallNode_Call0Data callNode__call0_cache;
            @CompilerDirectives.CompilationFinal
            private BranchProfile callNode__call1_toNative_;
            @CompilerDirectives.CompilationFinal
            private BranchProfile callNode__call1_error_;
            @Node.Child
            private FunctionExecuteNode callNode__call1_functionExecute_;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof LibFFISignature) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof LibFFISignature;
            }

            @Override
            @ExplodeLoop
            public Object call(Object arg0Value_, Object arg1Value, Object ... arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0) {
                        CallNode_Call0Data s1_ = this.callNode__call0_cache;
                        while (s1_ != null) {
                            if (s1_.interop_.accepts(arg1Value)) {
                                return arg0Value.call(arg1Value, arg2Value, s1_.interop_, s1_.toNative_, s1_.error_, s1_.functionExecute_);
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return this.call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.callNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private Object call1Boundary(int state_0, LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary callNode__call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                    Object object = arg0Value.call(arg1Value, arg2Value, callNode__call1_interop__, this.callNode__call1_toNative_, this.callNode__call1_error_, this.callNode__call1_functionExecute_);
                    return object;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object callNode_AndSpecialize(LibFFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                int exclude = this.exclude_;
                try {
                    Object object;
                    if (exclude == 0) {
                        int count1_ = 0;
                        CallNode_Call0Data s1_ = this.callNode__call0_cache;
                        if ((state_0 & 1) != 0) {
                            while (s1_ != null && !s1_.interop_.accepts(arg1Value)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 3) {
                            s1_ = (CallNode_Call0Data)super.insert((Node)new CallNode_Call0Data(this.callNode__call0_cache));
                            s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value));
                            s1_.toNative_ = BranchProfile.create();
                            s1_.error_ = BranchProfile.create();
                            s1_.functionExecute_ = s1_.insertAccessor(FunctionExecuteNodeGen.create());
                            this.callNode__call0_cache = s1_;
                            this.state_0_ = state_0 |= 1;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object2 = arg0Value.call(arg1Value, arg2Value, s1_.interop_, s1_.toNative_, s1_.error_, s1_.functionExecute_);
                            return object2;
                        }
                    }
                    InteropLibrary callNode__call1_interop__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        callNode__call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                        this.callNode__call1_toNative_ = BranchProfile.create();
                        this.callNode__call1_error_ = BranchProfile.create();
                        this.callNode__call1_functionExecute_ = (FunctionExecuteNode)super.insert((Node)FunctionExecuteNodeGen.create());
                        this.exclude_ = exclude |= 1;
                        this.callNode__call0_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        object = arg0Value.call(arg1Value, arg2Value, callNode__call1_interop__, this.callNode__call1_toNative_, this.callNode__call1_error_, this.callNode__call1_functionExecute_);
                    }
                    catch (Throwable throwable) {
                        encapsulating_.set(prev_);
                        throw throwable;
                    }
                    encapsulating_.set(prev_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                CallNode_Call0Data s1_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0 && ((s1_ = this.callNode__call0_cache) == null || s1_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Object createClosure(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
                LibFFISignature arg0Value = (LibFFISignature)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0) {
                    TruffleLanguage.ContextReference<NFIContext> nFILanguageImplContextReference__;
                    TruffleLanguage.ContextReference<NFIContext> createClosureNode__ctxRef__ = nFILanguageImplContextReference__ = this.nFILanguageImplContextReference_;
                    return LibFFISignature.createClosure(arg0Value, arg1Value, createClosureNode__ctxRef__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.createClosureNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object createClosureNode_AndSpecialize(LibFFISignature arg0Value, Object arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    TruffleLanguage.ContextReference createClosureNode__ctxRef__ = null;
                    TruffleLanguage.ContextReference nFILanguageImplContextReference__1 = this.nFILanguageImplContextReference_;
                    if (nFILanguageImplContextReference__1 == null) {
                        this.nFILanguageImplContextReference_ = nFILanguageImplContextReference__1 = super.lookupContextReference(NFILanguageImpl.class);
                    }
                    createClosureNode__ctxRef__ = nFILanguageImplContextReference__1;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = LibFFISignature.createClosure(arg0Value, arg1Value, (TruffleLanguage.ContextReference<NFIContext>)createClosureNode__ctxRef__);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @GeneratedBy(value=LibFFISignature.class)
            private static final class CallNode_Call0Data
            extends Node {
                @Node.Child
                CallNode_Call0Data next_;
                @Node.Child
                InteropLibrary interop_;
                @CompilerDirectives.CompilationFinal
                BranchProfile toNative_;
                @CompilerDirectives.CompilationFinal
                BranchProfile error_;
                @Node.Child
                FunctionExecuteNode functionExecute_;

                CallNode_Call0Data(CallNode_Call0Data next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return (T)super.insert(node);
                }
            }
        }
    }
}

