/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.nfi.API;
import com.oracle.truffle.nfi.NFISymbol;
import com.oracle.truffle.nfi.spi.NFIBackend;
import com.oracle.truffle.nfi.spi.NFIBackendFactory;
import com.oracle.truffle.nfi.spi.NFIBackendTools;
import org.graalvm.collections.EconomicMap;

final class NFIContext {
    TruffleLanguage.Env env;
    final EconomicMap<String, API> apiCache = EconomicMap.create();

    NFIContext(TruffleLanguage.Env env) {
        this.env = env;
    }

    void patch(TruffleLanguage.Env newEnv) {
        this.env = newEnv;
        this.apiCache.clear();
    }

    NFIBackend getBackend(String id) {
        return this.getAPI((String)id).backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    API getAPI(String backendId) {
        API ret = (API)this.apiCache.get((Object)backendId);
        if (ret != null) {
            return ret;
        }
        EconomicMap<String, API> economicMap = this.apiCache;
        synchronized (economicMap) {
            ret = (API)this.apiCache.get((Object)backendId);
            if (ret != null) {
                return ret;
            }
            for (LanguageInfo language : this.env.getInternalLanguages().values()) {
                NFIBackendFactory backendFactory;
                if ("nfi".equals(language.getId()) || (backendFactory = (NFIBackendFactory)this.env.lookup(language, NFIBackendFactory.class)) == null || !backendFactory.getBackendId().equals(backendId)) continue;
                this.env.initializeLanguage(language);
                NFIBackend backend = backendFactory.createBackend(new NFIBackendToolsImpl(backendId));
                API api = new API(backendId, backend);
                this.apiCache.put((Object)backendFactory.getBackendId(), (Object)api);
                return api;
            }
        }
        return null;
    }

    private static final class NFIBackendToolsImpl
    extends NFIBackendTools {
        private final String backend;

        NFIBackendToolsImpl(String backend) {
            this.backend = backend.intern();
        }

        @Override
        public Object createBindableSymbol(Object symbol) {
            return NFISymbol.createBindable(this.backend, symbol);
        }
    }
}

