/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.nfi.CallSignatureNode;
import com.oracle.truffle.nfi.ConvertTypeNode;
import com.oracle.truffle.nfi.ConvertTypeNodeFactory;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFIType;
import com.oracle.truffle.nfi.spi.NFIBackendSignatureLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=CallSignatureNode.class)
final class CallSignatureNodeFactory {
    private static final LibraryFactory<NFIBackendSignatureLibrary> N_F_I_BACKEND_SIGNATURE_LIBRARY_ = LibraryFactory.resolve(NFIBackendSignatureLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    CallSignatureNodeFactory() {
    }

    @GeneratedBy(value=CallSignatureNode.OptimizedCallClosureNode.class)
    static final class OptimizedCallClosureNodeGen
    extends CallSignatureNode.OptimizedCallClosureNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile call0_exception_;
        @Node.Child
        private InteropLibrary call0_interop_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile call1_exception_;

        private OptimizedCallClosureNodeGen(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            super(retType, argsState);
        }

        @Override
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && this.call0_interop_.accepts(arg1Value)) {
                    return this.doCall(arg0Value, arg1Value, arg2Value, this.call0_exception_, this.call0_interop_);
                }
                if ((state_0 & 2) != 0) {
                    return this.call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object call1Boundary(int state_0, NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                InteropLibrary call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                Object object = this.doCall(arg0Value, arg1Value, arg2Value, this.call1_exception_, call1_interop__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                Object object;
                if (exclude == 0) {
                    boolean Call0_duplicateFound_ = false;
                    if ((state_0 & 1) != 0 && this.call0_interop_.accepts(arg1Value)) {
                        Call0_duplicateFound_ = true;
                    }
                    if (!Call0_duplicateFound_ && (state_0 & 1) == 0) {
                        this.call0_exception_ = BranchProfile.create();
                        this.call0_interop_ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)));
                        this.state_0_ = state_0 |= 1;
                        Call0_duplicateFound_ = true;
                    }
                    if (Call0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.doCall(arg0Value, arg1Value, arg2Value, this.call0_exception_, this.call0_interop_);
                        return object2;
                    }
                }
                InteropLibrary call1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    this.call1_exception_ = BranchProfile.create();
                    call1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value);
                    this.exclude_ = exclude |= 1;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.doCall(arg0Value, arg1Value, arg2Value, this.call1_exception_, call1_interop__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CallSignatureNode.OptimizedCallClosureNode create(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            return new OptimizedCallClosureNodeGen(retType, argsState);
        }
    }

    @GeneratedBy(value=CallSignatureNode.OptimizedCallSignatureNode.class)
    static final class OptimizedCallSignatureNodeGen
    extends CallSignatureNode.OptimizedCallSignatureNode {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile call0_exception_;
        @Node.Child
        private NFIBackendSignatureLibrary call0_backendLibrary_;
        @CompilerDirectives.CompilationFinal
        private BranchProfile call1_exception_;

        private OptimizedCallSignatureNodeGen(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            super(retType, argsState);
        }

        @Override
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && this.call0_backendLibrary_.accepts(arg0Value.nativeSignature)) {
                    return this.doCall(arg0Value, arg1Value, arg2Value, this.call0_exception_, this.call0_backendLibrary_);
                }
                if ((state_0 & 2) != 0) {
                    return this.call1Boundary(state_0, arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object call1Boundary(int state_0, NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                NFIBackendSignatureLibrary call1_backendLibrary__ = (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached(arg0Value.nativeSignature);
                Object object = this.doCall(arg0Value, arg1Value, arg2Value, this.call1_exception_, call1_backendLibrary__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                Object object;
                if (exclude == 0) {
                    boolean Call0_duplicateFound_ = false;
                    if ((state_0 & 1) != 0 && this.call0_backendLibrary_.accepts(arg0Value.nativeSignature)) {
                        Call0_duplicateFound_ = true;
                    }
                    if (!Call0_duplicateFound_ && (state_0 & 1) == 0) {
                        this.call0_exception_ = BranchProfile.create();
                        this.call0_backendLibrary_ = (NFIBackendSignatureLibrary)super.insert((Node)((NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(arg0Value.nativeSignature)));
                        this.state_0_ = state_0 |= 1;
                        Call0_duplicateFound_ = true;
                    }
                    if (Call0_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        Object object2 = this.doCall(arg0Value, arg1Value, arg2Value, this.call0_exception_, this.call0_backendLibrary_);
                        return object2;
                    }
                }
                NFIBackendSignatureLibrary call1_backendLibrary__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    this.call1_exception_ = BranchProfile.create();
                    call1_backendLibrary__ = (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached(arg0Value.nativeSignature);
                    this.exclude_ = exclude |= 1;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    object = this.doCall(arg0Value, arg1Value, arg2Value, this.call1_exception_, call1_backendLibrary__);
                }
                catch (Throwable throwable) {
                    encapsulating_.set(prev_);
                    throw throwable;
                }
                encapsulating_.set(prev_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CallSignatureNode.OptimizedCallSignatureNode create(NFIType.TypeCachedState retType, NFISignature.ArgsCachedState argsState) {
            return new OptimizedCallSignatureNodeGen(retType, argsState);
        }
    }

    @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
    static final class CachedCallSignatureNodeGen
    extends CallSignatureNode.CachedCallSignatureNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private OptimizedDirectData optimizedDirect_cache;
        @Node.Child
        private IndirectCallNode optimizedIndirect_call_;
        @Node.Child
        private SlowPath0Data slowPath0_cache;
        @Node.Child
        private SlowPath1Data slowPath1_cache;

        private CachedCallSignatureNodeGen() {
        }

        @Override
        @ExplodeLoop
        Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                SlowPath1Data s4_;
                if ((state_0 & 1) != 0) {
                    OptimizedDirectData s1_ = this.optimizedDirect_cache;
                    while (s1_ != null) {
                        assert (s1_.cachedState_ != null);
                        if (arg0Value.cachedState == s1_.cachedState_) {
                            return this.doOptimizedDirect(arg0Value, arg1Value, arg2Value, s1_.cachedState_, s1_.call_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0 && arg0Value.cachedState != null) {
                    return this.doOptimizedIndirect(arg0Value, arg1Value, arg2Value, this.optimizedIndirect_call_);
                }
                if ((state_0 & 4) != 0) {
                    SlowPath0Data s3_ = this.slowPath0_cache;
                    while (s3_ != null) {
                        if (s3_.nativeLibrary_.accepts(arg0Value.nativeSignature) && arg0Value.cachedState == null) {
                            return this.doSlowPath(arg0Value, arg1Value, arg2Value, s3_.exception_, s3_.convertArg_, s3_.convertRet_, s3_.nativeLibrary_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 8) != 0 && (s4_ = this.slowPath1_cache) != null && arg0Value.cachedState == null) {
                    return this.slowPath1Boundary(state_0, s4_, arg0Value, arg1Value, arg2Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object slowPath1Boundary(int state_0, SlowPath1Data s4_, NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                NFIBackendSignatureLibrary nativeLibrary__ = (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached(arg0Value.nativeSignature);
                Object object = this.doSlowPath(arg0Value, arg1Value, arg2Value, s4_.exception_, s4_.convertArg_, s4_.convertRet_, nativeLibrary__);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                Object cachedState__;
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    OptimizedDirectData s1_ = this.optimizedDirect_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null) {
                            assert (s1_.cachedState_ != null);
                            if (arg0Value.cachedState == s1_.cachedState_) break;
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (cachedState__ = arg0Value.cachedState) != null && count1_ < 3) {
                        s1_ = (OptimizedDirectData)super.insert((Node)new OptimizedDirectData(this.optimizedDirect_cache));
                        s1_.cachedState_ = cachedState__;
                        s1_.call_ = s1_.insertAccessor(((NFISignature.SignatureCachedState)cachedState__).createOptimizedSignatureCall());
                        this.optimizedDirect_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedState__ = this.doOptimizedDirect(arg0Value, arg1Value, arg2Value, s1_.cachedState_, s1_.call_);
                        return cachedState__;
                    }
                }
                if (arg0Value.cachedState != null) {
                    this.optimizedIndirect_call_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
                    this.exclude_ = exclude |= 1;
                    this.optimizedDirect_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object count1_ = this.doOptimizedIndirect(arg0Value, arg1Value, arg2Value, this.optimizedIndirect_call_);
                    return count1_;
                }
                if ((exclude & 2) == 0) {
                    int count3_ = 0;
                    SlowPath0Data s3_ = this.slowPath0_cache;
                    if ((state_0 & 4) != 0) {
                        while (!(s3_ == null || s3_.nativeLibrary_.accepts(arg0Value.nativeSignature) && arg0Value.cachedState == null)) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && arg0Value.cachedState == null && count3_ < 3) {
                        s3_ = (SlowPath0Data)super.insert((Node)new SlowPath0Data(this.slowPath0_cache));
                        s3_.exception_ = BranchProfile.create();
                        s3_.convertArg_ = s3_.insertAccessor(ConvertTypeNodeFactory.ConvertToNativeNodeGen.create());
                        s3_.convertRet_ = s3_.insertAccessor(ConvertTypeNodeFactory.ConvertFromNativeNodeGen.create());
                        s3_.nativeLibrary_ = s3_.insertAccessor((NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.create(arg0Value.nativeSignature));
                        this.slowPath0_cache = s3_;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        cachedState__ = this.doSlowPath(arg0Value, arg1Value, arg2Value, s3_.exception_, s3_.convertArg_, s3_.convertRet_, s3_.nativeLibrary_);
                        return cachedState__;
                    }
                }
                NFIBackendSignatureLibrary nativeLibrary__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    if (arg0Value.cachedState == null) {
                        SlowPath1Data s4_ = (SlowPath1Data)super.insert((Node)new SlowPath1Data());
                        s4_.exception_ = BranchProfile.create();
                        s4_.convertArg_ = s4_.insertAccessor(ConvertTypeNodeFactory.ConvertToNativeNodeGen.create());
                        s4_.convertRet_ = s4_.insertAccessor(ConvertTypeNodeFactory.ConvertFromNativeNodeGen.create());
                        nativeLibrary__ = (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached(arg0Value.nativeSignature);
                        this.slowPath1_cache = s4_;
                        this.exclude_ = exclude |= 2;
                        this.slowPath0_cache = null;
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doSlowPath(arg0Value, arg1Value, arg2Value, s4_.exception_, s4_.convertArg_, s4_.convertRet_, nativeLibrary__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                OptimizedDirectData s1_ = this.optimizedDirect_cache;
                SlowPath0Data s3_ = this.slowPath0_cache;
                if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static CallSignatureNode.CachedCallSignatureNode create() {
            return new CachedCallSignatureNodeGen();
        }

        public static CallSignatureNode.CachedCallSignatureNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
        private static final class Uncached
        extends CallSignatureNode.CachedCallSignatureNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(NFISignature arg0Value, Object arg1Value, Object[] arg2Value) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                if (arg0Value.cachedState != null) {
                    return this.doOptimizedIndirect(arg0Value, arg1Value, arg2Value, IndirectCallNode.getUncached());
                }
                if (arg0Value.cachedState == null) {
                    return this.doSlowPath(arg0Value, arg1Value, arg2Value, BranchProfile.getUncached(), ConvertTypeNodeFactory.ConvertToNativeNodeGen.getUncached(), ConvertTypeNodeFactory.ConvertFromNativeNodeGen.getUncached(), (NFIBackendSignatureLibrary)N_F_I_BACKEND_SIGNATURE_LIBRARY_.getUncached(arg0Value.nativeSignature));
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
        private static final class SlowPath1Data
        extends Node {
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;
            @Node.Child
            ConvertTypeNode.ConvertToNativeNode convertArg_;
            @Node.Child
            ConvertTypeNode.ConvertFromNativeNode convertRet_;

            SlowPath1Data() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
        private static final class SlowPath0Data
        extends Node {
            @Node.Child
            SlowPath0Data next_;
            @CompilerDirectives.CompilationFinal
            BranchProfile exception_;
            @Node.Child
            ConvertTypeNode.ConvertToNativeNode convertArg_;
            @Node.Child
            ConvertTypeNode.ConvertFromNativeNode convertRet_;
            @Node.Child
            NFIBackendSignatureLibrary nativeLibrary_;

            SlowPath0Data(SlowPath0Data next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }

        @GeneratedBy(value=CallSignatureNode.CachedCallSignatureNode.class)
        private static final class OptimizedDirectData
        extends Node {
            @Node.Child
            OptimizedDirectData next_;
            @CompilerDirectives.CompilationFinal
            NFISignature.SignatureCachedState cachedState_;
            @Node.Child
            CallSignatureNode call_;

            OptimizedDirectData(OptimizedDirectData next_) {
                this.next_ = next_;
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }
}

