/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.NFIContext;
import com.oracle.truffle.nfi.NFILanguage;
import com.oracle.truffle.nfi.NFISignature;
import com.oracle.truffle.nfi.NFISymbol;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=BindSignatureNode.class)
final class BindSignatureNodeGen
extends BindSignatureNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.ContextReference<NFIContext> nFILanguageContextReference_;
    @CompilerDirectives.CompilationFinal
    private CachedSignatureData cachedSignature_cache;
    @Node.Child
    private CachedSignatureStringData cachedSignatureString_cache;

    private BindSignatureNodeGen() {
    }

    @Override
    @ExplodeLoop
    Object execute(NFISymbol arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0) {
                CachedSignatureData s1_ = this.cachedSignature_cache;
                while (s1_ != null) {
                    if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.removeCachedSignature_(s1_);
                        return this.executeAndSpecialize(arg0Value, arg1Value);
                    }
                    if (arg0Value.backend == s1_.cachedBackend_ && arg1Value == s1_.cachedSignature_) {
                        TruffleLanguage.ContextReference<NFIContext> nFILanguageContextReference__;
                        TruffleLanguage.ContextReference<NFIContext> ctxRef__ = nFILanguageContextReference__ = this.nFILanguageContextReference_;
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedBackend_, s1_.cachedSignature_, ctxRef__, s1_.parsedSignature_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                while (s2_ != null) {
                    if (s2_.interop_.accepts(arg1Value) && s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value))) {
                        TruffleLanguage.ContextReference<NFIContext> nFILanguageContextReference__1 = this.nFILanguageContextReference_;
                        NFIContext ctx__ = (NFIContext)nFILanguageContextReference__1.get();
                        return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.signatureSource_, ctx__, s2_.call_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state_0 & 4) != 0) {
                TruffleLanguage.ContextReference<NFIContext> nFILanguageContextReference__2;
                TruffleLanguage.ContextReference<NFIContext> generic_ctxRef__ = nFILanguageContextReference__2 = this.nFILanguageContextReference_;
                return BindSignatureNode.doGeneric(arg0Value, arg1Value, generic_ctxRef__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(NFISymbol arg0Value, Object arg1Value) throws UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            TruffleLanguage.ContextReference ctxRef__ = null;
            if ((exclude & 1) == 0) {
                Object assumption0;
                int count1_ = 0;
                CachedSignatureData s1_ = this.cachedSignature_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null) {
                        if (arg0Value.backend == s1_.cachedBackend_ && arg1Value == s1_.cachedSignature_ && (s1_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                            TruffleLanguage.ContextReference nFILanguageContextReference__3 = this.nFILanguageContextReference_;
                            if (nFILanguageContextReference__3 == null) {
                                this.nFILanguageContextReference_ = nFILanguageContextReference__3 = super.lookupContextReference(NFILanguage.class);
                            }
                            ctxRef__ = nFILanguageContextReference__3;
                            break;
                        }
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && Assumption.isValidAssumption((Assumption)(assumption0 = NFILanguage.getSingleContextAssumption())) && count1_ < 5) {
                    s1_ = new CachedSignatureData(this.cachedSignature_cache);
                    s1_.cachedBackend_ = arg0Value.backend;
                    s1_.cachedSignature_ = arg1Value;
                    TruffleLanguage.ContextReference nFILanguageContextReference__4 = this.nFILanguageContextReference_;
                    if (nFILanguageContextReference__4 == null) {
                        this.nFILanguageContextReference_ = nFILanguageContextReference__4 = super.lookupContextReference(NFILanguage.class);
                    }
                    ctxRef__ = nFILanguageContextReference__4;
                    s1_.parsedSignature_ = BindSignatureNode.parseSignature(s1_.cachedBackend_, s1_.cachedSignature_, (TruffleLanguage.ContextReference<NFIContext>)ctxRef__);
                    s1_.assumption0_ = assumption0;
                    this.cachedSignature_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    assumption0 = BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedBackend_, s1_.cachedSignature_, ctxRef__, s1_.parsedSignature_);
                    return assumption0;
                }
            }
            NFIContext ctx__ = null;
            if ((exclude & 2) == 0) {
                InteropLibrary interop__;
                String cachedSignature__;
                int count2_ = 0;
                CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
                if ((state_0 & 2) != 0) {
                    while (s2_ != null) {
                        if (s2_.interop_.accepts(arg1Value) && s2_.cachedSignature_.equals(BindSignatureNode.asString(s2_.interop_, arg1Value))) {
                            TruffleLanguage.ContextReference nFILanguageContextReference__5 = this.nFILanguageContextReference_;
                            if (nFILanguageContextReference__5 == null) {
                                this.nFILanguageContextReference_ = nFILanguageContextReference__5 = super.lookupContextReference(NFILanguage.class);
                            }
                            ctx__ = (NFIContext)nFILanguageContextReference__5.get();
                            break;
                        }
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (cachedSignature__ = BindSignatureNode.asString(interop__ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value))), arg1Value)).equals(BindSignatureNode.asString(interop__, arg1Value)) && count2_ < 5) {
                    s2_ = (CachedSignatureStringData)super.insert((Node)new CachedSignatureStringData(this.cachedSignatureString_cache));
                    s2_.interop_ = s2_.insertAccessor(interop__);
                    s2_.cachedSignature_ = cachedSignature__;
                    s2_.signatureSource_ = BindSignatureNode.createSignatureSource(arg0Value.backend, cachedSignature__);
                    TruffleLanguage.ContextReference nFILanguageContextReference__6 = this.nFILanguageContextReference_;
                    if (nFILanguageContextReference__6 == null) {
                        this.nFILanguageContextReference_ = nFILanguageContextReference__6 = super.lookupContextReference(NFILanguage.class);
                    }
                    ctx__ = (NFIContext)nFILanguageContextReference__6.get();
                    s2_.call_ = s2_.insertAccessor(IndirectCallNode.create());
                    this.cachedSignatureString_cache = s2_;
                    this.exclude_ = exclude |= 1;
                    this.cachedSignature_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s2_.interop_, s2_.cachedSignature_, s2_.signatureSource_, ctx__, s2_.call_);
                    return object;
                }
            }
            TruffleLanguage.ContextReference generic_ctxRef__ = null;
            TruffleLanguage.ContextReference nFILanguageContextReference__7 = this.nFILanguageContextReference_;
            if (nFILanguageContextReference__7 == null) {
                this.nFILanguageContextReference_ = nFILanguageContextReference__7 = super.lookupContextReference(NFILanguage.class);
            }
            generic_ctxRef__ = nFILanguageContextReference__7;
            this.exclude_ = exclude |= 3;
            this.cachedSignature_cache = null;
            this.cachedSignatureString_cache = null;
            state_0 &= 0xFFFFFFFC;
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            Object object = BindSignatureNode.doGeneric(arg0Value, arg1Value, (TruffleLanguage.ContextReference<NFIContext>)generic_ctxRef__);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            CachedSignatureData s1_ = this.cachedSignature_cache;
            CachedSignatureStringData s2_ = this.cachedSignatureString_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCachedSignature_(Object s1_) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            CachedSignatureData prev = null;
            CachedSignatureData cur = this.cachedSignature_cache;
            while (cur != null) {
                if (cur == s1_) {
                    if (prev == null) {
                        this.cachedSignature_cache = cur.next_;
                        break;
                    }
                    prev.next_ = cur.next_;
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cachedSignature_cache == null) {
                this.state_0_ &= 0xFFFFFFFE;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static BindSignatureNode create() {
        return new BindSignatureNodeGen();
    }

    public static BindSignatureNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class Uncached
    extends BindSignatureNode {
        private final TruffleLanguage.ContextReference<NFIContext> nFILanguageContextReference_ = this.lookupContextReference(NFILanguage.class);

        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object execute(NFISymbol arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value, this.nFILanguageContextReference_);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureStringData
    extends Node {
        @Node.Child
        CachedSignatureStringData next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        String cachedSignature_;
        @CompilerDirectives.CompilationFinal
        Source signatureSource_;
        @Node.Child
        IndirectCallNode call_;

        CachedSignatureStringData(CachedSignatureStringData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureData {
        @CompilerDirectives.CompilationFinal
        CachedSignatureData next_;
        @CompilerDirectives.CompilationFinal
        String cachedBackend_;
        @CompilerDirectives.CompilationFinal
        Object cachedSignature_;
        @CompilerDirectives.CompilationFinal
        NFISignature parsedSignature_;
        @CompilerDirectives.CompilationFinal
        Assumption assumption0_;

        CachedSignatureData(CachedSignatureData next_) {
            this.next_ = next_;
        }
    }
}

