/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.UByteIndexer;

public class UByteArrayIndexer
extends UByteIndexer {
    protected byte[] array;

    public UByteArrayIndexer(byte[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public UByteArrayIndexer(byte[] array, long ... sizes) {
        this(array, sizes, UByteArrayIndexer.strides(sizes));
    }

    public UByteArrayIndexer(byte[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public int get(long i) {
        return this.array[(int)i] & 0xFF;
    }

    @Override
    public UByteIndexer get(long i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)i * (int)this.strides[0] + n] & 0xFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j] & 0xFF;
    }

    @Override
    public UByteIndexer get(long i, long j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] & 0xFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] & 0xFF;
    }

    @Override
    public int get(long ... indices) {
        return this.array[(int)this.index(indices)] & 0xFF;
    }

    @Override
    public UByteIndexer get(long[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)this.index(indices) + n] & 0xFF;
        }
        return this;
    }

    @Override
    public UByteIndexer put(long i, int b) {
        this.array[(int)i] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(long i, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = (byte)b[offset + n];
        }
        return this;
    }

    @Override
    public UByteIndexer put(long i, long j, int b) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(long i, long j, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = (byte)b[offset + n];
        }
        return this;
    }

    @Override
    public UByteIndexer put(long i, long j, long k, int b) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(long[] indices, int b) {
        this.array[(int)this.index((long[])indices)] = (byte)b;
        return this;
    }

    @Override
    public UByteIndexer put(long[] indices, int[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = (byte)b[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

