/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.oql;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.oql.Bundle;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.graalvm.visualvm.lib.profiler.heapwalk.OQLSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class CustomOQLQueries {
    private static final String SAVED_OQL_QUERIES_FILENAME = "oqlqueries";
    private static final String PROP_QUERY_NAME_KEY = "query-name";
    private static final String PROP_QUERY_DESCR_KEY = "query-descr";
    private static final String PROP_QUERY_SCRIPT_KEY = "query-script";
    private static CustomOQLQueries INSTANCE;
    private List<OQLSupport.Query> customQueries;

    public static synchronized CustomOQLQueries instance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomOQLQueries();
        }
        return INSTANCE;
    }

    public synchronized boolean isEmpty() {
        return this.customQueries.isEmpty();
    }

    public synchronized void add(OQLSupport.Query query) {
        this.customQueries.add(0, query);
        this.save();
    }

    public synchronized void save(OQLSupport.Query query) {
        for (OQLSupport.Query q : this.customQueries) {
            if (!q.getName().equals(query.getName())) continue;
            q.setScript(query.getScript());
            this.save();
            break;
        }
    }

    public synchronized void set(List<OQLSupport.Query> queries) {
        this.customQueries.clear();
        this.customQueries.addAll(queries);
        this.save();
    }

    public synchronized List<OQLSupport.Query> list() {
        ArrayList<OQLSupport.Query> list = new ArrayList<OQLSupport.Query>();
        for (OQLSupport.Query query : this.customQueries) {
            list.add(new OQLSupport.Query(query.getScript(), query.getName(), query.getDescription()));
        }
        return list;
    }

    private void save() {
        new RequestProcessor("OQL Scripts Saver").post(new Runnable(){

            @Override
            public void run() {
                try {
                    Properties p = CustomOQLQueries.listToProperties(CustomOQLQueries.this.list());
                    ProfilerStorage.saveGlobalProperties((Properties)p, (String)CustomOQLQueries.SAVED_OQL_QUERIES_FILENAME);
                }
                catch (Exception e) {
                    ProfilerDialogs.displayError((String)Bundle.CustomOQLQueries_SaveFailed());
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        });
    }

    private static List<OQLSupport.Query> propertiesToList(List<OQLSupport.Query> queries, Properties properties) {
        int i = 0;
        while (properties.containsKey("query-name-" + i)) {
            String name = properties.getProperty("query-name-" + i);
            String description = properties.getProperty("query-descr-" + i, null);
            String script = properties.getProperty("query-script-" + i, "");
            if (name != null && script != null) {
                queries.add(new OQLSupport.Query(script, name, description));
            }
            ++i;
        }
        return queries;
    }

    private static Properties listToProperties(List<OQLSupport.Query> queries) {
        Properties properties = new Properties();
        int i = 0;
        for (OQLSupport.Query query : queries) {
            properties.put("query-name-" + i, query.getName().trim());
            properties.put("query-script-" + i, query.getScript().trim());
            String descr = query.getDescription();
            if (descr != null) {
                properties.put("query-descr-" + i, descr);
            }
            ++i;
        }
        return properties;
    }

    private CustomOQLQueries() {
        assert (!SwingUtilities.isEventDispatchThread());
        this.customQueries = new ArrayList<OQLSupport.Query>();
        try {
            Properties p = new Properties();
            ProfilerStorage.loadGlobalProperties((Properties)p, (String)SAVED_OQL_QUERIES_FILENAME);
            CustomOQLQueries.propertiesToList(this.customQueries, p);
        }
        catch (Exception e) {
            ProfilerDialogs.displayError((String)Bundle.CustomOQLQueries_LoadFailed());
            Exceptions.printStackTrace((Throwable)e);
        }
    }
}

