/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.ThreadNode;
import org.graalvm.visualvm.heapviewer.java.ThreadNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.JavaThreadsProvider;
import org.graalvm.visualvm.heapviewer.java.impl.JavaThreadsView;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.swing.LinkButton;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ThreadObjectGCRoot;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.uisupport.SeparatorLine;

class JavaThreadsSummary
extends HeapView {
    private final HeapContext context;
    private final HeapViewerActions actions;
    private final Collection<HeapViewerNodeAction.Provider> actionProviders;
    private JComponent component;
    private final Object[][] threadData;
    private boolean keepSelection;

    private JavaThreadsSummary(Instance oomeInstance, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
        super(Bundle.JavaThreadsSummary_Name(), Bundle.JavaThreadsSummary_Description());
        this.context = context;
        this.actions = actions;
        this.actionProviders = actionProviders;
        String threadName = JavaThreadsProvider.getThreadName(context.getFragment().getHeap(), oomeInstance);
        this.threadData = new Object[][]{{new ThreadNode(threadName, true, oomeInstance)}};
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return null;
    }

    private void init() {
        this.component = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = 0;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 0;
                return dim;
            }
        };
        this.component.setOpaque(false);
        this.component.setBorder(BorderFactory.createEmptyBorder(12, 5, 0, 5));
        JLabel caption = new JLabel(Bundle.JavaThreadsSummary_Name());
        caption.setFont(caption.getFont().deriveFont(1));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.component.add((Component)caption, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 0, 0);
        this.component.add((Component)new JLabel("["), c);
        LinkButton link = new LinkButton(Bundle.JavaThreadsSummary_ViewAll()){

            @Override
            protected void clicked() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaThreadsView threadsView = JavaThreadsSummary.this.actions.findFeature(JavaThreadsView.class);
                        if (threadsView != null) {
                            threadsView.configureAllThreads();
                            JavaThreadsSummary.this.actions.selectFeature(threadsView);
                        }
                    }
                });
            }
        };
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.component.add((Component)link, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.component.add((Component)new JLabel("]"), c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(1, 4, 0, 0);
        this.component.add((Component)new SeparatorLine(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.fill = 0;
        c.insets = new Insets(8, 1, 3, 0);
        this.component.add((Component)new JLabel(Bundle.JavaThreadsSummary_Hint(), 10), c);
        DefaultTableModel model = new DefaultTableModel(this.threadData, new Object[]{Bundle.JavaThreadsSummary_NameColumn()}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        ProfilerTable thread = this.createTable(model);
        ThreadNodeRenderer renderer = new ThreadNodeRenderer(this.context.getFragment().getHeap());
        thread.setColumnRenderer(0, (ProfilerRenderer)renderer);
        Dimension dim = thread.getPreferredSize();
        renderer.setValue(this.threadData[0][0], 0);
        dim.width = renderer.getComponent().getPreferredSize().width + 4;
        thread.setPreferredSize(dim);
        thread.setMinimumSize(dim);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 18;
        c.gridwidth = 0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.component.add((Component)thread, c);
    }

    private ProfilerTable createTable(TableModel model) {
        final SummaryView.SimpleTable t = new SummaryView.SimpleTable(model, 0){

            public void setBounds(int x, int y, int w, int h) {
                Container parent = this.getParent();
                if (parent != null) {
                    w = Math.min(w, parent.getWidth());
                }
                super.setBounds(x, y, w, h);
            }

            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                this.requestFocusInWindow();
                HeapViewerNode node = (HeapViewerNode)((Object)value);
                HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(node, JavaThreadsSummary.this.actionProviders, JavaThreadsSummary.this.context, JavaThreadsSummary.this.actions, new HeapViewerNodeAction[0]);
                nodeActions.populatePopup(popup);
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(this.createCopyMenuItem());
            }

            public void performDefaultAction(ActionEvent e) {
                int row = this.getSelectedRow();
                if (row == -1) {
                    return;
                }
                Object value = this.getValueForRow(row);
                if (!(value instanceof HeapViewerNode)) {
                    return;
                }
                HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode((HeapViewerNode)((Object)value), JavaThreadsSummary.this.actionProviders, JavaThreadsSummary.this.context, JavaThreadsSummary.this.actions, new HeapViewerNodeAction[0]);
                nodeActions.performDefaultAction(e);
            }

            protected void popupShowing() {
                JavaThreadsSummary.this.keepSelection = true;
            }

            protected void popupHidden() {
                JavaThreadsSummary.this.keepSelection = false;
                new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!this.isFocusOwner()) {
                            this.clearSelection();
                        }
                    }
                }){
                    {
                        this.setRepeats(false);
                    }
                }.start();
            }
        };
        t.setRowSelectionAllowed(true);
        t.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!JavaThreadsSummary.this.keepSelection) {
                    t.clearSelection();
                } else {
                    JavaThreadsSummary.this.keepSelection = false;
                }
            }
        });
        t.providePopupMenu(true);
        t.setSelectionOnMiddlePress(true);
        t.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    int row = t.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    Object value = t.getValueForRow(row);
                    if (!(value instanceof HeapViewerNode)) {
                        return;
                    }
                    HeapViewerNode node = (HeapViewerNode)((Object)value);
                    HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(node, JavaThreadsSummary.this.actionProviders, JavaThreadsSummary.this.context, JavaThreadsSummary.this.actions, new HeapViewerNodeAction[0]);
                    ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "middle button", e.getWhen(), e.getModifiers());
                    nodeActions.performMiddleButtonAction(ae);
                }
            }
        });
        return t;
    }

    public static class Provider
    extends SummaryView.ContentProvider {
        @Override
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            Instance oomeInstance;
            if (!JavaHeapFragment.isJavaHeap(context)) {
                return null;
            }
            ThreadObjectGCRoot oomeThread = JavaThreadsProvider.getOOMEThread(context.getFragment().getHeap());
            Instance instance = oomeInstance = oomeThread == null ? null : oomeThread.getInstance();
            if (oomeInstance == null) {
                return null;
            }
            return new JavaThreadsSummary(oomeInstance, context, actions, actionProviders);
        }
    }
}

