/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.ui.UIUtils;

class JavaPreviewPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private InstanceScrollPane component;

    public JavaPreviewPlugin(HeapContext context) {
        super(Bundle.JavaPreviewPlugin_Name(), Bundle.JavaPreviewPlugin_Description(), Icons.getIcon((String)"HeapWalkerIcons.Properties"));
        this.heap = context.getFragment().getHeap();
    }

    @Override
    protected void closed() {
    }

    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        this.component.showInstance(node == null ? null : HeapViewerNode.getValue(node, DataType.INSTANCE, this.heap));
    }

    @Override
    protected JComponent createComponent() {
        if (this.component == null) {
            this.component = new InstanceScrollPane();
        }
        return this.component;
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!viewID.startsWith("diff") && JavaHeapFragment.isJavaHeap(context)) {
                return new JavaPreviewPlugin(context);
            }
            return null;
        }
    }

    private class InstanceScrollPane
    extends JScrollPane {
        private Instance selectedInstance = null;
        private boolean instancePending = false;

        InstanceScrollPane() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setViewportBorder(BorderFactory.createEmptyBorder());
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && InstanceScrollPane.this.instancePending && InstanceScrollPane.this.isShowing()) {
                        InstanceScrollPane.this.showInstanceImpl();
                    }
                }
            });
            this.showInstanceImpl();
        }

        void showInstance(Instance instance) {
            if (this.selectedInstance == instance) {
                return;
            }
            this.selectedInstance = instance;
            if (this.isShowing()) {
                this.showInstanceImpl();
            } else {
                this.instancePending = true;
            }
        }

        private void showInstanceImpl() {
            Object instanceView;
            Object object = instanceView = this.selectedInstance == null ? null : DetailsSupport.getDetailsView((Instance)this.selectedInstance, (Heap)JavaPreviewPlugin.this.heap);
            if (instanceView == null) {
                JLabel noDetails = new JLabel(Bundle.JavaPreviewPlugin_NoDetails(), 0);
                noDetails.setEnabled(false);
                instanceView = new JPanel(new BorderLayout());
                ((JComponent)instanceView).setOpaque(true);
                ((JComponent)instanceView).setBackground(UIUtils.getProfilerResultsBackground());
                ((Container)instanceView).add((Component)noDetails, "Center");
            }
            this.setViewportView((Component)instanceView);
            this.instancePending = false;
        }
    }
}

