/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Value;

public abstract class InstanceReferenceNode
extends InstanceNode.IncludingNull {
    private final InstanceNode.Mode mode;
    private final Value value;
    private String fieldName;

    public InstanceReferenceNode(Value value, Instance instance, boolean incoming) {
        super(instance);
        this.value = value;
        this.mode = incoming ? InstanceNode.Mode.INCOMING_REFERENCE : InstanceNode.Mode.OUTGOING_REFERENCE;
    }

    public static InstanceReferenceNode outgoing(Value value) {
        return InstanceReferenceNode.reference(value, false);
    }

    public static InstanceReferenceNode incoming(Value value) {
        return InstanceReferenceNode.reference(value, true);
    }

    public static InstanceReferenceNode reference(Value value, boolean incoming) {
        if (value instanceof ObjectFieldValue) {
            return new Field((ObjectFieldValue)value, incoming);
        }
        if (value instanceof ArrayItemValue) {
            return new ArrayItem((ArrayItemValue)value, incoming);
        }
        return null;
    }

    @Override
    public InstanceNode.Mode getMode() {
        return this.mode;
    }

    public Value getValue() {
        return this.value;
    }

    public String getFieldName() {
        if (this.fieldName == null) {
            this.fieldName = this.computeFieldName();
        }
        return this.fieldName;
    }

    protected abstract String computeFieldName();

    @Override
    public String toString() {
        if (InstanceNode.Mode.INCOMING_REFERENCE.equals((Object)this.mode)) {
            return this.getFieldName() + " in " + this.getName(null);
        }
        return this.getFieldName() + " = " + this.getName(null);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceReferenceNode)) {
            return false;
        }
        InstanceReferenceNode r = (InstanceReferenceNode)((Object)o);
        return this.mode == r.mode && this.value.equals(r.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    public static class ArrayItem
    extends InstanceReferenceNode {
        public ArrayItem(ArrayItemValue value, boolean incoming) {
            super((Value)value, incoming ? value.getDefiningInstance() : value.getInstance(), incoming);
        }

        public ArrayItemValue getValue() {
            return (ArrayItemValue)super.getValue();
        }

        @Override
        protected String computeFieldName() {
            return "[" + this.getValue().getIndex() + "]";
        }
    }

    public static class Field
    extends InstanceReferenceNode {
        public Field(ObjectFieldValue value, boolean incoming) {
            super((Value)value, incoming ? value.getDefiningInstance() : value.getInstance(), incoming);
        }

        public ObjectFieldValue getValue() {
            return (ObjectFieldValue)super.getValue();
        }

        @Override
        protected String computeFieldName() {
            org.graalvm.visualvm.lib.jfluid.heap.Field field = this.getValue().getField();
            return (field.isStatic() ? "static " : "") + field.getName();
        }
    }
}

