/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer;

import java.io.File;
import java.io.IOException;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapProgress;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Lookup;

public abstract class HeapFragment {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final Heap heap;

    public HeapFragment(String id, String name, String description, Heap heap) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.heap = heap;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public static void setProgress(final ProgressHandle pHandle, final int offset) {
        final BoundedRangeModel progress = HeapProgress.getProgress();
        progress.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pHandle.progress(progress.getValue() + offset);
            }
        });
    }

    public static abstract class Provider {
        public abstract HeapFragment getFragment(File var1, Lookup.Provider var2, Heap var3) throws IOException;
    }
}

