/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.ImageBuilder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.ui.Utils;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

final class BaseBuilders {
    BaseBuilders() {
    }

    static final class IconBuilder
    extends Utils.InstanceBuilder<Icon> {
        private final int width;
        private final int height;
        private final Image image;

        IconBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.width = DetailsUtils.getIntFieldValue(instance, "width", 0);
            this.height = DetailsUtils.getIntFieldValue(instance, "height", 0);
            this.image = ImageBuilder.buildImage(instance, heap);
        }

        static IconBuilder fromField(Instance instance, String field, Heap heap) {
            Object icon = instance.getValueOfField(field);
            if (!(icon instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)icon, ImageIcon.class.getName())) {
                return null;
            }
            return new IconBuilder((Instance)icon, heap);
        }

        @Override
        protected Icon createInstanceImpl() {
            if (this.image == null) {
                return new Utils.PlaceholderIcon(this.width, this.height);
            }
            return new ImageIcon(this.image);
        }
    }

    static final class ColorBuilder
    extends Utils.InstanceBuilder<Color> {
        private final int value;
        private final boolean isUIResource;

        ColorBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.value = DetailsUtils.getIntFieldValue(instance, "value", 0);
            this.isUIResource = DetailsUtils.isSubclassOf(instance, "javax.swing.plaf.ColorUIResource") || DetailsUtils.isSubclassOf(instance, "javax.swing.plaf.nimbus.DerivedColor$UIResource");
        }

        boolean isUIResource() {
            return this.isUIResource;
        }

        static ColorBuilder fromField(Instance instance, String field, Heap heap) {
            Object color = instance.getValueOfField(field);
            if (!(color instanceof Instance)) {
                return null;
            }
            return new ColorBuilder((Instance)color, heap);
        }

        @Override
        protected Color createInstanceImpl() {
            return new Color(this.value);
        }
    }

    static final class FontBuilder
    extends Utils.InstanceBuilder<Font> {
        private final String name;
        private final int style;
        private final int size;
        private final boolean isUIResource;

        FontBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.name = Utils.getFontName(instance, heap);
            this.style = DetailsUtils.getIntFieldValue(instance, "style", 0);
            this.size = DetailsUtils.getIntFieldValue(instance, "size", 10);
            this.isUIResource = DetailsUtils.isSubclassOf(instance, "javax.swing.plaf.FontUIResource");
        }

        boolean isUIResource() {
            return this.isUIResource;
        }

        static FontBuilder fromField(Instance instance, String field, Heap heap) {
            Object font = instance.getValueOfField(field);
            if (!(font instanceof Instance)) {
                return null;
            }
            return new FontBuilder((Instance)font, heap);
        }

        @Override
        protected Font createInstanceImpl() {
            return new Font(this.name, this.style, this.size);
        }
    }

    static final class InsetsBuilder
    extends Utils.InstanceBuilder<Insets> {
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;

        InsetsBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.top = DetailsUtils.getIntFieldValue(instance, "top", 0);
            this.left = DetailsUtils.getIntFieldValue(instance, "left", 0);
            this.bottom = DetailsUtils.getIntFieldValue(instance, "bottom", 0);
            this.right = DetailsUtils.getIntFieldValue(instance, "right", 0);
        }

        static InsetsBuilder fromField(Instance instance, String field, Heap heap) {
            Object insets = instance.getValueOfField(field);
            if (!(insets instanceof Instance)) {
                return null;
            }
            return new InsetsBuilder((Instance)insets, heap);
        }

        @Override
        protected Insets createInstanceImpl() {
            return new Insets(this.top, this.left, this.bottom, this.right);
        }
    }

    static final class RectangleBuilder
    extends Utils.InstanceBuilder<Rectangle> {
        private final PointBuilder point;
        private final DimensionBuilder dimension;

        RectangleBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.point = new PointBuilder(instance, heap);
            this.dimension = new DimensionBuilder(instance, heap);
        }

        static RectangleBuilder fromField(Instance instance, String field, Heap heap) {
            Object rectangle = instance.getValueOfField(field);
            if (!(rectangle instanceof Instance)) {
                return null;
            }
            return new RectangleBuilder((Instance)rectangle, heap);
        }

        @Override
        protected Rectangle createInstanceImpl() {
            return new Rectangle((Point)this.point.createInstance(), (Dimension)this.dimension.createInstance());
        }
    }

    static final class DimensionBuilder
    extends Utils.InstanceBuilder<Dimension> {
        private final int width;
        private final int height;

        DimensionBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.width = DetailsUtils.getIntFieldValue(instance, "width", 0);
            this.height = DetailsUtils.getIntFieldValue(instance, "height", 0);
        }

        static DimensionBuilder fromField(Instance instance, String field, Heap heap) {
            Object dimension = instance.getValueOfField(field);
            if (!(dimension instanceof Instance)) {
                return null;
            }
            return new DimensionBuilder((Instance)dimension, heap);
        }

        @Override
        protected Dimension createInstanceImpl() {
            return new Dimension(this.width, this.height);
        }
    }

    static final class PointBuilder
    extends Utils.InstanceBuilder<Point> {
        private final int x;
        private final int y;

        PointBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.x = DetailsUtils.getIntFieldValue(instance, "x", 0);
            this.y = DetailsUtils.getIntFieldValue(instance, "y", 0);
        }

        static PointBuilder fromField(Instance instance, String field, Heap heap) {
            Object point = instance.getValueOfField(field);
            if (!(point instanceof Instance)) {
                return null;
            }
            return new PointBuilder((Instance)point, heap);
        }

        @Override
        protected Point createInstanceImpl() {
            return new Point(this.x, this.y);
        }
    }
}

