/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image;

import java.lang.reflect.Array;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.InstanceBuilder;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk.image.InstanceBuilderRegistry;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class FieldAccessor {
    private final Heap heap;
    private final InstanceBuilderRegistry registry;

    public FieldAccessor(Heap heap) {
        this(heap, new InstanceBuilderRegistry());
    }

    public FieldAccessor(Heap heap, InstanceBuilderRegistry registry) {
        this.heap = heap;
        this.registry = registry;
    }

    public Heap getHeap() {
        return this.heap;
    }

    public static String getClassMask(Class<?> type, boolean subtypes) {
        if (subtypes) {
            return type.getName() + "+";
        }
        return type.getName();
    }

    public static boolean matchClassMask(Instance instance, String mask) {
        if (mask.endsWith("+")) {
            return DetailsUtils.isSubclassOf(instance, mask.substring(0, mask.length() - 1));
        }
        return DetailsUtils.isInstanceOf(instance, mask);
    }

    public static boolean isInstanceOf(Instance instance, Class<?> type) {
        if (instance == null) {
            return false;
        }
        return instance.getJavaClass().getName().equals(type.getName());
    }

    public static <T> T notNull(T value) throws InvalidFieldException {
        return FieldAccessor.notNullCheck(value, false);
    }

    public static <T> T notNullCheck(T value, boolean allowNull) throws InvalidFieldException {
        if (!allowNull && value == null) {
            throw new InvalidFieldException("Unexpected null value");
        }
        return value;
    }

    public static <T> T castValue(Object value, Class<T> type) throws InvalidFieldException {
        if (value == null) {
            return null;
        }
        if (!type.isInstance(value)) {
            throw new InvalidFieldException("Value is %s but %s is expected", value.getClass().getName(), type.getName());
        }
        return type.cast(value);
    }

    public <T> T get(Instance instance, String field, Class<T> type, boolean allowNull) throws InvalidFieldException {
        Object value = instance.getValueOfField(field);
        if (value == null) {
            if (allowNull) {
                return null;
            }
            throw new InvalidFieldException(instance, field, "Empty or missing field");
        }
        try {
            return FieldAccessor.castValue(value, type);
        }
        catch (InvalidFieldException ex) {
            throw new InvalidFieldException(instance, field, ex.getMessage()).initCause(ex);
        }
    }

    public Instance getInstance(Instance instance, String field, boolean allowNull) throws InvalidFieldException {
        return this.get(instance, field, Instance.class, allowNull);
    }

    public Instance getInstance(Instance instance, String field, Class<?> type, boolean subclasses) throws InvalidFieldException {
        return this.getInstance(instance, field, FieldAccessor.getClassMask(type, subclasses));
    }

    public Instance getInstance(Instance instance, String field, String clsName) throws InvalidFieldException {
        Instance value = this.getInstance(instance, field, false);
        if (clsName.endsWith("+")) {
            if (!DetailsUtils.isSubclassOf(value, clsName = clsName.substring(0, clsName.length() - 1))) {
                throw new InvalidFieldException(instance, field, "Instance is %s but subclass of %s is expected", value.getJavaClass().getName(), clsName);
            }
        } else if (!DetailsUtils.isInstanceOf(value, clsName)) {
            throw new InvalidFieldException(instance, field, "Instance is %s but %s is expected", value.getJavaClass().getName(), clsName);
        }
        return value;
    }

    public <T> T build(Instance instance, String field, InstanceBuilder<T> builder, boolean allowNull) throws InvalidFieldException {
        return builder.convert(this, this.get(instance, field, Instance.class, allowNull));
    }

    public <T> T build(Instance instance, String field, Class<T> type, boolean allowNull) throws InvalidFieldException {
        Instance value = this.get(instance, field, Instance.class, allowNull);
        if (value == null) {
            return null;
        }
        InstanceBuilder<T> builder = this.registry.getBuilder(value, type);
        if (builder == null) {
            if (allowNull) {
                return null;
            }
            throw new InvalidFieldException(instance, field, "No builder for %s returning %s registered", value.getJavaClass().getName(), type.getName());
        }
        return builder.convert(this, value);
    }

    public <T> T[] buildArray(Instance instance, String field, Class<T> type, boolean allowNull, boolean allowNullValues) throws InvalidFieldException {
        return this.buildArray(instance, field, type, null, allowNull, allowNullValues);
    }

    public <T> T[] buildArray(Instance instance, String field, InstanceBuilder<T> builder, boolean allowNull, boolean allowNullValues) throws InvalidFieldException {
        return this.buildArray(instance, field, builder.getType(), builder, allowNull, allowNullValues);
    }

    private <T> T[] buildArray(Instance instance, String field, Class<T> type, InstanceBuilder<? extends T> builder, boolean allowNull, boolean allowNullValues) throws InvalidFieldException {
        ObjectArrayInstance array = this.get(instance, field, ObjectArrayInstance.class, allowNull);
        if (array == null) {
            return null;
        }
        List list = array.getValues();
        Object[] result = (Object[])Array.newInstance(builder.getType(), list.size());
        for (int i = 0; i < result.length; ++i) {
            try {
                InstanceBuilder<T> itemBuilder = builder == null ? this.registry.getBuilder(instance, type) : builder;
                result[i] = itemBuilder.convert(this, FieldAccessor.castValue(FieldAccessor.notNullCheck(list.get(i), allowNullValues), Instance.class));
                continue;
            }
            catch (InvalidFieldException ex) {
                throw new InvalidFieldException(instance, field, "Invalid value at index %d: %s", i, ex.getMessage()).initCause(ex);
            }
        }
        return result;
    }

    public String toString(Instance instance) {
        if (instance == null) {
            return null;
        }
        return DetailsSupport.getDetailsString(instance, this.heap);
    }

    public int getInt(Instance instance, String field) throws InvalidFieldException {
        return this.get(instance, field, Number.class, false).intValue();
    }

    public boolean getBoolean(Instance instance, String field) throws InvalidFieldException {
        return this.get(instance, field, Boolean.class, false);
    }

    public String getString(Instance instance, String field, boolean allowNull) throws InvalidFieldException {
        return this.build(instance, field, InstanceBuilder.STRING_BUILDER, allowNull);
    }

    public int[] getIntArray(Instance instance, String field, boolean allowNull) throws InvalidFieldException {
        return this.build(instance, field, InstanceBuilder.INT_ARRAY_BUILDER, allowNull);
    }

    public byte[] getByteArray(Instance instance, String field, boolean allowNull) throws InvalidFieldException {
        return this.build(instance, field, InstanceBuilder.BYTE_ARRAY_BUILDER, allowNull);
    }

    public int[][] getIntArray2(Instance instance, String field, boolean allowNull) throws InvalidFieldException {
        return this.buildArray(instance, field, InstanceBuilder.INT_ARRAY_BUILDER, allowNull, false);
    }

    public byte[][] getByteArray2(Instance instance, String field, boolean allowNull) throws InvalidFieldException {
        return this.buildArray(instance, field, InstanceBuilder.BYTE_ARRAY_BUILDER, allowNull, false);
    }

    public short[][] getShortArray2(Instance instance, String field, boolean allowNull) throws InvalidFieldException {
        return this.buildArray(instance, field, InstanceBuilder.SHORT_ARRAY_BUILDER, allowNull, false);
    }

    public static class InvalidFieldException
    extends Exception {
        public InvalidFieldException() {
        }

        public InvalidFieldException(String message, Object ... args) {
            super(String.format(message, args));
        }

        public InvalidFieldException(Instance instance, String field, String message) {
            this(instance, field, "%s", message);
        }

        public InvalidFieldException(Instance instance, String field, String message, Object ... args) {
            this("%s#%d->%s: %s", instance == null ? "null" : instance.getJavaClass().getName(), instance == null ? -1 : instance.getInstanceNumber(), field, String.format(message, args));
        }

        public InvalidFieldException(String message) {
            super(message);
        }

        @Override
        public synchronized InvalidFieldException initCause(Throwable cause) {
            super.initCause(cause);
            return this;
        }
    }
}

