/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.graalvm.compiler.hotspot.management.JMXToLibGraalCalls;
import org.graalvm.compiler.hotspot.management.libgraal.MBeanProxy;
import org.graalvm.compiler.hotspot.management.libgraal.annotation.JMXToLibGraal;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNILibGraalScope;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.util.OptionsEncoder;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class JMXToLibGraalEntryPoints {
    private static final Map<Class<?>, OpenType<?>> PRIMITIVE_TO_OPENTYPE = new HashMap();

    private JMXToLibGraalEntryPoints() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JMXToLibGraal(value=JMXToLibGraal.Id.PollRegistrations)
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_JMXToLibGraalCalls_pollRegistrations")
    static JNI.JLongArray pollRegistrations(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        JNILibGraalScope scope;
        try (JNILibGraalScope s = scope = new JNILibGraalScope((Enum)JMXToLibGraal.Id.PollRegistrations, env);){
            List<MBeanProxy<?>> registrations = MBeanProxy.drainRegistrations();
            JNI.JLongArray res = JNIUtil.NewLongArray((JNI.JNIEnv)env, (int)registrations.size());
            CLongPointer elems = JNIUtil.GetLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)res, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            try {
                ObjectHandles globalHandles = ObjectHandles.getGlobal();
                for (int i = 0; i < registrations.size(); ++i) {
                    long handle = globalHandles.create(registrations.get(i)).rawValue();
                    elems.write(i, handle);
                }
            }
            finally {
                JNIUtil.ReleaseLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)res, (CLongPointer)elems, (int)0);
            }
            scope.setObjectResult((JNI.JObject)res);
        }
        return (JNI.JLongArray)scope.getObjectResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JMXToLibGraal(value=JMXToLibGraal.Id.FinishRegistration)
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_JMXToLibGraalCalls_finishRegistration")
    static void finishRegistration(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, JNI.JLongArray handles) {
        try (JNILibGraalScope s = new JNILibGraalScope((Enum)JMXToLibGraal.Id.FinishRegistration, env);){
            long len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)handles);
            CLongPointer elems = JNIUtil.GetLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            try {
                ObjectHandles globalHandles = ObjectHandles.getGlobal();
                int i = 0;
                while ((long)i < len) {
                    MBeanProxy registration = (MBeanProxy)globalHandles.get((ObjectHandle)WordFactory.pointer((long)elems.read(i)));
                    registration.finishRegistration();
                    ++i;
                }
            }
            finally {
                JNIUtil.ReleaseLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)handles, (CLongPointer)elems, (int)2);
            }
        }
    }

    @JMXToLibGraal(value=JMXToLibGraal.Id.GetObjectName)
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_JMXToLibGraalCalls_getObjectName")
    static JNI.JString getObjectName(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        JNILibGraalScope scope;
        try (JNILibGraalScope s = scope = new JNILibGraalScope((Enum)JMXToLibGraal.Id.GetObjectName, env);){
            ObjectHandles globalHandles = ObjectHandles.getGlobal();
            MBeanProxy registration = (MBeanProxy)globalHandles.get((ObjectHandle)WordFactory.pointer((long)handle));
            String name = registration.getName();
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)name));
        }
        return (JNI.JString)scope.getObjectResult();
    }

    @JMXToLibGraal(value=JMXToLibGraal.Id.GetMBeanInfo)
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_JMXToLibGraalCalls_getMBeanInfo")
    static JNI.JByteArray getMBeanInfo(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle) {
        JNILibGraalScope scope;
        try (JNILibGraalScope s = scope = new JNILibGraalScope((Enum)JMXToLibGraal.Id.GetMBeanInfo, env);){
            ObjectHandles globalHandles = ObjectHandles.getGlobal();
            MBeanProxy registration = (MBeanProxy)globalHandles.get((ObjectHandle)WordFactory.pointer((long)handle));
            MBeanInfo info = registration.getBean().getMBeanInfo();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("bean.class", info.getClassName());
            map.put("bean.description", info.getDescription());
            for (MBeanAttributeInfo attr : info.getAttributes()) {
                JMXToLibGraalEntryPoints.putAttributeInfo(map, attr);
            }
            int opCounter = 0;
            for (MBeanOperationInfo op : info.getOperations()) {
                JMXToLibGraalEntryPoints.putOperationInfo(map, op, ++opCounter);
            }
            scope.setObjectResult((JNI.JObject)JMXToLibGraalEntryPoints.mapToRaw(env, map));
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    private static void putAttributeInfo(Map<String, Object> into, MBeanAttributeInfo attrInfo) {
        String name = attrInfo.getName();
        into.put("attr." + name + ".name", name);
        into.put("attr." + name + ".type", attrInfo.getType());
        into.put("attr." + name + ".description", attrInfo.getDescription());
        into.put("attr." + name + ".r", attrInfo.isReadable());
        into.put("attr." + name + ".w", attrInfo.isWritable());
        into.put("attr." + name + ".i", attrInfo.isIs());
    }

    private static void putOperationInfo(Map<String, Object> into, MBeanOperationInfo opInfo, int opCounter) {
        String name = opInfo.getName();
        into.put("op." + opCounter + ".id", opCounter);
        into.put("op." + opCounter + ".name", name);
        into.put("op." + opCounter + ".type", opInfo.getReturnType());
        into.put("op." + opCounter + ".description", opInfo.getDescription());
        into.put("op." + opCounter + ".i", opInfo.getImpact());
        for (MBeanParameterInfo param : opInfo.getSignature()) {
            String paramName = param.getName();
            into.put("op." + opCounter + ".arg." + paramName + ".name", paramName);
            into.put("op." + opCounter + ".arg." + paramName + ".description", param.getDescription());
            into.put("op." + opCounter + ".arg." + paramName + ".type", param.getType());
        }
    }

    @JMXToLibGraal(value=JMXToLibGraal.Id.GetAttributes)
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_JMXToLibGraalCalls_getAttributes")
    static JNI.JByteArray getAttributes(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JObjectArray requiredAttributes) {
        JNILibGraalScope scope;
        try (JNILibGraalScope s = scope = new JNILibGraalScope((Enum)JMXToLibGraal.Id.GetAttributes, env);){
            int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)requiredAttributes);
            String[] attrNames = new String[len];
            for (int i = 0; i < len; ++i) {
                JNI.JString el = (JNI.JString)JNIUtil.GetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)requiredAttributes, (int)i);
                attrNames[i] = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)el);
            }
            MBeanProxy registration = (MBeanProxy)ObjectHandles.getGlobal().get((ObjectHandle)WordFactory.pointer((long)handle));
            AttributeList attributesList = registration.getBean().getAttributes(attrNames);
            scope.setObjectResult((JNI.JObject)JMXToLibGraalEntryPoints.attributeListToRaw(env, attributesList));
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    @JMXToLibGraal(value=JMXToLibGraal.Id.SetAttributes)
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_JMXToLibGraalCalls_setAttributes")
    static JNI.JByteArray setAttributes(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JByteArray attributes) {
        JNILibGraalScope scope;
        try (JNILibGraalScope s = scope = new JNILibGraalScope((Enum)JMXToLibGraal.Id.SetAttributes, env);){
            Map<String, Object> map = JMXToLibGraalEntryPoints.rawToMap(env, attributes);
            AttributeList attributesList = new AttributeList();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                attributesList.add(new Attribute(entry.getKey(), entry.getValue()));
            }
            MBeanProxy registration = (MBeanProxy)ObjectHandles.getGlobal().get((ObjectHandle)WordFactory.pointer((long)handle));
            attributesList = registration.getBean().setAttributes(attributesList);
            scope.setObjectResult((JNI.JObject)JMXToLibGraalEntryPoints.attributeListToRaw(env, attributesList));
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    @JMXToLibGraal(value=JMXToLibGraal.Id.Invoke)
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_JMXToLibGraalCalls_invoke")
    static JNI.JByteArray invoke(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long handle, JNI.JString hsActionName, JNI.JByteArray hsParams, JNI.JObjectArray hsSignature) {
        JNILibGraalScope scope;
        try (JNILibGraalScope s = scope = new JNILibGraalScope((Enum)JMXToLibGraal.Id.Invoke, env);){
            String actionName = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)hsActionName);
            int len = hsSignature.isNull() ? 0 : JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)hsSignature);
            String[] signature = new String[len];
            for (int i = 0; i < len; ++i) {
                signature[i] = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)((JNI.JString)JNIUtil.GetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)hsSignature, (int)i)));
            }
            Map<String, Object> map = JMXToLibGraalEntryPoints.rawToMap(env, hsParams);
            Object[] params = map.values().toArray(new Object[map.size()]);
            MBeanProxy registration = (MBeanProxy)ObjectHandles.getGlobal().get((ObjectHandle)WordFactory.pointer((long)handle));
            try {
                Object result = registration.getBean().invoke(actionName, params, signature);
                AttributeList attributesList = new AttributeList();
                if (result != null) {
                    attributesList.add(new Attribute("result", result));
                }
                scope.setObjectResult((JNI.JObject)JMXToLibGraalEntryPoints.attributeListToRaw(env, attributesList));
            }
            catch (MBeanException | ReflectionException e) {
                scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> rawToMap(JNI.JNIEnv env, JNI.JByteArray raw) {
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)raw);
        byte[] serialized = new byte[len];
        CCharPointer elems = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)raw, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            CTypeConversion.asByteBuffer((PointerBase)elems, (int)len).get(serialized);
        }
        finally {
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)raw, (CCharPointer)elems, (int)0);
        }
        return OptionsEncoder.decode((byte[])serialized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JNI.JByteArray mapToRaw(JNI.JNIEnv env, Map<String, Object> map) {
        byte[] serialized = OptionsEncoder.encode(map);
        JNI.JByteArray res = JNIUtil.NewByteArray((JNI.JNIEnv)env, (int)serialized.length);
        CCharPointer elems = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)res, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            CTypeConversion.asByteBuffer((PointerBase)elems, (int)serialized.length).put(serialized);
        }
        finally {
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)res, (CCharPointer)elems, (int)0);
        }
        return res;
    }

    private static JNI.JByteArray attributeListToRaw(JNI.JNIEnv env, AttributeList attributesList) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Object item : attributesList) {
            Attribute attr = (Attribute)item;
            JMXToLibGraalEntryPoints.putAttribute(values, attr.getName(), attr.getValue());
        }
        return JMXToLibGraalEntryPoints.mapToRaw(env, values);
    }

    private static void putAttribute(Map<String, Object> into, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof CompositeData) {
            JMXToLibGraalEntryPoints.putCompositeData(into, name, (CompositeData)value);
        } else if (value.getClass().isArray()) {
            JMXToLibGraalEntryPoints.putArray(into, name, (Object[])value);
        } else {
            into.put(name, value);
        }
    }

    private static void putCompositeData(Map<String, Object> into, String scope, CompositeData data) {
        String prefix = scope + ".composite";
        CompositeType type = data.getCompositeType();
        into.put(prefix, type.getTypeName());
        for (String key : type.keySet()) {
            Object value = data.get(key);
            String name = prefix + '.' + key;
            JMXToLibGraalEntryPoints.putAttribute(into, name, value);
        }
    }

    private static void putArray(Map<String, Object> into, String scope, Object[] data) {
        String prefix = scope + ".array";
        OpenType<?> type = JMXToLibGraalEntryPoints.findOpenType(data);
        into.put(prefix, type.getTypeName());
        for (int i = 0; i < data.length; ++i) {
            Object value = Array.get(data, i);
            String name = prefix + '.' + i;
            JMXToLibGraalEntryPoints.putAttribute(into, name, value);
        }
    }

    private static OpenType<?> findOpenType(Object[] data) {
        Class<?> componentType = data.getClass().getComponentType();
        OpenType<?> res = PRIMITIVE_TO_OPENTYPE.get(componentType);
        if (res == null) {
            throw new IllegalArgumentException("Unsupported type: " + componentType);
        }
        return res;
    }

    static {
        PRIMITIVE_TO_OPENTYPE.put(Void.class, SimpleType.VOID);
        PRIMITIVE_TO_OPENTYPE.put(Boolean.class, SimpleType.BOOLEAN);
        PRIMITIVE_TO_OPENTYPE.put(Byte.class, SimpleType.BYTE);
        PRIMITIVE_TO_OPENTYPE.put(Character.class, SimpleType.CHARACTER);
        PRIMITIVE_TO_OPENTYPE.put(Short.class, SimpleType.SHORT);
        PRIMITIVE_TO_OPENTYPE.put(Integer.class, SimpleType.INTEGER);
        PRIMITIVE_TO_OPENTYPE.put(Float.class, SimpleType.FLOAT);
        PRIMITIVE_TO_OPENTYPE.put(Long.class, SimpleType.LONG);
        PRIMITIVE_TO_OPENTYPE.put(Double.class, SimpleType.DOUBLE);
        PRIMITIVE_TO_OPENTYPE.put(String.class, SimpleType.STRING);
        JNIUtil.checkToLibGraalCalls(JMXToLibGraalEntryPoints.class, JMXToLibGraalCalls.class, JMXToLibGraal.class);
    }
}

