/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.management.JMXToLibGraalCalls;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.util.OptionsEncoder;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class LibGraalMBean
implements DynamicMBean {
    private static final String COMPOSITE_TAG = ".composite";
    private static final String ARRAY_TAG = ".array";
    private static final Map<Class<?>, OpenType<?>> PRIMITIVE_TO_OPENTYPE = new HashMap();
    private final long isolate;
    private final long handle;

    LibGraalMBean(long isolate, long handle) {
        this.isolate = isolate;
        this.handle = handle;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeList attributes = this.getAttributes(new String[]{attribute});
        return attributes.isEmpty() ? null : ((Attribute)attributes.get(0)).getValue();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AttributeList list = new AttributeList();
        list.add(attribute);
        this.setAttributes(list);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            byte[] rawData = JMXToLibGraalCalls.getAttributes(scope.getIsolateThreadAddress(), this.handle, attributes);
            AttributeList attributeList = LibGraalMBean.rawToAttributeList(rawData);
            return attributeList;
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Object item : attributes) {
                Attribute attribute = (Attribute)item;
                map.put(attribute.getName(), attribute.getValue());
            }
            byte[] rawData = OptionsEncoder.encode(map);
            rawData = JMXToLibGraalCalls.setAttributes(scope.getIsolateThreadAddress(), this.handle, rawData);
            AttributeList attributeList = LibGraalMBean.rawToAttributeList(rawData);
            return attributeList;
        }
    }

    private static AttributeList rawToAttributeList(byte[] rawData) {
        AttributeList res = new AttributeList();
        Map map = OptionsEncoder.decode((byte[])rawData);
        PushBackIterator<Map.Entry<String, Object>> it = new PushBackIterator<Map.Entry<String, Object>>(map.entrySet().iterator());
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String attrName = (String)e.getKey();
            Object attrValue = e.getValue();
            try {
                if (LibGraalMBean.isComposite(attrName)) {
                    attrValue = LibGraalMBean.readComposite(attrName, (String)attrValue, it);
                    attrName = LibGraalMBean.attrName(attrName, COMPOSITE_TAG);
                } else if (LibGraalMBean.isArray(attrName)) {
                    attrValue = LibGraalMBean.readArray(attrName, (String)attrValue, it);
                    attrName = LibGraalMBean.attrName(attrName, ARRAY_TAG);
                }
            }
            catch (OpenDataException ex) {
                attrValue = null;
                TTY.printf((String)"WARNING: Cannot read attribute %s due to %s", (Object[])new Object[]{attrName, ex.getMessage()});
            }
            res.add(new Attribute(attrName, attrValue));
        }
        return res;
    }

    private static boolean isComposite(String name) {
        return name.endsWith(COMPOSITE_TAG);
    }

    private static String attrName(String name, String tag) {
        return name.substring(0, name.length() - tag.length());
    }

    private static boolean isArray(String name) {
        return name.endsWith(ARRAY_TAG);
    }

    private static CompositeData readComposite(String scope, String typeName, PushBackIterator<Map.Entry<String, Object>> it) throws OpenDataException {
        String prefix = scope + '.';
        ArrayList<String> attrNames = new ArrayList<String>();
        ArrayList<Object[]> attrValues = new ArrayList<Object[]>();
        ArrayList attrTypes = new ArrayList();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String attrName = e.getKey();
            if (!attrName.startsWith(prefix)) {
                it.pushBack(e);
                break;
            }
            Object[] attrValue = e.getValue();
            if (LibGraalMBean.isComposite(attrName)) {
                attrValue = LibGraalMBean.readComposite(attrName, (String)attrValue, it);
                attrName = LibGraalMBean.attrName(attrName, COMPOSITE_TAG);
            } else if (LibGraalMBean.isArray(attrName)) {
                attrValue = LibGraalMBean.readArray(attrName, (String)attrValue, it);
                attrName = LibGraalMBean.attrName(attrName, ARRAY_TAG);
            }
            attrName = attrName.substring(prefix.length());
            attrNames.add(attrName);
            attrValues.add(attrValue);
            attrTypes.add(LibGraalMBean.getOpenType(attrValue));
        }
        String[] attrNamesArray = attrNames.toArray(new String[attrNames.size()]);
        CompositeType type = new CompositeType(typeName, typeName, attrNamesArray, attrNamesArray, attrTypes.toArray(new OpenType[attrTypes.size()]));
        return new CompositeDataSupport(type, attrNamesArray, attrValues.toArray(new Object[attrValues.size()]));
    }

    private static Object[] readArray(String scope, String typeName, PushBackIterator<Map.Entry<String, Object>> it) throws OpenDataException {
        String prefix = scope + '.';
        ArrayList<Object> elements = new ArrayList<Object>();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String attrName = e.getKey();
            if (!attrName.startsWith(prefix)) {
                it.pushBack(e);
                break;
            }
            Object attrValue = e.getValue();
            elements.add(attrValue);
        }
        Class<?> componentType = null;
        for (Map.Entry<Class<?>, OpenType<?>> e : PRIMITIVE_TO_OPENTYPE.entrySet()) {
            if (!e.getValue().getTypeName().equals(typeName)) continue;
            componentType = e.getKey();
            break;
        }
        if (componentType == null) {
            throw new OpenDataException("Only arrays of simple open types are suppored.");
        }
        return elements.toArray((Object[])Array.newInstance(componentType, elements.size()));
    }

    private static OpenType<?> getOpenType(Object value) throws OpenDataException {
        if (value instanceof CompositeData) {
            return ((CompositeData)value).getCompositeType();
        }
        if (value != null && value.getClass().isArray()) {
            return ArrayType.getArrayType(PRIMITIVE_TO_OPENTYPE.get(value.getClass().getComponentType()));
        }
        Class clz = value == null ? String.class : value.getClass();
        OpenType<?> openType = PRIMITIVE_TO_OPENTYPE.get(clz);
        if (openType == null) {
            throw new IllegalArgumentException(clz.getName());
        }
        return openType;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            LinkedHashMap<String, Object> paramsMap = new LinkedHashMap<String, Object>();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    paramsMap.put(Integer.toString(i), params[i]);
                }
            }
            byte[] rawData = OptionsEncoder.encode(paramsMap);
            rawData = JMXToLibGraalCalls.invoke(scope.getIsolateThreadAddress(), this.handle, actionName, rawData, signature);
            if (rawData == null) {
                throw new MBeanException(null);
            }
            AttributeList attributesList = LibGraalMBean.rawToAttributeList(rawData);
            Object object = attributesList.isEmpty() ? null : ((Attribute)attributesList.get(0)).getValue();
            return object;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try (LibGraalScope scope = new LibGraalScope(this.isolate);){
            byte[] rawData = JMXToLibGraalCalls.getMBeanInfo(scope.getIsolateThreadAddress(), this.handle);
            Map map = OptionsEncoder.decode((byte[])rawData);
            String className = null;
            String description = null;
            ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
            ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
            PushBackIterator<Map.Entry<String, Object>> it = new PushBackIterator<Map.Entry<String, Object>>(map.entrySet().iterator());
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (key.equals("bean.class")) {
                    className = (String)entry.getValue();
                    continue;
                }
                if (key.equals("bean.description")) {
                    description = (String)entry.getValue();
                    continue;
                }
                if (key.startsWith("attr.")) {
                    String attrName = (String)entry.getValue();
                    if (!key.equals("attr." + attrName + ".name")) {
                        throw new IllegalStateException("Invalid order of attribute properties");
                    }
                    MBeanAttributeInfo attr = LibGraalMBean.createAttributeInfo(attrName, it);
                    attributes.add(attr);
                    continue;
                }
                if (!key.startsWith("op.")) continue;
                int opId = (Integer)entry.getValue();
                if (!key.equals("op." + opId + ".id")) {
                    throw new IllegalStateException("Invalid order of operation properties");
                }
                MBeanOperationInfo op = LibGraalMBean.createOperationInfo(opId, it);
                operations.add(op);
            }
            Objects.requireNonNull(className, "ClassName must be non null.");
            Objects.requireNonNull(description, "Description must be non null.");
            MBeanInfo mBeanInfo = new MBeanInfo(className, description, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), null, operations.toArray(new MBeanOperationInfo[operations.size()]), null);
            return mBeanInfo;
        }
    }

    private static MBeanAttributeInfo createAttributeInfo(String attrName, PushBackIterator<Map.Entry<String, Object>> it) {
        String attrType = null;
        String attrDescription = null;
        boolean isReadable = false;
        boolean isWritable = false;
        boolean isIs = false;
        String prefix = "attr." + attrName + ".";
        block14: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            switch (propertyName = key.substring(key.lastIndexOf(46) + 1)) {
                case "type": {
                    attrType = (String)entry.getValue();
                    continue block14;
                }
                case "description": {
                    attrDescription = (String)entry.getValue();
                    continue block14;
                }
                case "r": {
                    isReadable = (Boolean)entry.getValue();
                    continue block14;
                }
                case "w": {
                    isWritable = (Boolean)entry.getValue();
                    continue block14;
                }
                case "i": {
                    isIs = (Boolean)entry.getValue();
                    continue block14;
                }
            }
            throw new IllegalStateException("Unkown attribute property: " + propertyName);
        }
        if (attrType == null) {
            throw new IllegalStateException("Attribute type must be given.");
        }
        return new MBeanAttributeInfo(attrName, attrType, attrDescription, isReadable, isWritable, isIs);
    }

    private static MBeanOperationInfo createOperationInfo(int opId, PushBackIterator<Map.Entry<String, Object>> it) {
        String opName = null;
        String opType = null;
        String opDescription = null;
        int opImpact = 0;
        ArrayList<MBeanParameterInfo> params = new ArrayList<MBeanParameterInfo>();
        String prefix = "op." + opId + ".";
        block14: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            int nextDotIndex = key.indexOf(46, prefix.length());
            nextDotIndex = nextDotIndex < 0 ? key.length() : nextDotIndex;
            switch (propertyName = key.substring(prefix.length(), nextDotIndex)) {
                case "name": {
                    opName = (String)entry.getValue();
                    continue block14;
                }
                case "type": {
                    opType = (String)entry.getValue();
                    continue block14;
                }
                case "description": {
                    opDescription = (String)entry.getValue();
                    continue block14;
                }
                case "i": {
                    opImpact = (Integer)entry.getValue();
                    continue block14;
                }
                case "arg": {
                    String paramName = (String)entry.getValue();
                    if (!key.equals(prefix + "arg." + paramName + ".name")) {
                        throw new IllegalStateException("Invalid order of parameter properties");
                    }
                    MBeanParameterInfo param = LibGraalMBean.createParameterInfo(prefix, paramName, it);
                    params.add(param);
                    continue block14;
                }
            }
            throw new IllegalStateException("Unkown attribute property: " + propertyName);
        }
        if (opName == null) {
            throw new IllegalStateException("Operation name must be given.");
        }
        if (opType == null) {
            throw new IllegalStateException("Operation return type must be given.");
        }
        return new MBeanOperationInfo(opName, opDescription, params.toArray(new MBeanParameterInfo[params.size()]), opType, opImpact);
    }

    private static MBeanParameterInfo createParameterInfo(String owner, String paramName, PushBackIterator<Map.Entry<String, Object>> it) {
        String paramType = null;
        String paramDescription = null;
        String prefix = owner + "arg." + paramName + ".";
        block8: while (it.hasNext()) {
            String propertyName;
            Map.Entry<String, Object> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(prefix)) {
                it.pushBack(entry);
                break;
            }
            switch (propertyName = key.substring(key.lastIndexOf(46) + 1)) {
                case "type": {
                    paramType = (String)entry.getValue();
                    continue block8;
                }
                case "description": {
                    paramDescription = (String)entry.getValue();
                    continue block8;
                }
            }
            throw new IllegalStateException("Unkown parameter property: " + propertyName);
        }
        if (paramType == null) {
            throw new IllegalStateException("Parameter type must be given.");
        }
        return new MBeanParameterInfo(paramName, paramType, paramDescription);
    }

    static {
        PRIMITIVE_TO_OPENTYPE.put(Void.class, SimpleType.VOID);
        PRIMITIVE_TO_OPENTYPE.put(Boolean.class, SimpleType.BOOLEAN);
        PRIMITIVE_TO_OPENTYPE.put(Byte.class, SimpleType.BYTE);
        PRIMITIVE_TO_OPENTYPE.put(Character.class, SimpleType.CHARACTER);
        PRIMITIVE_TO_OPENTYPE.put(Short.class, SimpleType.SHORT);
        PRIMITIVE_TO_OPENTYPE.put(Integer.class, SimpleType.INTEGER);
        PRIMITIVE_TO_OPENTYPE.put(Float.class, SimpleType.FLOAT);
        PRIMITIVE_TO_OPENTYPE.put(Long.class, SimpleType.LONG);
        PRIMITIVE_TO_OPENTYPE.put(Double.class, SimpleType.DOUBLE);
        PRIMITIVE_TO_OPENTYPE.put(String.class, SimpleType.STRING);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class PushBackIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;
        private T pushBack;

        PushBackIterator(Iterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.pushBack != null || this.delegate.hasNext();
        }

        @Override
        public T next() {
            if (this.pushBack != null) {
                T res = this.pushBack;
                this.pushBack = null;
                return res;
            }
            return this.delegate.next();
        }

        void pushBack(T e) {
            if (this.pushBack != null) {
                throw new IllegalStateException("Push back element already exists.");
            }
            this.pushBack = e;
        }
    }
}

