/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.management.AggregatedMemoryPoolBean;
import org.graalvm.compiler.hotspot.management.JMXToLibGraalCalls;
import org.graalvm.compiler.hotspot.management.LibGraalMBean;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class Factory
extends Thread {
    private static final String DOMAIN_GRAALVM_HOTSPOT = "org.graalvm.compiler.hotspot";
    private static final String TYPE_LIBGRAAL = "Libgraal";
    private static final String ATTR_TYPE = "type";
    private static final int POLL_INTERVAL_MS = 2000;
    private static volatile Factory instance;
    private MBeanServer platformMBeanServer;
    private boolean nativeInitialized;
    private AggregatedMemoryPoolBean aggregatedMemoryPoolBean;
    private Map<Long, ObjectName[]> mbeansForActiveIsolate;
    private final Set<Long> pendingIsolates = new LinkedHashSet<Long>();

    private Factory() {
        super("Libgraal MBean Registration");
        this.setPriority(1);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (true) {
                    Factory factory = this;
                    synchronized (factory) {
                        while (this.pendingIsolates.isEmpty()) {
                            this.wait();
                        }
                        try {
                            this.poll();
                        }
                        catch (NoClassDefFoundError | SecurityException | UnsatisfiedLinkError | UnsupportedOperationException e) {
                            break block7;
                        }
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace(TTY.out);
                continue;
            }
            break;
        }
    }

    synchronized void signalRegistrationRequest(long isolate) {
        this.pendingIsolates.add(isolate);
        this.notify();
    }

    synchronized void unregister(long isolate) {
        this.pendingIsolates.remove(isolate);
        MBeanServer mBeanServer = this.findMBeanServer();
        if (mBeanServer == null) {
            return;
        }
        ObjectName[] objectNames = this.mbeansForActiveIsolate.remove(isolate);
        if (objectNames != null) {
            for (ObjectName objectName : objectNames) {
                try {
                    if (this.aggregatedMemoryPoolBean != null && Factory.isLibGraalMBean(objectName)) {
                        this.aggregatedMemoryPoolBean.removeDelegate(objectName);
                    }
                    if (!mBeanServer.isRegistered(objectName)) continue;
                    mBeanServer.unregisterMBean(objectName);
                }
                catch (InstanceNotFoundException | MBeanRegistrationException e) {
                    e.printStackTrace(TTY.out);
                }
            }
        }
    }

    private boolean poll() {
        assert (Thread.holdsLock(this));
        MBeanServer mBeanServer = this.findMBeanServer();
        if (mBeanServer != null) {
            this.initializeNatives();
            return this.process();
        }
        return false;
    }

    private MBeanServer findMBeanServer() {
        ArrayList<MBeanServer> servers;
        assert (Thread.holdsLock(this));
        if (this.platformMBeanServer == null && !(servers = MBeanServerFactory.findMBeanServer(null)).isEmpty()) {
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.platformMBeanServer;
    }

    private void initializeNatives() {
        if (!this.nativeInitialized) {
            try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
                LibGraal.registerNativeMethods(JMXToLibGraalCalls.class);
            }
            this.nativeInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process() {
        Iterator<Long> iter = this.pendingIsolates.iterator();
        while (iter.hasNext()) {
            long isolate = iter.next();
            iter.remove();
            try (LibGraalScope scope = new LibGraalScope(isolate);){
                long isolateThread = scope.getIsolateThreadAddress();
                long[] handles = JMXToLibGraalCalls.pollRegistrations(isolateThread);
                if (handles.length <= 0) continue;
                ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>(handles.length);
                try {
                    for (long handle : handles) {
                        LibGraalMBean bean = new LibGraalMBean(isolate, handle);
                        String name = JMXToLibGraalCalls.getObjectName(isolateThread, handle);
                        try {
                            ObjectName objectName = new ObjectName(name);
                            objectNames.add(objectName);
                            if (Factory.isLibGraalMBean(objectName)) {
                                if (this.aggregatedMemoryPoolBean == null) {
                                    this.aggregatedMemoryPoolBean = new AggregatedMemoryPoolBean(bean, objectName);
                                    this.platformMBeanServer.registerMBean(this.aggregatedMemoryPoolBean, this.aggregatedMemoryPoolBean.getObjectName());
                                } else {
                                    this.aggregatedMemoryPoolBean.addDelegate(bean, objectName);
                                }
                            }
                            this.platformMBeanServer.registerMBean(bean, objectName);
                        }
                        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                            e.printStackTrace(TTY.out);
                        }
                    }
                }
                finally {
                    if (this.mbeansForActiveIsolate == null) {
                        this.mbeansForActiveIsolate = new HashMap<Long, ObjectName[]>();
                    }
                    this.mbeansForActiveIsolate.put(isolate, objectNames.toArray(new ObjectName[objectNames.size()]));
                }
            }
        }
        return true;
    }

    private static boolean isLibGraalMBean(ObjectName objectName) {
        Hashtable<String, String> props = objectName.getKeyPropertyList();
        return DOMAIN_GRAALVM_HOTSPOT.equals(objectName.getDomain()) && TYPE_LIBGRAAL.equals(props.get(ATTR_TYPE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Factory getInstance() {
        Factory res = instance;
        if (res != null) return res;
        Class<LibGraalMBean> clazz = LibGraalMBean.class;
        synchronized (LibGraalMBean.class) {
            res = instance;
            if (res != null) return res;
            try {
                res = new Factory();
                res.start();
                instance = res;
            }
            catch (LinkageError e) {
                Throwable cause = Factory.findCause(e);
                throw Factory.throwUnchecked(RuntimeException.class, cause);
            }
            return res;
        }
    }

    private static Throwable findCause(Throwable e) {
        Throwable current = e;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        return current;
    }

    private static <T extends Throwable> T throwUnchecked(Class<T> exceptionClass, Throwable exception) throws T {
        throw exception;
    }
}

