/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace;

import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.openjdk.jmc.flightrecorder.stacktrace.messages.internal.Messages;

public class StacktraceFormatToolkit {
    public static String formatFrame(IMCFrame frame, FrameSeparator frameSeparator) {
        return StacktraceFormatToolkit.formatFrame(frame, frameSeparator, true, true, true, true, true, true);
    }

    public static String formatFrame(IMCFrame frame, FrameSeparator frameSeparator, boolean showReturnValue, boolean showReturnValuePackage, boolean showClassName, boolean showClassPackageName, boolean showArguments, boolean showArgumentsPackage) {
        String formatted;
        if (frame == StacktraceModel.UNKNOWN_FRAME) {
            return Messages.getString("STACKTRACE_UNCLASSIFIABLE_FRAME");
        }
        String detailsText = "";
        switch (frameSeparator.getCategorization()) {
            case PACKAGE: {
                formatted = FormatToolkit.getPackage((IMCPackage)frame.getMethod().getType().getPackage());
                break;
            }
            case CLASS: {
                formatted = FormatToolkit.getType((IMCType)frame.getMethod().getType(), (boolean)showClassPackageName);
                break;
            }
            case BCI: {
                detailsText = " [BCI: " + StacktraceFormatToolkit.asString(frame.getBCI()) + "]";
            }
            case LINE: {
                detailsText = ":" + StacktraceFormatToolkit.asString(frame.getFrameLineNumber()) + detailsText;
            }
            default: {
                formatted = FormatToolkit.getHumanReadable((IMCMethod)frame.getMethod(), (boolean)showReturnValue, (boolean)showReturnValuePackage, (boolean)showClassName, (boolean)showClassPackageName, (boolean)showArguments, (boolean)showArgumentsPackage) + detailsText;
            }
        }
        if (frameSeparator.isDistinguishFramesByOptimization()) {
            formatted = formatted + " (" + frame.getType().getName() + ")";
        }
        return formatted;
    }

    private static String asString(Object element) {
        return element == null ? "?" : element.toString();
    }
}

