/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.welcome;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import org.graalvm.visualvm.modules.appui.welcome.BundleSupport;
import org.graalvm.visualvm.modules.appui.welcome.LinkButton;
import org.graalvm.visualvm.modules.appui.welcome.Utils;
import org.openide.awt.StatusDisplayer;

public class WebLink
extends LinkButton {
    private static String sourceId;
    private String url;
    private boolean includeSource;

    public WebLink(String key) {
        this(BundleSupport.getLabel(key), BundleSupport.getURL(key), true);
    }

    public WebLink(String key, boolean includeSource) {
        this(BundleSupport.getLabel(key), BundleSupport.getURL(key), includeSource);
    }

    public WebLink(String label, String url, boolean includeSource) {
        super(label);
        this.url = url;
        this.includeSource = includeSource;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Utils.showURL(this.includeSource ? this.url + WebLink.getSourceId() : this.url);
    }

    @Override
    protected void onMouseExited(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText("");
    }

    @Override
    protected void onMouseEntered(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText(this.url);
    }

    private static synchronized String getSourceId() {
        return "?GraalVM_VisualVM";
    }
}

