/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline;

import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.charts.ChartContext;
import org.graalvm.visualvm.lib.charts.ChartItem;
import org.graalvm.visualvm.lib.charts.ChartItemChange;
import org.graalvm.visualvm.lib.charts.ChartSelectionModel;
import org.graalvm.visualvm.lib.charts.ItemPainter;
import org.graalvm.visualvm.lib.charts.PaintersModel;
import org.graalvm.visualvm.lib.charts.swing.LongRect;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYChart;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItemsModel;

final class TimelineChart
extends SynchronousXYChart {
    static final int MIN_ROW_HEIGHT = 20;
    static final int MAX_ROW_HEIGHT = 500;
    static final int DEF_ROW_HEIGHT = 40;
    static final int ROW_RESIZE_STEP = 20;
    private static final int ROW_MARGIN_TOP = 3;
    private static final int ROW_MARGIN_BOTTOM = 3;
    private int currentRowHeight = 40;
    private final List<Row> rows;
    private final Map<ChartItem, Row> itemsToRows;
    private final Set selectedRows = new TreeSet<Row>(new RowComparator());
    private final Set selectionBlockers = new HashSet();
    private int lastHoverMode;
    private int lastMoveMode;
    private final Set<RowListener> rowListeners = new HashSet<RowListener>();

    TimelineChart(SynchronousXYItemsModel itemsModel) {
        super(itemsModel, (PaintersModel)new PaintersModel.Default());
        this.rows = new ArrayList<Row>();
        this.itemsToRows = new HashMap<ChartItem, Row>();
        this.setBottomBased(false);
        this.setZoomMode(1);
        this.setMouseZoomingEnabled(false);
        this.setMousePanningEnabled(false);
        this.setAccelerationPriority(1.0f);
    }

    Row addRow() {
        Row row = new Row();
        int rowIndex = this.rows.size();
        row.setIndex(rowIndex);
        this.rows.add(row);
        row.setHeight(this.currentRowHeight, true);
        row.updateOffset();
        this.updateChart();
        this.notifyRowsAdded(Collections.singletonList(row));
        return row;
    }

    Row addRow(int rowIndex) {
        Row row = new Row();
        row.setIndex(rowIndex);
        this.rows.add(rowIndex, row);
        row.setHeight(this.currentRowHeight, true);
        this.updateRowOffsets(rowIndex);
        this.updateRowIndexes(rowIndex + 1);
        this.updateChart();
        this.notifyRowsAdded(Collections.singletonList(row));
        return row;
    }

    Row removeRow(int rowIndex) {
        return this.removeRow(this.rows.get(rowIndex));
    }

    Row removeRow(Row row) {
        row.clearItems();
        this.rows.remove(row);
        int rowIndex = row.getIndex();
        this.updateRowIndexes(rowIndex);
        this.updateRowOffsets(rowIndex);
        this.updateChart();
        this.notifyRowsRemoved(Collections.singletonList(row));
        return row;
    }

    boolean hasRows() {
        return !this.rows.isEmpty();
    }

    int getRowsCount() {
        return this.rows.size();
    }

    Row getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    Row getRow(ChartItem item) {
        return this.itemsToRows.get(item);
    }

    void setRowHeight(int rowIndex, int rowHeight) {
        this.setRowHeight(rowIndex, rowHeight, true);
    }

    void setRowHeight(int rowIndex, int rowHeight, boolean checkStep) {
        Row row = this.rows.get(rowIndex);
        boolean changed = row.setHeight(rowHeight, checkStep);
        this.updateRowOffsets(rowIndex + 1);
        if (changed) {
            this.notifyRowsResized(Collections.singletonList(row));
        }
        this.updateChart();
    }

    int getRowHeight(int rowIndex) {
        return this.rows.get(rowIndex).getHeight();
    }

    void increaseRowHeights(boolean step) {
        if (this.rows.isEmpty()) {
            return;
        }
        int incr = step ? 20 : 1;
        ArrayList<Row> resized = new ArrayList<Row>(this.rows.size());
        for (Row row : this.rows) {
            if (!row.setHeight(row.getHeight() + incr, step)) continue;
            resized.add(row);
        }
        this.updateRowOffsets(0);
        if (!resized.isEmpty()) {
            this.notifyRowsResized(resized);
        }
        this.updateChart();
        this.currentRowHeight += incr;
    }

    void decreaseRowHeights(boolean step) {
        if (this.rows.isEmpty()) {
            return;
        }
        int decr = step ? 20 : 1;
        ArrayList<Row> resized = new ArrayList<Row>(this.rows.size());
        for (Row row : this.rows) {
            if (!row.setHeight(row.getHeight() - decr, step)) continue;
            resized.add(row);
        }
        this.updateRowOffsets(0);
        if (!resized.isEmpty()) {
            this.notifyRowsResized(resized);
        }
        this.updateChart();
        this.currentRowHeight = Math.max(this.currentRowHeight - decr, 20);
    }

    void resetRowHeights() {
        if (this.rows.isEmpty()) {
            return;
        }
        ArrayList<Row> resized = new ArrayList<Row>(this.rows.size());
        for (Row row : this.rows) {
            if (!row.setHeight(40, true)) continue;
            resized.add(row);
        }
        this.updateRowOffsets(0);
        if (!resized.isEmpty()) {
            this.notifyRowsResized(new ArrayList<Row>(this.rows));
        }
        this.updateChart();
        this.currentRowHeight = 40;
    }

    Row getRowAt(int ypos) {
        ypos = (int)((long)ypos + this.getOffsetY());
        for (Row row : this.rows) {
            int pos = row.getOffset();
            if (ypos < pos) {
                return null;
            }
            if (ypos > (pos += row.getHeight())) continue;
            return row;
        }
        return null;
    }

    Row getNearestRow(int ypos, int range, boolean noFirst) {
        Row row;
        int pos;
        if (this.rows.size() == 0) {
            return null;
        }
        ypos = (int)((long)ypos + this.getOffsetY());
        if (noFirst && ypos < (pos = (row = this.rows.get(0)).getOffset() + row.getHeight()) - range) {
            return null;
        }
        for (Row row2 : this.rows) {
            int pos2 = row2.getOffset();
            if (ypos < pos2 - range) {
                return null;
            }
            if (ypos <= pos2 + range) {
                return row2;
            }
            if (ypos < (pos2 += row2.getHeight()) - range) {
                return null;
            }
            if (ypos > pos2 + range) continue;
            return row2;
        }
        return null;
    }

    private void updateRowOffsets(int rowIndex) {
        int rowsCount = this.rows.size();
        if (rowIndex >= rowsCount) {
            return;
        }
        for (int i = rowIndex; i < rowsCount; ++i) {
            this.rows.get(i).updateOffset();
        }
    }

    void addRowListener(RowListener listener) {
        this.rowListeners.add(listener);
    }

    void removeRowListener(RowListener listener) {
        this.rowListeners.remove(listener);
    }

    private void notifyRowsAdded(final List<Row> rows) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RowListener listener : TimelineChart.this.rowListeners) {
                    listener.rowsAdded(rows);
                }
            }
        });
    }

    private void notifyRowsRemoved(final List<Row> rows) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RowListener listener : TimelineChart.this.rowListeners) {
                    listener.rowsRemoved(rows);
                }
            }
        });
    }

    private void notifyRowsResized(final List<Row> rows) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (RowListener listener : TimelineChart.this.rowListeners) {
                    listener.rowsResized(rows);
                }
            }
        });
    }

    boolean selectRow(Row row) {
        if (!this.selectedRows.add(row)) {
            return false;
        }
        this.repaintRows();
        return true;
    }

    boolean unselectRow(Row row) {
        if (!this.selectedRows.remove(row)) {
            return false;
        }
        this.repaintRows();
        return true;
    }

    boolean setSelectedRow(Row row) {
        if (row == null) {
            return this.clearRowsSelection();
        }
        if (this.selectedRows.size() == 1 && this.selectedRows.contains(row)) {
            return false;
        }
        this.selectedRows.clear();
        this.selectedRows.add(row);
        this.repaintRows();
        return true;
    }

    boolean toggleRowSelection(Row row) {
        if (this.selectedRows.contains(row)) {
            return this.unselectRow(row);
        }
        return this.selectRow(row);
    }

    boolean clearRowsSelection() {
        if (this.selectedRows.isEmpty()) {
            return false;
        }
        this.selectedRows.clear();
        this.repaintRows();
        return true;
    }

    boolean isRowSelected(Row row) {
        return this.selectedRows.contains(row);
    }

    boolean isRowSelection() {
        return !this.selectedRows.isEmpty();
    }

    List<Row> getSelectedRows() {
        return new ArrayList<Row>(this.selectedRows);
    }

    void updateSelection(boolean enable, Object source) {
        int blockersSize = this.selectionBlockers.size();
        if (enable) {
            this.selectionBlockers.remove(source);
        } else {
            this.selectionBlockers.add(source);
        }
        if (this.selectionBlockers.size() == blockersSize) {
            return;
        }
        ChartSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return;
        }
        if (this.selectionBlockers.isEmpty()) {
            selectionModel.setHoverMode(this.lastHoverMode);
        } else {
            this.lastHoverMode = selectionModel.getHoverMode();
            this.lastMoveMode = selectionModel.getMoveMode();
            selectionModel.setHoverMode(100);
        }
    }

    long maxOffsetX() {
        return super.getMaxOffsetX();
    }

    double viewWidth(double d) {
        return super.getViewWidth(d);
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
    }

    protected ChartContext getChartContext(ChartItem item) {
        if (item == null) {
            return super.getChartContext(null);
        }
        return this.itemsToRows.get(item).getContext();
    }

    protected void computeDataBounds() {
        LongRect.clear((LongRect)this.dataBounds);
        if (this.rows == null) {
            return;
        }
        for (Row row : this.rows) {
            RowContext context = (RowContext)row.getContext();
            if (LongRect.isClear((LongRect)this.dataBounds)) {
                LongRect.set((LongRect)this.dataBounds, (LongRect)context.bounds);
                continue;
            }
            LongRect.add((LongRect)this.dataBounds, (LongRect)context.bounds);
        }
        this.dataBounds.y = 0L;
        Row lastRow = this.rows.size() > 0 ? this.rows.get(this.rows.size() - 1) : null;
        this.dataBounds.height = lastRow != null ? (long)(lastRow.getOffset() + lastRow.getHeight()) : 0L;
    }

    protected void updateChart() {
        this.updateRowBounds();
        super.updateChart();
    }

    protected void itemsAdded(List<ChartItem> addedItems) {
        this.updateRowBounds();
        super.itemsAdded(addedItems);
    }

    protected void itemsRemoved(List<ChartItem> removedItems) {
        this.updateRowBounds();
        super.itemsRemoved(removedItems);
    }

    protected void itemsChanged(List<ChartItemChange> itemChanges) {
        this.updateRowBounds();
        super.itemsChanged(itemChanges);
    }

    protected void paintersChanged(List<ItemPainter> changedPainters) {
        this.updateRowBounds();
        super.paintersChanged(changedPainters);
    }

    void addItemsImpl(SynchronousXYItem[] addedItems, ItemPainter[] addedPainters, Row row) {
        for (SynchronousXYItem item : addedItems) {
            this.itemsToRows.put((ChartItem)item, row);
        }
        this.paintersModel().addPainters((ChartItem[])addedItems, addedPainters);
        this.itemsModel().addItems(addedItems);
    }

    void removeItemsImpl(SynchronousXYItem[] removedItems) {
        this.itemsModel().removeItems(removedItems);
        this.paintersModel().removePainters((ChartItem[])removedItems);
        for (SynchronousXYItem item : removedItems) {
            this.itemsToRows.remove(item);
        }
    }

    void invalidateRepaint() {
        this.invalidateImage();
        this.repaintDirty();
    }

    private SynchronousXYItemsModel itemsModel() {
        return (SynchronousXYItemsModel)this.getItemsModel();
    }

    private PaintersModel.Default paintersModel() {
        return (PaintersModel.Default)this.getPaintersModel();
    }

    private void updateRowIndexes(int startIndex) {
        for (int i = startIndex; i < this.rows.size(); ++i) {
            this.rows.get(i).setIndex(i);
        }
    }

    private void repaintRows() {
        this.invalidateImage();
        this.repaintDirty();
    }

    private void repaintRows(int startIndex) {
        for (int i = startIndex; i < this.rows.size(); ++i) {
            ChartContext rowContext = this.rows.get(i).getContext();
            this.invalidateImage(new Rectangle(0, Utils.checkedInt((double)rowContext.getViewportOffsetY()), this.getWidth(), rowContext.getViewportHeight()));
        }
        this.repaintDirty();
    }

    private void updateRowBounds() {
        if (this.rows == null) {
            return;
        }
        for (Row row : this.rows) {
            ((RowContext)row.getContext()).updateBounds();
        }
    }

    public static interface RowListener {
        public void rowsAdded(List<Row> var1);

        public void rowsRemoved(List<Row> var1);

        public void rowsResized(List<Row> var1);
    }

    private static class RowComparator
    implements Comparator<Row> {
        private RowComparator() {
        }

        @Override
        public int compare(Row r1, Row r2) {
            int r2i;
            int r1i = r1.getIndex();
            return r1i < (r2i = r2.getIndex()) ? -1 : (r1i == r2i ? 0 : 1);
        }
    }

    private class RowContext
    extends SynchronousXYChart.Context {
        private final Row row;
        private final LongRect bounds;
        private double scaleY;
        private int marginTop;
        private int marginBottom;

        RowContext(Row row) {
            super((SynchronousXYChart)TimelineChart.this);
            this.row = row;
            this.marginTop = 3;
            this.marginBottom = 3;
            this.bounds = new LongRect();
        }

        protected void updateBounds() {
            LongRect.clear((LongRect)this.bounds);
            PaintersModel.Default painters = TimelineChart.this.paintersModel();
            int itemsCount = this.row.getItemsCount();
            for (int i = 0; i < itemsCount; ++i) {
                ChartItem item = this.row.getItem(i);
                ItemPainter painter = painters.getPainter(item);
                LongRect itemBounds = painter.getItemBounds(item);
                if (LongRect.isClear((LongRect)this.bounds)) {
                    LongRect.set((LongRect)this.bounds, (LongRect)itemBounds);
                    continue;
                }
                if (LongRect.isEmpty((LongRect)itemBounds)) {
                    LongRect.add((LongRect)this.bounds, (long)itemBounds.x, (long)itemBounds.height);
                    continue;
                }
                LongRect.add((LongRect)this.bounds, (LongRect)itemBounds);
            }
            double oldScaleY = this.scaleY;
            this.scaleY = (double)(this.row.getHeight() - this.marginTop - this.marginBottom) / (double)(this.bounds.height == 0L ? 1L : this.bounds.height);
            if (this.scaleY != oldScaleY) {
                TimelineChart.this.invalidateImage(Utils.checkedRectangle((LongRect)this.getViewRect(this.bounds)));
            }
        }

        public boolean isBottomBased() {
            return true;
        }

        public boolean fitsHeight() {
            return true;
        }

        public long getDataOffsetY() {
            return this.bounds.y;
        }

        public long getDataHeight() {
            return this.bounds.height;
        }

        public long getViewHeight() {
            return this.row.getHeight();
        }

        public long getViewportOffsetY() {
            return (long)this.row.getOffset() - TimelineChart.this.getOffsetY();
        }

        public int getViewportHeight() {
            return this.row.getHeight();
        }

        public double getViewY(double dataY) {
            return this.getViewY(dataY, false);
        }

        public double getReversedViewY(double dataY) {
            return this.getViewY(dataY, true);
        }

        public double getViewHeight(double dataHeight) {
            return dataHeight * this.scaleY;
        }

        public double getDataY(double viewY) {
            return this.getDataY(viewY, false);
        }

        public double getReversedDataY(double viewY) {
            return this.getDataY(viewY, true);
        }

        public double getDataHeight(double viewHeight) {
            return viewHeight / this.scaleY;
        }

        private double getViewY(double dataY, boolean reverse) {
            if (this.isBottomBased() && !reverse || !this.isBottomBased() && reverse) {
                return (double)this.row.getHeight() - (dataY - (double)this.bounds.y) * this.scaleY - (double)TimelineChart.this.getOffsetY() + (double)TimelineChart.this.getViewInsets().top - (double)this.marginBottom + (double)this.row.getOffset();
            }
            return (dataY - (double)this.bounds.y) * this.scaleY - (double)TimelineChart.this.getOffsetY() + (double)TimelineChart.this.getViewInsets().top + (double)this.marginTop + (double)this.row.getOffset();
        }

        private double getDataY(double viewY, boolean reverse) {
            if (this.isBottomBased() && !reverse || !this.isBottomBased() && reverse) {
                return (double)this.bounds.y - (viewY + (double)TimelineChart.this.getViewInsets().bottom - (double)this.marginBottom - (double)TimelineChart.this.getOffsetY() - (double)TimelineChart.this.getHeight()) / this.scaleY;
            }
            return (viewY + (double)TimelineChart.this.getOffsetY() - (double)TimelineChart.this.getViewInsets().top - (double)this.marginTop) / this.scaleY + (double)this.bounds.y;
        }
    }

    class Row {
        private int rowIndex;
        private int rowOffset;
        private int rowHeight;
        private final List<SynchronousXYItem> items = new ArrayList<SynchronousXYItem>();
        private final RowContext context;

        Row() {
            this.context = new RowContext(this);
        }

        int getIndex() {
            return this.rowIndex;
        }

        private void updateOffset() {
            if (this.rowIndex != 0) {
                Row previousRow = (Row)TimelineChart.this.rows.get(this.rowIndex - 1);
                this.rowOffset = previousRow.rowOffset + previousRow.rowHeight;
            } else {
                this.rowOffset = 0;
            }
        }

        int getOffset() {
            return this.rowOffset;
        }

        private boolean setHeight(int height, boolean checkStep) {
            height = Math.max(20, height);
            height = Math.min(500, height);
            if (checkStep) {
                height = height / 20 * 20;
            }
            boolean changed = this.rowHeight != height;
            this.rowHeight = height;
            return changed;
        }

        int getHeight() {
            return this.rowHeight;
        }

        void addItems(SynchronousXYItemsModel addedItems, PaintersModel addedPainters) {
            int itemsCount = addedItems.getItemsCount();
            SynchronousXYItem[] addedItemsArr = new SynchronousXYItem[itemsCount];
            for (int i = 0; i < itemsCount; ++i) {
                addedItemsArr[i] = addedItems.getItem(i);
            }
            ItemPainter[] addedPaintersArr = new ItemPainter[itemsCount];
            for (int i = 0; i < itemsCount; ++i) {
                addedPaintersArr[i] = addedPainters.getPainter((ChartItem)addedItemsArr[i]);
            }
            this.addItems(addedItemsArr, addedPaintersArr);
        }

        void addItems(SynchronousXYItem[] addedItems, ItemPainter[] addedPainters) {
            for (SynchronousXYItem item : addedItems) {
                this.items.add(item);
            }
            TimelineChart.this.addItemsImpl(addedItems, addedPainters, this);
        }

        void removeItems(SynchronousXYItemsModel removedItems) {
            int itemsCount = removedItems.getItemsCount();
            SynchronousXYItem[] removedItemsArr = new SynchronousXYItem[itemsCount];
            for (int i = 0; i < itemsCount; ++i) {
                removedItemsArr[i] = removedItems.getItem(i);
            }
            this.removeItems(removedItemsArr);
        }

        void removeItems(SynchronousXYItem[] removedItems) {
            TimelineChart.this.removeItemsImpl(removedItems);
            for (SynchronousXYItem item : removedItems) {
                this.items.remove(item);
            }
        }

        int getItemsCount() {
            return this.items.size();
        }

        ChartItem getItem(int itemIndex) {
            return (ChartItem)this.items.get(itemIndex);
        }

        SynchronousXYItem[] getItems() {
            return this.items.toArray(new SynchronousXYItem[0]);
        }

        boolean containsItem(ChartItem item) {
            return this.items.contains(item);
        }

        ChartContext getContext() {
            return this.context;
        }

        private void setIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        private void clearItems() {
            if (this.items.size() == 0) {
                return;
            }
            TimelineChart.this.removeItemsImpl(this.getItems());
        }
    }
}

