/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.packages;

import java.io.IOException;
import org.graalvm.visualvm.lib.profiler.snaptracer.ItemValueFormatter;
import org.graalvm.visualvm.lib.profiler.snaptracer.ProbeItemDescriptor;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbe;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.IdeSnapshot;
import org.openide.util.Exceptions;

class TestProbe
extends TracerProbe {
    private IdeSnapshot snapshot;

    public TestProbe(IdeSnapshot snapshot) {
        super(TestProbe.descriptors(1));
        this.snapshot = snapshot;
    }

    @Override
    public long[] getItemValues(int sampleIndex) {
        return this.values(sampleIndex);
    }

    private static ProbeItemDescriptor[] descriptors(int items) {
        ProbeItemDescriptor[] descriptors = new ProbeItemDescriptor[items];
        descriptors[0] = ProbeItemDescriptor.continuousLineItem("Cumulative stack depth", "Reports the cumulative depth of all running threads", ItemValueFormatter.DEFAULT_DECIMAL);
        return descriptors;
    }

    private long[] values(int sampleIndex) {
        long[] values = new long[1];
        try {
            values[0] = this.snapshot.getValue(sampleIndex, 0);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return values;
    }
}

