/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.util;

import com.oracle.svm.core.graal.llvm.LLVMGenerator;
import com.oracle.svm.core.graal.llvm.util.LLVMIRBuilder;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMTypeRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMValueRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.global.LLVM;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;

public class LLVMUtils {
    static final int FALSE = 0;
    static final int TRUE = 1;

    public static LLVMValueRef getVal(Value value) {
        return ((LLVMValueWrapper)value).get();
    }

    public static LLVMTypeRef getType(ValueKind<?> kind) {
        return ((LLVMTypeWrapper)kind.getPlatformKind()).get();
    }

    public static String dumpValues(String prefix, LLVMValueRef ... values) {
        StringBuilder builder = new StringBuilder(prefix);
        for (LLVMValueRef value : values) {
            builder.append(" ");
            builder.append(LLVM.LLVMPrintValueToString((LLVMValueRef)value).getString());
        }
        return builder.toString();
    }

    public static String dumpTypes(String prefix, LLVMTypeRef ... types) {
        StringBuilder builder = new StringBuilder(prefix);
        for (LLVMTypeRef type : types) {
            builder.append(" ");
            builder.append(LLVM.LLVMPrintTypeToString((LLVMTypeRef)type).getString());
        }
        return builder.toString();
    }

    public static final class LLVMKind
    implements PlatformKind,
    LLVMTypeWrapper {
        private final LLVMTypeRef type;

        private LLVMKind(LLVMTypeRef type) {
            this.type = type;
        }

        static LIRKind toLIRKind(LLVMTypeRef type) {
            if (LLVMIRBuilder.isPointerType(type) && LLVMIRBuilder.isTrackedPointerType(type)) {
                if (LLVMIRBuilder.isCompressedPointerType(type)) {
                    return LIRKind.compressedReference((PlatformKind)new LLVMKind(type));
                }
                return LIRKind.reference((PlatformKind)new LLVMKind(type));
            }
            return LIRKind.value((PlatformKind)new LLVMKind(type));
        }

        @Override
        public LLVMTypeRef get() {
            return this.type;
        }

        public String name() {
            return LLVM.LLVMPrintTypeToString((LLVMTypeRef)this.type).getString();
        }

        public PlatformKind.Key getKey() {
            throw GraalError.unimplemented();
        }

        public int getSizeInBytes() {
            switch (LLVM.LLVMGetTypeKind((LLVMTypeRef)this.type)) {
                case 8: {
                    return NumUtil.roundUp((int)LLVM.LLVMGetIntTypeWidth((LLVMTypeRef)this.type), (int)8) / 8;
                }
                case 2: {
                    return 4;
                }
                case 3: 
                case 12: {
                    return 8;
                }
            }
            throw GraalError.shouldNotReachHere((String)"invalid kind");
        }

        public int getVectorLength() {
            return 1;
        }

        public char getTypeChar() {
            throw GraalError.unimplemented();
        }
    }

    public static class LLVMKindTool
    implements LIRKindTool {
        private LLVMIRBuilder builder;

        public LLVMKindTool(LLVMIRBuilder builder) {
            this.builder = builder;
        }

        public LIRKind getIntegerKind(int bits) {
            return LIRKind.value((PlatformKind)new LLVMKind(this.builder.integerType(bits)));
        }

        public LIRKind getFloatingKind(int bits) {
            switch (bits) {
                case 32: {
                    return LIRKind.value((PlatformKind)new LLVMKind(this.builder.floatType()));
                }
                case 64: {
                    return LIRKind.value((PlatformKind)new LLVMKind(this.builder.doubleType()));
                }
            }
            throw GraalError.shouldNotReachHere((String)"invalid float type");
        }

        public LIRKind getObjectKind() {
            return LIRKind.reference((PlatformKind)new LLVMKind(this.builder.objectType(false)));
        }

        public LIRKind getWordKind() {
            return LIRKind.value((PlatformKind)new LLVMKind(this.builder.wordType()));
        }

        public LIRKind getNarrowOopKind() {
            return LIRKind.compressedReference((PlatformKind)new LLVMKind(this.builder.objectType(true)));
        }

        public LIRKind getNarrowPointerKind() {
            throw GraalError.unimplemented();
        }
    }

    public static class LLVMPendingSpecialRegisterRead
    extends LLVMVariable
    implements LLVMValueWrapper {
        private final LLVMGenerator gen;
        private final LLVMGenerator.SpecialRegister reg;
        private final LLVMValueRef offset;

        public LLVMPendingSpecialRegisterRead(LLVMGenerator gen, LLVMGenerator.SpecialRegister reg) {
            this(gen, reg, null);
        }

        public LLVMPendingSpecialRegisterRead(LLVMPendingSpecialRegisterRead pendingRead, LLVMValueRef offset) {
            this(pendingRead.gen, pendingRead.reg, offset);
        }

        private LLVMPendingSpecialRegisterRead(LLVMGenerator gen, LLVMGenerator.SpecialRegister reg, LLVMValueRef offset) {
            super((ValueKind<?>)LLVMKind.toLIRKind(gen.getBuilder().wordType()));
            this.gen = gen;
            this.reg = reg;
            this.offset = offset;
        }

        @Override
        public LLVMValueRef get() {
            LLVMIRBuilder builder = this.gen.getBuilder();
            LLVMValueRef register = this.gen.getSpecialRegister(this.reg);
            return this.offset == null ? register : builder.buildGEP(builder.buildIntToPtr(register, builder.rawPointerType()), this.offset);
        }
    }

    public static class LLVMStackSlot
    extends VirtualStackSlot
    implements LLVMValueWrapper {
        private static int id = 0;
        private LLVMValueRef value;

        public LLVMStackSlot(LLVMValueRef value) {
            super(id++, (ValueKind)LLVMKind.toLIRKind(LLVM.LLVMTypeOf((LLVMValueRef)value)));
            this.value = value;
        }

        @Override
        public LLVMValueRef get() {
            return this.value;
        }
    }

    public static class LLVMConstant
    extends ConstantValue
    implements LLVMValueWrapper {
        private final LLVMValueRef value;

        public LLVMConstant(LLVMValueRef value, Constant constant) {
            super((ValueKind)LLVMKind.toLIRKind(LLVMIRBuilder.typeOf(value)), constant);
            this.value = value;
        }

        @Override
        public LLVMValueRef get() {
            return this.value;
        }
    }

    public static class LLVMVariable
    extends Variable
    implements LLVMValueWrapper {
        private static int id = 0;
        private LLVMValueRef value;

        public LLVMVariable(ValueKind<?> kind) {
            super(kind, id++);
        }

        public LLVMVariable(LLVMValueRef value) {
            this((ValueKind<?>)LLVMKind.toLIRKind(LLVM.LLVMTypeOf((LLVMValueRef)value)));
            this.value = value;
        }

        public void set(LLVMValueRef value) {
            assert (this.value == null);
            this.value = value;
        }

        @Override
        public LLVMValueRef get() {
            return this.value;
        }
    }

    static interface LLVMTypeWrapper {
        public LLVMTypeRef get();
    }

    public static interface LLVMValueWrapper {
        public LLVMValueRef get();
    }
}

