/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.util;

import com.oracle.svm.core.option.HostedOptionKey;
import java.util.Arrays;
import java.util.List;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;

public class LLVMOptions {
    @Option(help={"Include debugging info in the generated image (for LLVM backend)."}, type=OptionType.Debug)
    public static final HostedOptionKey<Integer> IncludeLLVMDebugInfo = new HostedOptionKey((Object)0);
    @Option(help={"Dump contents of the generated stackmap to the specified file"}, type=OptionType.Debug)
    public static final HostedOptionKey<String> DumpLLVMStackMap = new HostedOptionKey(null);
    @Option(help={"Maximum size of batches used for LLVM compilation. 0 means a single batch, 1 means all functions separately"}, type=OptionType.Debug)
    public static final HostedOptionKey<Integer> LLVMMaxFunctionsPerBatch = new HostedOptionKey((Object)1000);
    @Option(help={"Path to a custom ld binary for LLVM linking"})
    public static final HostedOptionKey<String> CustomLD = new HostedOptionKey((Object)"");
    @Option(help={"Enable LLVM bitcode optimizations"})
    public static final HostedOptionKey<Boolean> BitcodeOptimizations = new HostedOptionKey((Object)false);
    @Option(help={"Return special registers from functions in LLVM bitcode. This may decrease performance if the target doesn't support returning multiple values from a function."})
    public static final HostedOptionKey<Boolean> ReturnSpecialRegs = new HostedOptionKey((Object)true);
    public static final List<HostedOptionKey<?>> allOptions = Arrays.asList(IncludeLLVMDebugInfo, DumpLLVMStackMap, LLVMMaxFunctionsPerBatch, CustomLD, BitcodeOptimizations, ReturnSpecialRegs);
}

