/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.replacements;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;

@NodeInfo
public abstract class LLVMIntrinsicNode
extends FloatingNode
implements ArithmeticLIRLowerable,
Canonicalizable {
    public static final NodeClass<LLVMIntrinsicNode> TYPE = NodeClass.create(LLVMIntrinsicNode.class);
    protected final LLVMIntrinsicOperation op;

    public LLVMIntrinsicNode(NodeClass<? extends LLVMIntrinsicNode> c, LLVMIntrinsicOperation op, JavaKind kind) {
        super(c, StampFactory.forKind((JavaKind)kind));
        this.op = op;
    }

    public static enum LLVMIntrinsicOperation {
        LOG(1),
        LOG10(1),
        EXP(1),
        POW(2),
        SIN(1),
        COS(1),
        SQRT(1),
        ABS(1),
        ROUND(1),
        RINT(1),
        CEIL(1),
        FLOOR(1),
        MIN(2),
        MAX(2),
        COPYSIGN(2),
        FMA(3),
        CTLZ(1),
        CTTZ(1),
        CTPOP(1);

        private int argCount;

        private LLVMIntrinsicOperation(int argCount) {
            this.argCount = argCount;
        }

        public int argCount() {
            return this.argCount;
        }
    }
}

