/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.code.SubstrateSuitesCreatorProvider;
import com.oracle.svm.core.graal.llvm.LLVMNativeImageCodeCache;
import com.oracle.svm.core.graal.llvm.SubstrateLLVMBackend;
import com.oracle.svm.core.graal.llvm.lowering.LLVMLoadExceptionObjectLowering;
import com.oracle.svm.core.graal.llvm.lowering.SubstrateLLVMLoweringProvider;
import com.oracle.svm.core.graal.llvm.replacements.LLVMGraphBuilderPlugins;
import com.oracle.svm.core.graal.llvm.runtime.LLVMExceptionUnwind;
import com.oracle.svm.core.graal.llvm.util.LLVMOptions;
import com.oracle.svm.core.graal.llvm.util.LLVMToolchain;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.ExceptionUnwind;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.image.NativeImageHeap;
import java.nio.file.Path;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.java.LoadExceptionObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;

@AutomaticFeature
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public class LLVMFeature
implements Feature,
GraalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        if (!SubstrateOptions.useLLVMBackend()) {
            for (HostedOptionKey<?> llvmOption : LLVMOptions.allOptions) {
                if (!llvmOption.hasBeenSet()) continue;
                throw UserError.abort((String)"Flag %s can only be used together with -H:CompilerBackend=llvm", (Object[])new Object[]{llvmOption.getName()});
            }
        }
        return SubstrateOptions.useLLVMBackend();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(){

            public SubstrateBackend newBackend(Providers newProviders) {
                return new SubstrateLLVMBackend(newProviders);
            }
        });
        ImageSingletons.add(SubstrateLoweringProviderFactory.class, SubstrateLLVMLoweringProvider::new);
        ImageSingletons.add(NativeImageCodeCacheFactory.class, (Object)new NativeImageCodeCacheFactory(){

            public NativeImageCodeCache newCodeCache(CompileQueue compileQueue, NativeImageHeap heap, Platform platform, Path tempDir) {
                return new LLVMNativeImageCodeCache(compileQueue.getCompilations(), heap, platform, tempDir);
            }
        });
        ImageSingletons.add(ExceptionUnwind.class, (Object)new ExceptionUnwind(){

            protected void customUnwindException(Pointer callerSP) {
                LLVMExceptionUnwind.raiseException();
            }
        });
        ImageSingletons.add(TargetGraphBuilderPlugins.class, (Object)new LLVMGraphBuilderPlugins());
        ImageSingletons.add(SubstrateSuitesCreatorProvider.class, (Object)new SubstrateSuitesCreatorProvider());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        accessImpl.registerAsCompiled((AnalysisMethod)LLVMExceptionUnwind.getRetrieveExceptionMethod((MetaAccessProvider)accessImpl.getMetaAccess()));
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        lowerings.put(LoadExceptionObjectNode.class, new LLVMLoadExceptionObjectLowering());
    }

    static class LLVMVersionChecker {
        private static final int MIN_LLVM_VERSION = 8;
        private static final int MIN_LLVM_OPTIMIZATIONS_VERSION = 9;
        private static final int llvmVersion = LLVMVersionChecker.getLLVMVersion();

        LLVMVersionChecker() {
        }

        static boolean useExplicitSelects() {
            if (!Platform.includedIn(Platform.AMD64.class)) {
                return false;
            }
            return llvmVersion < 9;
        }

        private static int getLLVMVersion() {
            String versionString;
            try {
                versionString = LLVMToolchain.runLLVMCommand("llvm-config", null, "--version");
            }
            catch (LLVMToolchain.RunFailureException e) {
                throw UserError.abort((String)"Using the LLVM backend requires LLVM to be installed on your machine.", (Object[])new Object[0]);
            }
            String[] splitVersion = versionString.split("\\.");
            assert (splitVersion.length == 3);
            int version = Integer.parseInt(splitVersion[0]);
            if (version < 8) {
                throw UserError.abort((String)"Unsupported LLVM version: %d. Supported versions are LLVM %d and above", (Object[])new Object[]{version, 8});
            }
            if (((Boolean)LLVMOptions.BitcodeOptimizations.getValue()).booleanValue() && version < 9) {
                throw UserError.abort((String)"Unsupported LLVM version to enable bitcode optimizations: %d. Supported versions are LLVM %d.0.0 and above", (Object[])new Object[]{version, 9});
            }
            return version;
        }
    }
}

