/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.Collections;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

class ClassDumpInstance
implements Instance {
    ClassDump classDump;

    ClassDumpInstance(ClassDump cls) {
        this.classDump = cls;
    }

    @Override
    public List getFieldValues() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isGCRoot() {
        return this.classDump.getHprof().isGCRoot(this);
    }

    @Override
    public long getInstanceId() {
        return this.classDump.getJavaClassId();
    }

    @Override
    public int getInstanceNumber() {
        return this.classDump.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    @Override
    public JavaClass getJavaClass() {
        return this.classDump.classDumpSegment.java_lang_Class;
    }

    @Override
    public Instance getNearestGCRootPointer() {
        return this.classDump.getHprof().getNearestGCRootPointer(this);
    }

    @Override
    public long getReachableSize() {
        return 0L;
    }

    @Override
    public List getReferences() {
        return this.classDump.getReferences();
    }

    @Override
    public long getRetainedSize() {
        return this.classDump.getHprof().getRetainedSize(this);
    }

    @Override
    public long getSize() {
        return this.getJavaClass().getInstanceSize();
    }

    @Override
    public List getStaticFieldValues() {
        return this.getJavaClass().getStaticFieldValues();
    }

    @Override
    public Object getValueOfField(String name) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassDumpInstance) {
            return this.classDump.equals(((ClassDumpInstance)obj).classDump);
        }
        return false;
    }

    public int hashCode() {
        return this.classDump.hashCode();
    }
}

