/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalFeature;
import java.util.Map;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;

@TargetClass(className="org.graalvm.compiler.hotspot.HotSpotGraalOptionValues", onlyWith={LibGraalFeature.IsEnabled.class})
final class Target_org_graalvm_compiler_hotspot_HotSpotGraalOptionValues {
    Target_org_graalvm_compiler_hotspot_HotSpotGraalOptionValues() {
    }

    @Substitute
    private static OptionValues initializeOptions() {
        if (!XOptions.getXmn().getPrefix().equals("-X")) {
            throw new InternalError("Expected " + XOptions.getXmn().getPrefixAndName() + " to start with -X");
        }
        RuntimeOptionValues options = RuntimeOptionValues.singleton();
        options.update((UnmodifiableEconomicMap)HotSpotGraalOptionValues.parseOptions());
        Map savedProps = Services.getSavedProperties();
        EconomicMap optionSettings = EconomicMap.create();
        for (Map.Entry e : savedProps.entrySet()) {
            String name = (String)e.getKey();
            if (!name.startsWith("libgraal.")) continue;
            if (name.startsWith("libgraal.X")) {
                String[] xarg = new String[]{"-" + name.substring("libgraal.".length()) + (String)e.getValue()};
                String[] unknown = XOptions.singleton().parse(xarg, false);
                if (unknown.length != 0) continue;
                continue;
            }
            String value = (String)e.getValue();
            optionSettings.put((Object)name.substring("libgraal.".length()), (Object)value);
        }
        if (!optionSettings.isEmpty()) {
            EconomicMap values = OptionValues.newOptionMap();
            Iterable loader = OptionsParser.getOptionsLoader();
            OptionsParser.parseOptions((EconomicMap)optionSettings, (EconomicMap)values, (Iterable)loader);
            options.update((UnmodifiableEconomicMap)values);
        }
        return options;
    }
}

