/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.ComponentCatalog;
import org.graalvm.component.installer.ComponentIterable;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.FailedOperationException;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.FileIterable;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.UnknownVersionException;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.graalvm.component.installer.remote.FileDownloader;
import org.graalvm.component.installer.remote.RemoteComponentParam;

public class CatalogIterable
implements ComponentIterable {
    private final CommandInput input;
    private final Feedback feedback;
    private ComponentCatalog remoteRegistry;
    private boolean verifyJars;
    private boolean incompatible;
    private Version.Match versionFilter;

    public CatalogIterable(CommandInput input, Feedback feedback) {
        this.input = input;
        this.feedback = feedback.withBundle(CatalogIterable.class);
    }

    public boolean isVerifyJars() {
        return this.verifyJars;
    }

    @Override
    public void setVerifyJars(boolean verifyJars) {
        this.verifyJars = verifyJars;
    }

    @Override
    public Iterator<ComponentParam> iterator() {
        return new It();
    }

    ComponentCatalog getRegistry() {
        if (this.remoteRegistry == null) {
            this.remoteRegistry = this.input.getCatalogFactory().createComponentCatalog(this.input);
        }
        return this.remoteRegistry;
    }

    @Override
    public ComponentIterable allowIncompatible() {
        this.incompatible = true;
        return this;
    }

    @Override
    public ComponentIterable matchVersion(Version.Match m) {
        this.versionFilter = m;
        return this;
    }

    private ComponentParam latest(String s, Collection<ComponentInfo> infos) {
        ArrayList<ComponentInfo> ordered = new ArrayList<ComponentInfo>(infos);
        Collections.sort(ordered, ComponentInfo.reverseVersionComparator(this.input.getLocalRegistry().getManagementStorage()));
        boolean progress = this.input.optValue("n") == null;
        return this.createComponentParam(s, (ComponentInfo)ordered.get(0), progress);
    }

    @Override
    public ComponentParam createParam(String cmdString, ComponentInfo info) {
        boolean progress = this.input.optValue("n") == null;
        return this.createComponentParam(cmdString, info, progress);
    }

    protected ComponentParam createComponentParam(String cmdLineString, ComponentInfo info, boolean progress) {
        CatalogItemParam param = new CatalogItemParam(this.getRegistry().getDownloadInterceptor(), info, info.getName(), cmdLineString, this.feedback, progress);
        param.setVerifyJars(this.verifyJars);
        return param;
    }

    public static class CatalogItemParam
    extends RemoteComponentParam {
        final ComponentCatalog.DownloadInterceptor configurer;

        public CatalogItemParam(ComponentCatalog.DownloadInterceptor conf, ComponentInfo catalogInfo, String dispName, String spec, Feedback feedback, boolean progress) {
            super(catalogInfo, dispName, spec, feedback, progress);
            this.configurer = conf;
        }

        @Override
        public MetadataLoader createMetaLoader() throws IOException {
            if (this.configurer == null) {
                return super.createMetaLoader();
            }
            return this.configurer.interceptMetadataLoader(this.getCatalogInfo(), super.createMetaLoader());
        }

        @Override
        public FileDownloader configureRelatedDownloader(FileDownloader dn) {
            return this.configurer.processDownloader(this.getCatalogInfo(), dn);
        }

        @Override
        protected FileDownloader createDownloader() {
            FileDownloader d = super.createDownloader();
            return this.configureRelatedDownloader(d);
        }

        @Override
        protected MetadataLoader metadataFromLocal(Path localFile) throws IOException {
            String serial = this.getCatalogInfo().getTag();
            FileDownloader theDownloader = this.getDownloader();
            if (serial == null || "".equals(serial)) {
                serial = theDownloader != null ? SystemUtils.fingerPrint(theDownloader.getReceivedDigest(), false) : null;
            }
            FileIterable.FileComponent fc = new FileIterable.FileComponent(localFile.toFile(), this.isVerifyJars(), serial, this.getFeedback());
            return fc.createFileLoader();
        }

        @Override
        public ComponentInfo completeMetadata() throws IOException {
            return this.createFileLoader().completeMetadata();
        }
    }

    private class It
    implements Iterator<ComponentParam> {
        private final List<String> expandedIds = new ArrayList<String>();

        private It() {
        }

        private void thrownUnknown(String fname, boolean throwUnknown) {
            File f = new File(fname);
            if (f.exists() && f.isFile()) {
                throw CatalogIterable.this.feedback.failure("REMOTE_UnknownComponentMaybeFile", null, fname);
            }
            if (throwUnknown) {
                throw CatalogIterable.this.feedback.failure("REMOTE_UnknownComponentId", null, fname);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.expandedIds.isEmpty() || CatalogIterable.this.input.hasParameter();
        }

        private List<String> expandId(String pattern, Version.Match vm) {
            PathMatcher pm = FileSystems.getDefault().getPathMatcher("glob:" + pattern.toLowerCase(Locale.ENGLISH));
            HashSet<String> ids = new HashSet<String>(CatalogIterable.this.getRegistry().getComponentIDs());
            HashMap<ComponentInfo, String> abbreviatedIds = new HashMap<ComponentInfo, String>();
            for (String id : ids) {
                Collection<ComponentInfo> infos = CatalogIterable.this.getRegistry().loadComponents(id, Version.NO_VERSION.match(Version.Match.Type.GREATER), false);
                for (ComponentInfo info : infos) {
                    abbreviatedIds.put(info, CatalogIterable.this.getRegistry().shortenComponentId(info));
                }
            }
            ids.addAll(abbreviatedIds.values());
            if (ids.contains(pattern)) {
                return Collections.singletonList(pattern);
            }
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                String s2 = ((String)it.next()).toLowerCase(Locale.ENGLISH);
                if (pm.matches(SystemUtils.fromUserString(s2))) continue;
                it.remove();
            }
            HashSet infos = new HashSet();
            ids.forEach(s -> infos.add(CatalogIterable.this.getRegistry().findComponent((String)s, vm)));
            ArrayList<String> sorted = new ArrayList<String>();
            for (ComponentInfo ci : infos) {
                if (ci == null) continue;
                String ab = (String)abbreviatedIds.get(ci);
                if (pm.matches(SystemUtils.fromUserString(ab))) {
                    sorted.add(ab);
                    continue;
                }
                sorted.add(ci.getId());
            }
            Collections.sort(sorted);
            return sorted;
        }

        @Override
        public ComponentParam next() {
            List<String> expanded;
            if (!this.expandedIds.isEmpty()) {
                return this.processParameter(this.expandedIds.remove(0));
            }
            String s = CatalogIterable.this.input.nextParameter();
            Version.Match[] m = new Version.Match[1];
            String id = Version.idAndVersion(s, m);
            if (m[0].getType() == Version.Match.Type.MOSTRECENT && CatalogIterable.this.versionFilter != null) {
                m[0] = CatalogIterable.this.versionFilter;
            }
            if ((expanded = this.expandId(id, m[0])).isEmpty()) {
                return this.processParameter(s);
            }
            String suffix = s.substring(id.length());
            for (String ei : expanded) {
                this.expandedIds.add(ei + suffix);
            }
            return this.processParameter(this.expandedIds.remove(0));
        }

        private ComponentParam processParameter(String s) {
            ComponentInfo info;
            try {
                Version.Match[] m = new Version.Match[1];
                String id = Version.idAndVersion(s, m);
                if (m[0].getType() == Version.Match.Type.MOSTRECENT && CatalogIterable.this.versionFilter != null) {
                    m[0] = CatalogIterable.this.versionFilter;
                }
                try {
                    info = CatalogIterable.this.getRegistry().findComponent(id, m[0]);
                }
                catch (UnknownVersionException ex) {
                    if (ex.getCandidate() == null) {
                        throw CatalogIterable.this.feedback.failure("REMOTE_NoSpecificVersion", ex, id, m[0].getVersion().displayString());
                    }
                    throw CatalogIterable.this.feedback.failure("REMOTE_NoSpecificVersion2", ex, id, m[0].getVersion().displayString(), ex.getCandidate().displayString());
                }
                if (info == null) {
                    Version gv = CatalogIterable.this.input.getLocalRegistry().getGraalVersion();
                    Version.Match selector = gv.match(Version.Match.Type.INSTALLABLE);
                    Collection<ComponentInfo> infos = CatalogIterable.this.getRegistry().loadComponents(id, selector, false);
                    if (infos != null && !infos.isEmpty()) {
                        if (CatalogIterable.this.incompatible) {
                            return CatalogIterable.this.latest(s, infos);
                        }
                        String rvs = infos.iterator().next().getRequiredGraalValues().get("graalvm_version");
                        Version rv = Version.fromString(rvs);
                        if (rv.compareTo(gv) > 0) {
                            throw CatalogIterable.this.feedback.failure("REMOTE_UpgradeGraalVMCore", null, id, rvs);
                        }
                        if (m[0].getType() == Version.Match.Type.EXACT) {
                            throw CatalogIterable.this.feedback.failure("REMOTE_NoSpecificVersion", null, id, m[0].getVersion().displayString());
                        }
                    }
                    if ((infos = CatalogIterable.this.getRegistry().loadComponents(id, Version.NO_VERSION.match(Version.Match.Type.GREATER), false)) != null && !infos.isEmpty()) {
                        if (CatalogIterable.this.incompatible) {
                            return CatalogIterable.this.latest(s, infos);
                        }
                        throw CatalogIterable.this.feedback.failure("REMOTE_IncompatibleComponentVersion", null, id);
                    }
                    this.thrownUnknown(s, true);
                }
            }
            catch (FailedOperationException ex) {
                this.thrownUnknown(s, false);
                throw ex;
            }
            boolean progress = CatalogIterable.this.input.optValue("n") == null;
            return CatalogIterable.this.createComponentParam(s, info, progress);
        }
    }
}

