/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.persist;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.MetadataException;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.model.ComponentRegistry;
import org.graalvm.component.installer.model.ComponentStorage;

public abstract class AbstractCatalogStorage
implements ComponentStorage {
    protected final ComponentRegistry localRegistry;
    protected final Feedback feedback;
    protected final URL baseURL;

    public AbstractCatalogStorage(ComponentRegistry localRegistry, Feedback feedback, URL baseURL) {
        this.localRegistry = localRegistry;
        this.feedback = feedback;
        this.baseURL = baseURL;
    }

    @Override
    public Map<String, String> loadGraalVersionInfo() {
        return this.localRegistry.getGraalCapabilities();
    }

    @Override
    public ComponentInfo loadComponentFiles(ComponentInfo ci) throws IOException {
        return ci;
    }

    protected byte[] toHashBytes(String comp, String hashS) {
        try {
            return SystemUtils.toHashBytes(hashS);
        }
        catch (IllegalArgumentException ex) {
            throw new MetadataException(null, this.feedback.l10n("REMOTE_InvalidHash", comp, ex.getMessage()));
        }
    }
}

