/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.graalvm.component.installer.SoftwareChannel;
import org.graalvm.component.installer.SoftwareChannelSource;

public class GraalEdition {
    private final String id;
    private final String displayName;
    private List<SoftwareChannelSource> softwareSources = new ArrayList<SoftwareChannelSource>();
    private SoftwareChannel catalogProvider;

    public GraalEdition(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public SoftwareChannel getCatalogProvider() {
        return this.catalogProvider;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setSoftwareSources(List<SoftwareChannelSource> sources) {
        this.softwareSources = sources;
    }

    public void setCatalogProvider(SoftwareChannel catalogProvider) {
        this.catalogProvider = catalogProvider;
    }

    public List<SoftwareChannelSource> getSoftwareSources() {
        return this.softwareSources;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraalEdition other = (GraalEdition)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        if (this.id.equals(this.displayName)) {
            return "Graal " + this.id;
        }
        return "Graal " + this.id + "(" + this.displayName + ")";
    }
}

