/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.component.installer.SystemUtils;
import org.graalvm.component.installer.Version;
import org.graalvm.component.installer.model.ComponentStorage;
import org.graalvm.component.installer.model.DistributionType;
import org.graalvm.component.installer.model.StabilityLevel;

public final class ComponentInfo {
    private final String id;
    private final String versionString;
    private final Version version;
    private final String name;
    private String infoPath;
    private String licensePath;
    private String licenseType;
    private final Map<String, String> requiredGraalValues = new HashMap<String, String>();
    private final List<String> paths = new ArrayList<String>();
    private final Set<String> workingDirectories = new LinkedHashSet<String>();
    private final Map<String, Object> providedValues = new HashMap<String, Object>();
    private URL remoteURL;
    private boolean polyglotRebuild;
    private byte[] shaDigest;
    private String postinstMessage;
    private boolean nativeComponent;
    private String tag = "";
    private Set<String> dependencies = Collections.emptySet();
    private String origin;
    private DistributionType distributionType = DistributionType.OPTIONAL;
    private int priority;
    private StabilityLevel stability = StabilityLevel.Undefined;
    private static final Comparator<ComponentInfo> COMPARATOR_VERSIONS = new Comparator<ComponentInfo>(){

        @Override
        public int compare(ComponentInfo o1, ComponentInfo o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int n = o1.getVersion().compareTo(o2.getVersion());
            if (n == 0) {
                return o1.getPriority() - o2.getPriority();
            }
            return n;
        }
    };

    public ComponentInfo(String id, String name, String versionString, String tag) {
        this.id = id;
        this.versionString = versionString;
        this.name = name;
        this.version = Version.fromString(versionString);
        this.tag = tag;
    }

    public ComponentInfo(String id, String name, String versionString) {
        this(id, name, versionString, "");
    }

    public ComponentInfo(String id, String name, Version v) {
        this.id = id;
        this.versionString = v == null ? null : v.originalString();
        this.name = name;
        this.version = v == null ? Version.NO_VERSION : v;
    }

    public String getId() {
        return this.id;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getName() {
        return this.name;
    }

    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public Map<String, String> getRequiredGraalValues() {
        return Collections.unmodifiableMap(this.requiredGraalValues);
    }

    public void addRequiredValues(Map<String, String> vals) {
        String narch;
        String nos;
        String os = vals.get("os_name");
        String arch = vals.get("os_arch");
        if (os != null && !(nos = SystemUtils.normalizeOSName(os, arch)).equals(os)) {
            vals.put("os_name", nos);
        }
        if (arch != null && !(narch = SystemUtils.normalizeArchitecture(os, arch)).equals(os)) {
            vals.put("os_arch", narch);
        }
        this.requiredGraalValues.putAll(vals);
    }

    public void addRequiredValue(String s, String val) {
        if (val == null) {
            this.requiredGraalValues.remove(s);
        } else {
            String v = val;
            switch (s) {
                case "os_arch": {
                    v = SystemUtils.normalizeArchitecture(null, val);
                    break;
                }
                case "os_name": {
                    v = SystemUtils.normalizeOSName(val, null);
                    break;
                }
            }
            this.requiredGraalValues.put(s, v);
        }
    }

    public void addPaths(List<String> filePaths) {
        this.paths.addAll(filePaths);
    }

    public void setPaths(List<String> filePaths) {
        this.paths.clear();
        this.addPaths(filePaths);
    }

    public List<String> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public String getInfoPath() {
        return this.infoPath;
    }

    public void setInfoPath(String infoPath) {
        this.infoPath = infoPath;
    }

    public String getLicensePath() {
        return this.licensePath;
    }

    public void setLicensePath(String licensePath) {
        this.licensePath = licensePath;
    }

    public URL getRemoteURL() {
        return this.remoteURL;
    }

    public void setRemoteURL(URL remoteURL) {
        this.remoteURL = remoteURL;
    }

    public byte[] getShaDigest() {
        return this.shaDigest;
    }

    public void setShaDigest(byte[] shaDigest) {
        this.shaDigest = shaDigest;
    }

    public boolean isPolyglotRebuild() {
        return this.polyglotRebuild;
    }

    public void setPolyglotRebuild(boolean polyglotRebuild) {
        this.polyglotRebuild = polyglotRebuild;
    }

    public Set<String> getWorkingDirectories() {
        return this.workingDirectories;
    }

    public void addWorkingDirectories(Collection<String> dirs) {
        this.workingDirectories.addAll(dirs);
    }

    public String getPostinstMessage() {
        return this.postinstMessage;
    }

    public void setPostinstMessage(String postinstMessage) {
        this.postinstMessage = postinstMessage;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        hash = 37 * hash + Objects.hashCode(this.version);
        hash = 37 * hash + Objects.hashCode(this.tag);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInfo other = (ComponentInfo)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        return Objects.equals(this.tag, other.tag);
    }

    public Version getVersion() {
        return this.version;
    }

    private static Comparator<ComponentInfo> editionComparator(final String myEdition) {
        return new Comparator<ComponentInfo>(){

            @Override
            public int compare(ComponentInfo o1, ComponentInfo o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                String ed1 = o1.getRequiredGraalValues().get("edition");
                String ed2 = o2.getRequiredGraalValues().get("edition");
                boolean m1 = Objects.equals(ed1, myEdition);
                boolean m2 = Objects.equals(ed2, myEdition);
                if (m1) {
                    return m2 ? 0 : -1;
                }
                if (m2) {
                    return 1;
                }
                if (ed1 == null) {
                    ed1 = "";
                }
                if (ed2 == null) {
                    ed2 = "";
                }
                return ed1.compareToIgnoreCase(ed2);
            }
        };
    }

    public String toString() {
        return this.getId() + "[" + this.getVersion().toString() + (this.tag.isEmpty() ? "" : "/" + this.tag) + "]";
    }

    public static Comparator<ComponentInfo> versionComparator() {
        return COMPARATOR_VERSIONS;
    }

    public static Comparator<ComponentInfo> reverseVersionComparator(ComponentStorage target) {
        String myEdition = target.loadGraalVersionInfo().get("graalvm_version");
        return ComponentInfo.versionComparator().reversed().thenComparing(ComponentInfo.editionComparator(myEdition));
    }

    public static Comparator<ComponentInfo> versionComparator(ComponentStorage target) {
        String myEdition = target.loadGraalVersionInfo().get("graalvm_version");
        return ComponentInfo.versionComparator().thenComparing(ComponentInfo.editionComparator(myEdition));
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean isNativeComponent() {
        return this.nativeComponent;
    }

    public void setNativeComponent(boolean nativeComponent) {
        this.nativeComponent = nativeComponent;
    }

    public <T> void provideValue(String k, T v) {
        this.providedValues.put(k, v);
    }

    public <T> T getProvidedValue(String k, Class<T> type) {
        Object o = this.providedValues.get(k);
        if (!type.isInstance(o)) {
            if (type != String.class || o == null) {
                return null;
            }
            o = o.toString();
        }
        Object ret = o;
        return (T)ret;
    }

    public Map<String, Object> getProvidedValues() {
        return Collections.unmodifiableMap(this.providedValues);
    }

    public void addProvidedValues(Map<String, Object> vals) {
        for (String s : vals.keySet()) {
            this.provideValue(s, vals.get(s));
        }
    }

    public void setDependencies(Set<String> deps) {
        this.dependencies = deps;
    }

    public Set<String> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public boolean isInstalled() {
        return this.infoPath != null;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public StabilityLevel getStability() {
        return this.stability;
    }

    public void setStability(StabilityLevel stab) {
        this.stability = stab == null ? StabilityLevel.Undefined : stab;
    }
}

