/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerCommand;
import org.graalvm.component.installer.SystemUtils;

public class RebuildImageCommand
implements InstallerCommand {
    private static final Map<String, String> OPTIONS = new HashMap<String, String>();
    private Feedback feedback;
    private CommandInput input;

    @Override
    public Map<String, String> supportedOptions() {
        return OPTIONS;
    }

    @Override
    public void init(CommandInput commandInput, Feedback feedBack) {
        this.feedback = feedBack;
        this.input = commandInput;
    }

    @Override
    public int execute() throws IOException {
        this.input.getLocalRegistry().verifyAdministratorAccess();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<String> commandLine = new ArrayList<String>();
        Path toolPath = RebuildImageCommand.findNativeImagePath(this.input, this.feedback);
        if (toolPath == null) {
            this.feedback.error("REBUILD_RebuildImagesNotInstalled", null, "native-image");
            return 2;
        }
        String procName = toolPath.toAbsolutePath().toString();
        commandLine.add(procName);
        if (this.input.optValue("v") != null) {
            commandLine.add("--verbose");
        }
        while (this.input.hasParameter()) {
            commandLine.add(this.input.nextParameter());
        }
        pb.command(commandLine);
        pb.directory(this.input.getGraalHomePath().toFile());
        pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        ExecutorService connectors = Executors.newCachedThreadPool();
        try {
            Process p = pb.start();
            OutputRewriter rw = new OutputRewriter(p.getInputStream(), procName, this.feedback.l10n("REBUILD_RewriteRebuildToolName", new Object[0]));
            Future<?> ioWriter = connectors.submit(rw);
            int exitCode = p.waitFor();
            ioWriter.get(1000L, TimeUnit.MILLISECONDS);
            if (rw.terminated != null) {
                this.feedback.error("REBUILD_ImageToolInterrupted", rw.terminated, new Object[0]);
            }
            return exitCode;
        }
        catch (ExecutionException ex) {
            this.feedback.error("REBUILD_ErrorCommunicatingImageTool", ex, ex.getLocalizedMessage());
            return 3;
        }
        catch (InterruptedException | TimeoutException ex) {
            this.feedback.error("REBUILD_ImageToolInterrupted", ex, new Object[0]);
            return 1;
        }
    }

    public static Path findNativeImagePath(CommandInput input, Feedback feedback) {
        Path p;
        Path baseDir = SystemUtils.getRuntimeBaseDir(input.getGraalHomePath());
        String toolRelativePath = feedback.l10n("REBUILD_ToolRelativePath", new Object[0]);
        if (SystemUtils.isWindows()) {
            toolRelativePath = toolRelativePath + ".cmd";
        }
        return Files.isReadable(p = baseDir.resolve(SystemUtils.fromCommonString(toolRelativePath))) || Files.isExecutable(p) ? p : null;
    }

    static {
        OPTIONS.put("*", "");
    }

    final class OutputRewriter
    implements Runnable {
        private final String processName;
        private final String substProcessName;
        private final InputStream output;
        private volatile IOException terminated;

        OutputRewriter(InputStream output, String processName, String substProcessName) {
            this.output = output;
            this.processName = processName;
            this.substProcessName = substProcessName;
        }

        @Override
        public void run() {
            try (BufferedReader bre = new BufferedReader(new InputStreamReader(this.output));){
                String line;
                while ((line = bre.readLine()) != null) {
                    int i = line.indexOf(this.processName);
                    if (i != -1) {
                        line = line.substring(0, i) + this.substProcessName + line.substring(i + this.processName.length());
                    }
                    RebuildImageCommand.this.feedback.verbatimOut(line, false);
                }
            }
            catch (IOException ex) {
                this.terminated = ex;
            }
        }
    }
}

