/*********************************************************************
* Software License Agreement (BSD License)
*
*  Copyright (c) 2010, Rice University
*  All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*   * Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*   * Redistributions in binary form must reproduce the above
*     copyright notice, this list of conditions and the following
*     disclaimer in the documentation and/or other materials provided
*     with the distribution.
*   * Neither the name of the Rice University nor the names of its
*     contributors may be used to endorse or promote products derived
*     from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
*  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
*  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
*  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
*  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
*  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
*  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
*  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
*  POSSIBILITY OF SUCH DAMAGE.
*********************************************************************/

/* Author: Ioan Sucan */

#ifndef OMPL_BASE_GOALS_GOAL_SAMPLEABLE_REGION_
#define OMPL_BASE_GOALS_GOAL_SAMPLEABLE_REGION_

#include "ompl/base/goals/GoalRegion.h"

namespace ompl
{
    namespace base
    {
        /** \brief Abstract definition of a goal region that can be sampled */
        class GoalSampleableRegion : public GoalRegion
        {
        public:
            /** \brief Create a goal region that can be sampled */
            GoalSampleableRegion(const SpaceInformationPtr &si) : GoalRegion(si)
            {
                type_ = GOAL_SAMPLEABLE_REGION;
            }

            ~GoalSampleableRegion() override = default;

            /** \brief Sample a state in the goal region */
            virtual void sampleGoal(State *st) const = 0;

            /** \brief Return the maximum number of samples that can be asked for before repeating */
            virtual unsigned int maxSampleCount() const = 0;

            /** \brief Return true if maxSampleCount() > 0, since in this case samples can certainly be produced */
            bool canSample() const
            {
                return maxSampleCount() > 0;
            }

            /** \brief Return true if samples could be generated by this sampler at some point in the future. By default
             this is equivalent to canSample(),
             but for GoalLazySamples, this call also reflects the fact that a sampling thread is active and although no
             samples are produced yet, some may
             become available at some point in the future. */
            virtual bool couldSample() const
            {
                return canSample();
            }
        };
    }
}

#endif
