// This file has been generated by Py++.

#include "boost/python.hpp"
#include "bindings/control.h"
#include "GridDecomposition.pypp.hpp"

namespace bp = boost::python;

struct GridDecomposition_wrapper : ompl::control::GridDecomposition, bp::wrapper< ompl::control::GridDecomposition > {

    GridDecomposition_wrapper(int len, int dim, ::ompl::base::RealVectorBounds const & b )
    : ompl::control::GridDecomposition( len, dim, boost::ref(b) )
      , bp::wrapper< ompl::control::GridDecomposition >(){
        // constructor
    
    }

    void computeGridNeighbors( int rid, ::std::vector< int > & neighbors ) const {
        ompl::control::GridDecomposition::computeGridNeighbors( rid, boost::ref(neighbors) );
    }

    void computeGridNeighborsSub( ::std::vector< int > const & coord, ::std::vector< int > & neighbors, int dim, ::std::vector< int > & candidate ) const {
        ompl::control::GridDecomposition::computeGridNeighborsSub( boost::ref(coord), boost::ref(neighbors), dim, boost::ref(candidate) );
    }

    void coordToGridCoord( ::std::vector< double > const & coord, ::std::vector< int > & gridCoord ) const {
        ompl::control::GridDecomposition::coordToGridCoord( boost::ref(coord), boost::ref(gridCoord) );
    }

    int coordToRegion( ::std::vector< double > const & coord ) const {
        return ompl::control::GridDecomposition::coordToRegion( boost::ref(coord) );
    }

    virtual void getNeighbors( int rid, ::std::vector< int > & neighbors ) const  {
        if( bp::override func_getNeighbors = this->get_override( "getNeighbors" ) )
            func_getNeighbors( rid, boost::ref(neighbors) );
        else{
            this->ompl::control::GridDecomposition::getNeighbors( rid, boost::ref(neighbors) );
        }
    }
    
    void default_getNeighbors( int rid, ::std::vector< int > & neighbors ) const  {
        ompl::control::GridDecomposition::getNeighbors( rid, boost::ref(neighbors) );
    }

    virtual int getNumRegions(  ) const  {
        if( bp::override func_getNumRegions = this->get_override( "getNumRegions" ) )
            return func_getNumRegions(  );
        else{
            return this->ompl::control::GridDecomposition::getNumRegions(  );
        }
    }
    
    int default_getNumRegions(  ) const  {
        return ompl::control::GridDecomposition::getNumRegions( );
    }

    virtual double getRegionVolume( int arg0 ) {
        if( bp::override func_getRegionVolume = this->get_override( "getRegionVolume" ) )
            return func_getRegionVolume( arg0 );
        else{
            return this->ompl::control::GridDecomposition::getRegionVolume( arg0 );
        }
    }
    
    double default_getRegionVolume( int arg0 ) {
        return ompl::control::GridDecomposition::getRegionVolume( arg0 );
    }

    int gridCoordToRegion( ::std::vector< int > const & coord ) const {
        return ompl::control::GridDecomposition::gridCoordToRegion( boost::ref(coord) );
    }

    virtual int locateRegion( ::ompl::base::State const * s ) const  {
        if( bp::override func_locateRegion = this->get_override( "locateRegion" ) )
            return func_locateRegion( boost::python::ptr(s) );
        else{
            return this->ompl::control::GridDecomposition::locateRegion( boost::python::ptr(s) );
        }
    }
    
    int default_locateRegion( ::ompl::base::State const * s ) const  {
        return ompl::control::GridDecomposition::locateRegion( boost::python::ptr(s) );
    }

    void regionToGridCoord( int rid, ::std::vector< int > & coord ) const {
        ompl::control::GridDecomposition::regionToGridCoord( rid, boost::ref(coord) );
    }

    virtual void sampleFromRegion( int rid, ::ompl::RNG & rng, ::std::vector< double > & coord ) const  {
        if( bp::override func_sampleFromRegion = this->get_override( "sampleFromRegion" ) )
            func_sampleFromRegion( rid, boost::ref(rng), boost::ref(coord) );
        else{
            this->ompl::control::GridDecomposition::sampleFromRegion( rid, boost::ref(rng), boost::ref(coord) );
        }
    }
    
    void default_sampleFromRegion( int rid, ::ompl::RNG & rng, ::std::vector< double > & coord ) const  {
        ompl::control::GridDecomposition::sampleFromRegion( rid, boost::ref(rng), boost::ref(coord) );
    }

    virtual int getDimension(  ) const  {
        if( bp::override func_getDimension = this->get_override( "getDimension" ) )
            return func_getDimension(  );
        else{
            return this->ompl::control::Decomposition::getDimension(  );
        }
    }
    
    int default_getDimension(  ) const  {
        return ompl::control::Decomposition::getDimension( );
    }

    virtual void project( ::ompl::base::State const * s, ::std::vector< double > & coord ) const {
        bp::override func_project = this->get_override( "project" );
        func_project( boost::python::ptr(s), boost::ref(coord) );
    }

    virtual void sampleFullState( ::ompl::base::StateSamplerPtr const & sampler, ::std::vector< double > const & coord, ::ompl::base::State * s ) const {
        bp::override func_sampleFullState = this->get_override( "sampleFullState" );
        func_sampleFullState( sampler, boost::ref(coord), boost::python::ptr(s) );
    }

};

void register_GridDecomposition_class(){

    { //::ompl::control::GridDecomposition
        typedef bp::class_< GridDecomposition_wrapper, bp::bases< ompl::control::Decomposition >, boost::noncopyable > GridDecomposition_exposer_t;
        GridDecomposition_exposer_t GridDecomposition_exposer = GridDecomposition_exposer_t( "GridDecomposition", bp::init< int, int, ompl::base::RealVectorBounds const & >(( bp::arg("len"), bp::arg("dim"), bp::arg("b") )) );
        bp::scope GridDecomposition_scope( GridDecomposition_exposer );
        { //::ompl::control::GridDecomposition::computeGridNeighbors
        
            typedef void ( GridDecomposition_wrapper::*computeGridNeighbors_function_type )( int,::std::vector< int > & ) const;
            
            GridDecomposition_exposer.def( 
                "computeGridNeighbors"
                , computeGridNeighbors_function_type( &GridDecomposition_wrapper::computeGridNeighbors )
                , ( bp::arg("rid"), bp::arg("neighbors") ) );
        
        }
        { //::ompl::control::GridDecomposition::computeGridNeighborsSub
        
            typedef void ( GridDecomposition_wrapper::*computeGridNeighborsSub_function_type )( ::std::vector< int > const &,::std::vector< int > &,int,::std::vector< int > & ) const;
            
            GridDecomposition_exposer.def( 
                "computeGridNeighborsSub"
                , computeGridNeighborsSub_function_type( &GridDecomposition_wrapper::computeGridNeighborsSub )
                , ( bp::arg("coord"), bp::arg("neighbors"), bp::arg("dim"), bp::arg("candidate") ) );
        
        }
        { //::ompl::control::GridDecomposition::coordToGridCoord
        
            typedef void ( GridDecomposition_wrapper::*coordToGridCoord_function_type )( ::std::vector< double > const &,::std::vector< int > & ) const;
            
            GridDecomposition_exposer.def( 
                "coordToGridCoord"
                , coordToGridCoord_function_type( &GridDecomposition_wrapper::coordToGridCoord )
                , ( bp::arg("coord"), bp::arg("gridCoord") ) );
        
        }
        { //::ompl::control::GridDecomposition::coordToRegion
        
            typedef int ( GridDecomposition_wrapper::*coordToRegion_function_type )( ::std::vector< double > const & ) const;
            
            GridDecomposition_exposer.def( 
                "coordToRegion"
                , coordToRegion_function_type( &GridDecomposition_wrapper::coordToRegion )
                , ( bp::arg("coord") ) );
        
        }
        { //::ompl::control::GridDecomposition::getNeighbors
        
            typedef void ( ::ompl::control::GridDecomposition::*getNeighbors_function_type )( int,::std::vector< int > & ) const;
            typedef void ( GridDecomposition_wrapper::*default_getNeighbors_function_type )( int,::std::vector< int > & ) const;
            
            GridDecomposition_exposer.def( 
                "getNeighbors"
                , getNeighbors_function_type(&::ompl::control::GridDecomposition::getNeighbors)
                , default_getNeighbors_function_type(&GridDecomposition_wrapper::default_getNeighbors)
                , ( bp::arg("rid"), bp::arg("neighbors") ) );
        
        }
        { //::ompl::control::GridDecomposition::getNumRegions
        
            typedef int ( ::ompl::control::GridDecomposition::*getNumRegions_function_type )(  ) const;
            typedef int ( GridDecomposition_wrapper::*default_getNumRegions_function_type )(  ) const;
            
            GridDecomposition_exposer.def( 
                "getNumRegions"
                , getNumRegions_function_type(&::ompl::control::GridDecomposition::getNumRegions)
                , default_getNumRegions_function_type(&GridDecomposition_wrapper::default_getNumRegions) );
        
        }
        { //::ompl::control::GridDecomposition::getRegionVolume
        
            typedef double ( ::ompl::control::GridDecomposition::*getRegionVolume_function_type )( int ) ;
            typedef double ( GridDecomposition_wrapper::*default_getRegionVolume_function_type )( int ) ;
            
            GridDecomposition_exposer.def( 
                "getRegionVolume"
                , getRegionVolume_function_type(&::ompl::control::GridDecomposition::getRegionVolume)
                , default_getRegionVolume_function_type(&GridDecomposition_wrapper::default_getRegionVolume)
                , ( bp::arg("arg0") ) );
        
        }
        { //::ompl::control::GridDecomposition::gridCoordToRegion
        
            typedef int ( GridDecomposition_wrapper::*gridCoordToRegion_function_type )( ::std::vector< int > const & ) const;
            
            GridDecomposition_exposer.def( 
                "gridCoordToRegion"
                , gridCoordToRegion_function_type( &GridDecomposition_wrapper::gridCoordToRegion )
                , ( bp::arg("coord") ) );
        
        }
        { //::ompl::control::GridDecomposition::locateRegion
        
            typedef int ( ::ompl::control::GridDecomposition::*locateRegion_function_type )( ::ompl::base::State const * ) const;
            typedef int ( GridDecomposition_wrapper::*default_locateRegion_function_type )( ::ompl::base::State const * ) const;
            
            GridDecomposition_exposer.def( 
                "locateRegion"
                , locateRegion_function_type(&::ompl::control::GridDecomposition::locateRegion)
                , default_locateRegion_function_type(&GridDecomposition_wrapper::default_locateRegion)
                , ( bp::arg("s") ) );
        
        }
        { //::ompl::control::GridDecomposition::regionToGridCoord
        
            typedef void ( GridDecomposition_wrapper::*regionToGridCoord_function_type )( int,::std::vector< int > & ) const;
            
            GridDecomposition_exposer.def( 
                "regionToGridCoord"
                , regionToGridCoord_function_type( &GridDecomposition_wrapper::regionToGridCoord )
                , ( bp::arg("rid"), bp::arg("coord") ) );
        
        }
        { //::ompl::control::GridDecomposition::sampleFromRegion
        
            typedef void ( ::ompl::control::GridDecomposition::*sampleFromRegion_function_type )( int,::ompl::RNG &,::std::vector< double > & ) const;
            typedef void ( GridDecomposition_wrapper::*default_sampleFromRegion_function_type )( int,::ompl::RNG &,::std::vector< double > & ) const;
            
            GridDecomposition_exposer.def( 
                "sampleFromRegion"
                , sampleFromRegion_function_type(&::ompl::control::GridDecomposition::sampleFromRegion)
                , default_sampleFromRegion_function_type(&GridDecomposition_wrapper::default_sampleFromRegion)
                , ( bp::arg("rid"), bp::arg("rng"), bp::arg("coord") ) );
        
        }
        { //::ompl::control::Decomposition::getBounds
        
            typedef ::ompl::base::RealVectorBounds const & ( ::ompl::control::Decomposition::*getBounds_function_type )(  ) const;
            
            GridDecomposition_exposer.def( 
                "getBounds"
                , getBounds_function_type(&::ompl::control::Decomposition::getBounds)
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::control::Decomposition::getDimension
        
            typedef int ( ::ompl::control::Decomposition::*getDimension_function_type )(  ) const;
            typedef int ( GridDecomposition_wrapper::*default_getDimension_function_type )(  ) const;
            
            GridDecomposition_exposer.def( 
                "getDimension"
                , getDimension_function_type(&::ompl::control::Decomposition::getDimension)
                , default_getDimension_function_type(&GridDecomposition_wrapper::default_getDimension) );
        
        }
        { //::ompl::control::Decomposition::project
        
            typedef void ( ::ompl::control::Decomposition::*project_function_type )( ::ompl::base::State const *,::std::vector<double, std::allocator<double> > & ) const;
            
            GridDecomposition_exposer.def( 
                "project"
                , bp::pure_virtual( project_function_type(&::ompl::control::Decomposition::project) )
                , ( bp::arg("s"), bp::arg("coord") ) );
        
        }
        { //::ompl::control::Decomposition::sampleFullState
        
            typedef void ( ::ompl::control::Decomposition::*sampleFullState_function_type )( ::ompl::base::StateSamplerPtr const &,::std::vector<double, std::allocator<double> > const &,::ompl::base::State * ) const;
            
            GridDecomposition_exposer.def( 
                "sampleFullState"
                , bp::pure_virtual( sampleFullState_function_type(&::ompl::control::Decomposition::sampleFullState) )
                , ( bp::arg("sampler"), bp::arg("coord"), bp::arg("s") ) );
        
        }
    }

}
