![Build/release](https://github.com/TorstenDittmann/OmniaWrite/workflows/Build/release/badge.svg)
[![omniawrite](https://snapcraft.io//omniawrite/badge.svg)](https://snapcraft.io/omniawrite)

<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://omniawrite.com">
    <img src="public/android-chrome-512x512.png" alt="Logo" width="80" height="80">
  </a>

  <h3 align="center">OmniaWrite</h3>

  <p align="center">
    A text editor engineered for creative writing.
    <br />
    <a href="https://omniawrite.com"><strong>Visit homepage »</strong></a>
    <br />
    <br />
    <a href="https://app.omniawrite.com">View WebApp</a>
    ·
    <a href="https://github.com/TorstenDittmann/OmniaWrite/issues">Report Bug</a>
    ·
    <a href="https://github.com/TorstenDittmann/OmniaWrite/issues">Request Feature</a>
  </p>
</p>

<!-- TABLE OF CONTENTS -->
## Table of Contents

* [About the Project](#about-omniawrite)
  * [Built With](#built-with)
* [Contributing](#contributing)
* [License](#license)
* [Contact](#contact)

<!-- ABOUT OMNIAWRITE -->

## About OmniaWrite

OmniaWrite is a next-generation plain text editor engineered for creative writing. It is perfect for writing novels, lyrics, poems, essays, drafts and screenplays.

Writing a good story is one of the most challenging things in life. But for many it is a dream worth pursuing.

OmniaWrite doesn't help you create a novel out of nothing, but is a faithful companion at every step of your projects. Organisation, environment for concentrated work, export to all common file formats and much more.

#### Full Featured Text Editor
Everything you need. Nothing you don’t.

#### Chapters and Scenes
Write in chapters and scenes to give your text more structure and add manageability. You can move and rearrange scenes at will without having to break your structure.

#### Anywhere
OmniaWrite will support Windows, Linux, macOS, Android, iOS and can also run in any modern browser.

### Built With
This section should list any major frameworks that you built your project using. Leave any add-ons/plugins for the acknowledgements section. Here are a few examples.
* [svelte](https://svelte.dev)
* [Appwrite](https://appwrite.io)
* [Electron](https://www.electronjs.org)
* [Cordova](https://cordova.apache.org)

<!-- CONTRIBUTING -->
## Contributing

Any contributions you make are **greatly appreciated**.

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

## Releasing

When you want to create a new release, follow these steps:

1. Update the version in `package.json` file (e.g. `1.2.3`)
2. Commit that change (`git commit -am v1.2.3`)
3. Tag commit (`git tag v1.2.3`). Make sure the tag name's format is `v*.*.*`.
4. Push changes to GitHub (`git push && git push --tags`)

After building successfully, the action will publish your release artifacts.

<!-- LICENSE -->
## License

<a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://i.creativecommons.org/l/by-nc/4.0/88x31.png" /></a><br />This work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-nc/4.0/">Creative Commons Attribution-NonCommercial 4.0 International License</a>.



<!-- CONTACT -->
## Contact

OmniaWrite - [@OmniaWrite](https://twitter.com/OmniaWrite) - info@omniawrite.com

Project Link: [https://OmniaWrite.com](https://OmniaWrite.com)
Project GitHub Link: [https://github.com/TorstenDittmann/OmniaWrite](https://github.com/TorstenDittmann/OmniaWrite)
