from asdl import pybase
from mycpp import mops
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING


from asdl import runtime  # For runtime.NO_SPID
from asdl.runtime import NewRecord, NewLeaf, TraversalState
from _devbuild.gen.hnode_asdl import color_e, hnode, hnode_e, hnode_t, Field

class bool_arg_type_t(pybase.SimpleObj):
  pass

class bool_arg_type_e(object):
  Undefined = bool_arg_type_t(1)
  Path = bool_arg_type_t(2)
  Int = bool_arg_type_t(3)
  Str = bool_arg_type_t(4)
  Other = bool_arg_type_t(5)

_bool_arg_type_str = {
  1: 'bool_arg_type.Undefined',
  2: 'bool_arg_type.Path',
  3: 'bool_arg_type.Int',
  4: 'bool_arg_type.Str',
  5: 'bool_arg_type.Other',
}

def bool_arg_type_str(val):
  # type: (bool_arg_type_t) -> str
  return _bool_arg_type_str[val]

class redir_arg_type_t(pybase.SimpleObj):
  pass

class redir_arg_type_e(object):
  Path = redir_arg_type_t(1)
  Desc = redir_arg_type_t(2)
  Here = redir_arg_type_t(3)

_redir_arg_type_str = {
  1: 'redir_arg_type.Path',
  2: 'redir_arg_type.Desc',
  3: 'redir_arg_type.Here',
}

def redir_arg_type_str(val):
  # type: (redir_arg_type_t) -> str
  return _redir_arg_type_str[val]

opt_group_t = int  # type alias for integer

class opt_group_i(object):
  StrictAll = 1
  YshUpgrade = 2
  YshAll = 3
  ARRAY_SIZE = 4

_opt_group_str = {
  1: 'opt_group.StrictAll',
  2: 'opt_group.YshUpgrade',
  3: 'opt_group.YshAll',
}

def opt_group_str(val):
  # type: (opt_group_t) -> str
  return _opt_group_str[val]

class lex_mode_t(pybase.SimpleObj):
  pass

class lex_mode_e(object):
  Undefined = lex_mode_t(1)
  Comment = lex_mode_t(2)
  ShCommand = lex_mode_t(3)
  ShCommandFakeBrack = lex_mode_t(4)
  Backtick = lex_mode_t(5)
  DBracket = lex_mode_t(6)
  SQ_Raw = lex_mode_t(7)
  DQ = lex_mode_t(8)
  SQ_C = lex_mode_t(9)
  J8_Str = lex_mode_t(10)
  Arith = lex_mode_t(11)
  ExtGlob = lex_mode_t(12)
  VSub_1 = lex_mode_t(13)
  VSub_2 = lex_mode_t(14)
  VSub_ArgUnquoted = lex_mode_t(15)
  VSub_ArgDQ = lex_mode_t(16)
  VSub_Zsh = lex_mode_t(17)
  BashRegex = lex_mode_t(18)
  BashRegexFakeInner = lex_mode_t(19)
  FuncParens = lex_mode_t(20)
  PrintfOuter = lex_mode_t(21)
  PrintfPercent = lex_mode_t(22)
  Expr = lex_mode_t(23)

_lex_mode_str = {
  1: 'lex_mode.Undefined',
  2: 'lex_mode.Comment',
  3: 'lex_mode.ShCommand',
  4: 'lex_mode.ShCommandFakeBrack',
  5: 'lex_mode.Backtick',
  6: 'lex_mode.DBracket',
  7: 'lex_mode.SQ_Raw',
  8: 'lex_mode.DQ',
  9: 'lex_mode.SQ_C',
  10: 'lex_mode.J8_Str',
  11: 'lex_mode.Arith',
  12: 'lex_mode.ExtGlob',
  13: 'lex_mode.VSub_1',
  14: 'lex_mode.VSub_2',
  15: 'lex_mode.VSub_ArgUnquoted',
  16: 'lex_mode.VSub_ArgDQ',
  17: 'lex_mode.VSub_Zsh',
  18: 'lex_mode.BashRegex',
  19: 'lex_mode.BashRegexFakeInner',
  20: 'lex_mode.FuncParens',
  21: 'lex_mode.PrintfOuter',
  22: 'lex_mode.PrintfPercent',
  23: 'lex_mode.Expr',
}

def lex_mode_str(val):
  # type: (lex_mode_t) -> str
  return _lex_mode_str[val]

class word_mode_t(pybase.SimpleObj):
  pass

class word_mode_e(object):
  ShCommand = word_mode_t(1)
  ShCommandBrack = word_mode_t(2)
  DBracket = word_mode_t(3)
  BashRegex = word_mode_t(4)

_word_mode_str = {
  1: 'word_mode.ShCommand',
  2: 'word_mode.ShCommandBrack',
  3: 'word_mode.DBracket',
  4: 'word_mode.BashRegex',
}

def word_mode_str(val):
  # type: (word_mode_t) -> str
  return _word_mode_str[val]

class cmd_mode_t(pybase.SimpleObj):
  pass

class cmd_mode_e(object):
  Shell = cmd_mode_t(1)
  Func = cmd_mode_t(2)
  Proc = cmd_mode_t(3)

_cmd_mode_str = {
  1: 'cmd_mode.Shell',
  2: 'cmd_mode.Func',
  3: 'cmd_mode.Proc',
}

def cmd_mode_str(val):
  # type: (cmd_mode_t) -> str
  return _cmd_mode_str[val]

