from asdl import pybase
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING

class color_t(pybase.SimpleObj):
  pass

class color_e(object):
  TypeName = color_t(1)
  StringConst = color_t(2)
  OtherConst = color_t(3)
  UserType = color_t(4)
  External = color_t(5)

_color_str = {
  1: 'color.TypeName',
  2: 'color.StringConst',
  3: 'color.OtherConst',
  4: 'color.UserType',
  5: 'color.External',
}

def color_str(val):
  # type: (color_t) -> str
  return _color_str[val]

class hnode_e(object):
  ObjectCycle = 1
  Record = 2
  Array = 3
  Leaf = 4
  External = 5

_hnode_str = {
  1: 'ObjectCycle',
  2: 'Record',
  3: 'Array',
  4: 'Leaf',
  5: 'External',
}

def hnode_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _hnode_str[tag]
  if dot:
    return "hnode.%s" % v
  else:
    return v

class hnode_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class hnode(object):
  class ObjectCycle(hnode_t):
    _type_tag = 1
    __slots__ = ('heap_id',)
  
    def __init__(self, heap_id):
      # type: (int) -> None
      self.heap_id = heap_id
  
  class Record(hnode_t):
    _type_tag = 2
    __slots__ = ('node_type', 'fields', 'abbrev', 'left', 'right',
                 'unnamed_fields')
  
    def __init__(self, node_type, fields, abbrev, left, right, unnamed_fields):
      # type: (str, List[Field], bool, str, str, List[hnode_t]) -> None
      self.node_type = node_type
      self.fields = fields
      self.abbrev = abbrev
      self.left = left
      self.right = right
      self.unnamed_fields = unnamed_fields
  
  class Array(hnode_t):
    _type_tag = 3
    __slots__ = ('children',)
  
    def __init__(self, children):
      # type: (List[hnode_t]) -> None
      self.children = children
  
  class Leaf(hnode_t):
    _type_tag = 4
    __slots__ = ('s', 'color')
  
    def __init__(self, s, color):
      # type: (str, color_t) -> None
      self.s = s
      self.color = color
  
  class External(hnode_t):
    _type_tag = 5
    __slots__ = ('obj',)
  
    def __init__(self, obj):
      # type: (Any) -> None
      self.obj = obj
  
  pass

class alloc_members_t(pybase.SimpleObj):
  pass

class alloc_members_e(object):
  List = alloc_members_t(1)
  Dict = alloc_members_t(2)
  Struct = alloc_members_t(3)

_alloc_members_str = {
  1: 'alloc_members.List',
  2: 'alloc_members.Dict',
  3: 'alloc_members.Struct',
}

def alloc_members_str(val):
  # type: (alloc_members_t) -> str
  return _alloc_members_str[val]

class Field(pybase.CompoundObj):
  _type_tag = 64
  __slots__ = ('name', 'val')

  def __init__(self, name, val):
    # type: (str, hnode_t) -> None
    self.name = name
    self.val = val

