# Copyright (C) 2017 Olaf Till <i7tiol@t-online.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.

# arguments of OF_OCTAVE_ALT_SYMS (see also description of
# OF_OCTAVE_LIST_ALT_SYMS below):
#
# $1: symbol version 1
# $2: symbol version 2
# $3: test for symbol version 2
# $4: macro name to access alternative symbols
# $5: include directives for symbol version 1
# $6: include directives for symbol version 2
# (a list of lists of args 1--6 is $1 of OF_OCTAVE_LIST_ALT_SYMS)
# $7: name of generated include file with alternatives of Octave headers
# (arg7 is $2 of OF_OCTAVE_LIST_ALT_SYMS)
AC_DEFUN([OF_OCTAVE_ALT_SYMS], [
  AC_COMPILE_IFELSE(
    [AC_LANG_PROGRAM([[#include <octave/oct.h>]
                      $6],
                     [$3])],
    [AC_DEFINE($4,
               [[$2]],
               [macro for alternative Octave symbols])
     echo '$6' >> $7],
    [AC_DEFINE($4,
               [[$1]],
               [macro for alternative Octave symbols])
     echo '$5' >> $7]
)
])


# OF_OCTAVE_LIST_ALT_SYMS is called in the following way:
#
# OF_OCTAVE_LIST_ALT_SYMS([
# [dnl
#   [old_octave_symbol],
#   [new_octave_symbol],
#   [[compilation test]
#    [for new_octave_symbol]],
#   [NAME_OF_GENERATED_MACRO____WILL_EXPAND_TO_OLD_OR_NEW_SYMBOL],
#   [[include directives]
#    [except #include <octave/oct.h>]
#    [necessary to compile with old_octave_symbol]],
#   [[include directives]
#    [except #include <octave/oct.h>]
#    [nessary to compile with new_octave_symbol]
#    [and to compile the test]]
# ],
#
# ... further such lists as the above
#
# ],
#
# [name-of-header-file-for-alternative-octave-iclude-directives.h])
#
#
# This file should be put into src/m4/, and the line
#
# AC_CONFIG_MACRO_DIRS([m4])
#
# should be put into src/configure.ac. The package should use
# autoheader to generate config.h.in (src/bootstrap should contain the
# lines 'aclocal', 'autoconf', and 'autoheader -f'). Package code
# should include config.h and use the generated macros to access the
# alternative symbols of Octave. An example of a call to
# OF_OCTAVE_LIST_ALT_SYMS in src/configure.ac is available together
# with this file.
AC_DEFUN([OF_OCTAVE_LIST_ALT_SYMS], [

echo '/* generated by configure */' > $2

m4_foreach([it], [$1], [m4_apply([OF_OCTAVE_ALT_SYMS], [it, $2])])

AH_BOTTOM([#include "$2"])

])
