function GetOciTopLevelCommand_log_analytics() {
    return 'log-analytics'
}

function GetOciSubcommands_log_analytics() {
    $ociSubcommands = @{
        'log-analytics' = 'assoc char-encoding-collection config-work-request content-export content-import em-bridge entity entity-type field label log-group lookup namespace object-collection-rule parser query query-work-request scheduled-task source storage timezone-collection upload warning work-request work-request-error work-request-log'
        'log-analytics assoc' = 'delete-assocs get-assoc-summary list-associated-entities list-entity-source-assocs list-source-assocs upsert-assocs validate-assoc-params'
        'log-analytics char-encoding-collection' = 'list-supported-encodings'
        'log-analytics config-work-request' = 'get-config-work-request list-config-work-requests'
        'log-analytics content-export' = 'export-custom-content'
        'log-analytics content-import' = 'import-custom-content'
        'log-analytics em-bridge' = 'change-compartment create delete get list summary update'
        'log-analytics entity' = 'add-associations change-compartment create delete get list list-associations remove-associations summary update'
        'log-analytics entity-type' = 'create delete get list update'
        'log-analytics field' = 'delete-field get-field get-fields-summary list-fields upsert-field'
        'log-analytics label' = 'batch-get-basic-info delete-label get-label get-label-summary list-label-priorities list-label-source-details list-labels upsert-label'
        'log-analytics log-group' = 'change-compartment create delete get get-log-analytics-log-groups-summary list update'
        'log-analytics lookup' = 'append-data delete get get-summary list register-lookup update update-data'
        'log-analytics namespace' = 'get list offboard onboard'
        'log-analytics object-collection-rule' = 'change-compartment create delete get list update'
        'log-analytics parser' = 'delete-parser extract-structured-log-field-paths extract-structured-log-header-paths get-parser get-parser-summary list-parser-functions list-parser-meta-plugins list-parsers test-parser upsert-parser'
        'log-analytics query' = 'export filter get-query-result parse search suggest'
        'log-analytics query-work-request' = 'background cancel get list'
        'log-analytics scheduled-task' = 'change-compartment clean create-acceleration-task create-standard-task delete get list pause resume run update'
        'log-analytics source' = 'add-event-types delete-source disable-auto-assoc disable-event-types enable-auto-assoc enable-event-types get-column-names get-source get-source-summary list-associable-entities list-auto-assocs list-event-types list-meta-source-types list-source-extfield-defs list-source-functions list-source-label-operators list-source-patterns list-sources remove-event-types upsert-source validate-source validate-source-extfield-details'
        'log-analytics storage' = 'disable-archiving enable-archiving estimate-purge-data-size estimate-recall-data-size estimate-release-data-size get get-storage-usage get-storage-work-request list-log-sets list-recalled-data list-storage-work-request-errors list-storage-work-requests purge-storage-data recall-archived-data release-recalled-data update'
        'log-analytics timezone-collection' = 'list-supported-timezones'
        'log-analytics upload' = 'delete delete-upload-file delete-upload-warning get list list-upload-files list-upload-warnings upload-log-events-file upload-log-file validate-file validate-source-mapping'
        'log-analytics warning' = 'list suppress unsuppress'
        'log-analytics work-request' = 'get list'
        'log-analytics work-request-error' = 'list'
        'log-analytics work-request-log' = 'list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_log_analytics() {
    $ociCommandsToLongParams = @{
        'log-analytics assoc delete-assocs' = 'compartment-id from-json help items max-wait-seconds namespace-name wait-for-state wait-interval-seconds'
        'log-analytics assoc get-assoc-summary' = 'compartment-id from-json help namespace-name'
        'log-analytics assoc list-associated-entities' = 'all compartment-id entity-id entity-type entity-type-name from-json help limit namespace-name page page-size sort-by sort-order'
        'log-analytics assoc list-entity-source-assocs' = 'all compartment-id entity-id entity-type entity-type-name from-json help is-show-total life-cycle-state limit namespace-name page page-size sort-by sort-order'
        'log-analytics assoc list-source-assocs' = 'all compartment-id entity-id from-json help is-show-total life-cycle-state limit namespace-name page page-size sort-by sort-order source-name'
        'log-analytics assoc upsert-assocs' = 'compartment-id from-json help is-from-republish items max-wait-seconds namespace-name wait-for-state wait-interval-seconds'
        'log-analytics assoc validate-assoc-params' = 'compartment-id from-json help items limit namespace-name page sort-by sort-order'
        'log-analytics char-encoding-collection list-supported-encodings' = 'all from-json help limit namespace namespace-name page page-size'
        'log-analytics config-work-request get-config-work-request' = 'from-json help namespace-name work-request-id'
        'log-analytics config-work-request list-config-work-requests' = 'all compartment-id from-json help limit namespace-name page page-size sort-by sort-order'
        'log-analytics content-export export-custom-content' = 'field-names file from-json help namespace-name parser-names source-names'
        'log-analytics content-import import-custom-content' = 'file from-json help is-overwrite namespace-name'
        'log-analytics em-bridge change-compartment' = 'bridge-id compartment-id from-json help if-match namespace namespace-name'
        'log-analytics em-bridge create' = 'bucket-name compartment-id defined-tags description display-name em-entities-compartment-id freeform-tags from-json help max-wait-seconds namespace namespace-name wait-for-state wait-interval-seconds'
        'log-analytics em-bridge delete' = 'bridge-id force from-json help if-match namespace namespace-name'
        'log-analytics em-bridge get' = 'bridge-id from-json help namespace namespace-name'
        'log-analytics em-bridge list' = 'all compartment-id display-name from-json help import-status lifecycle-details-contains lifecycle-state limit namespace namespace-name page page-size sort-by sort-order'
        'log-analytics em-bridge summary' = 'compartment-id from-json help namespace namespace-name'
        'log-analytics em-bridge update' = 'bridge-id bucket-name defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds namespace namespace-name wait-for-state wait-interval-seconds'
        'log-analytics entity add-associations' = 'association-entities entity-id from-json help if-match namespace namespace-name'
        'log-analytics entity change-compartment' = 'compartment-id entity-id from-json help if-match namespace namespace-name'
        'log-analytics entity create' = 'agent-id cloud-resource-id compartment-id defined-tags entity-type-name freeform-tags from-json help hostname max-wait-seconds name namespace namespace-name properties source-id timezone-region wait-for-state wait-interval-seconds'
        'log-analytics entity delete' = 'entity-id force from-json help if-match namespace namespace-name'
        'log-analytics entity get' = 'entity-id from-json help namespace namespace-name'
        'log-analytics entity list' = 'all cloud-resource-id compartment-id creation-source-details creation-source-type entity-type-name from-json help hostname hostname-contains is-agent-id-null lifecycle-details-contains lifecycle-state limit name name-contains namespace namespace-name page page-size sort-by sort-order source-id'
        'log-analytics entity list-associations' = 'all direct-or-all entity-id from-json help limit namespace namespace-name page page-size sort-by sort-order'
        'log-analytics entity remove-associations' = 'association-entities entity-id from-json help if-match namespace namespace-name'
        'log-analytics entity summary' = 'compartment-id from-json help namespace namespace-name'
        'log-analytics entity update' = 'agent-id defined-tags entity-id force freeform-tags from-json help hostname if-match max-wait-seconds name namespace namespace-name properties timezone-region wait-for-state wait-interval-seconds'
        'log-analytics entity-type create' = 'category from-json help name namespace namespace-name properties'
        'log-analytics entity-type delete' = 'force from-json help if-match name namespace namespace-name'
        'log-analytics entity-type get' = 'from-json help name namespace namespace-name'
        'log-analytics entity-type list' = 'all cloud-type from-json help lifecycle-state limit name name-contains namespace namespace-name page page-size sort-by sort-order'
        'log-analytics entity-type update' = 'category force from-json help if-match name namespace namespace-name properties'
        'log-analytics field delete-field' = 'field-name force from-json help if-match namespace-name'
        'log-analytics field get-field' = 'field-name from-json help namespace-name'
        'log-analytics field get-fields-summary' = 'from-json help is-show-detail namespace-name'
        'log-analytics field list-fields' = 'all filter from-json help is-include-parser is-match-all limit namespace-name page page-size parser-ids parser-names parser-type sort-by sort-order source-ids source-names'
        'log-analytics field upsert-field' = 'data-type description display-name from-json help if-match is-multi-valued name namespace-name'
        'log-analytics label batch-get-basic-info' = 'basic-label-sort-by from-json help is-include-deleted label-names limit namespace-name page sort-order'
        'log-analytics label delete-label' = 'force from-json help if-match label-name namespace-name'
        'log-analytics label get-label' = 'from-json help label-name namespace-name'
        'log-analytics label get-label-summary' = 'from-json help namespace-name'
        'log-analytics label list-label-priorities' = 'all from-json help limit namespace-name page page-size'
        'log-analytics label list-label-source-details' = 'all from-json help label-name label-source-sort-by limit namespace-name page page-size sort-order'
        'log-analytics label list-labels' = 'all from-json help is-alias-pop is-count-pop is-system label-display-text label-name label-priority label-sort-by limit namespace-name page page-size sort-order'
        'log-analytics label upsert-label' = 'aliases description display-name edit-version from-json help if-match impact is-system name namespace-name priority recommendation suggest-type type'
        'log-analytics log-group change-compartment' = 'compartment-id from-json help if-match log-group-id namespace-name'
        'log-analytics log-group create' = 'compartment-id defined-tags description display-name freeform-tags from-json help namespace-name'
        'log-analytics log-group delete' = 'force from-json help if-match log-group-id namespace-name'
        'log-analytics log-group get' = 'from-json help log-group-id namespace-name'
        'log-analytics log-group get-log-analytics-log-groups-summary' = 'compartment-id from-json help namespace-name'
        'log-analytics log-group list' = 'all compartment-id display-name from-json help limit namespace-name page page-size sort-by sort-order'
        'log-analytics log-group update' = 'defined-tags description display-name force freeform-tags from-json help if-match log-group-id namespace-name'
        'log-analytics lookup append-data' = 'char-encoding file from-json help if-match is-force lookup-name max-wait-seconds namespace-name wait-for-state wait-interval-seconds'
        'log-analytics lookup delete' = 'force from-json help if-match is-force lookup-name max-wait-seconds namespace-name wait-for-state wait-interval-seconds'
        'log-analytics lookup get' = 'from-json help lookup-name namespace-name'
        'log-analytics lookup get-summary' = 'from-json help namespace-name'
        'log-analytics lookup list' = 'all from-json help is-hide-special is-system limit lookup-display-text namespace-name page page-size sort-by sort-order status type'
        'log-analytics lookup register-lookup' = 'char-encoding description file from-json help is-hidden name namespace-name type'
        'log-analytics lookup update' = 'default-match-value description fields force from-json help if-match lookup-name max-matches namespace-name'
        'log-analytics lookup update-data' = 'char-encoding file from-json help if-match is-force lookup-name max-wait-seconds namespace-name wait-for-state wait-interval-seconds'
        'log-analytics namespace get' = 'from-json help namespace-name'
        'log-analytics namespace list' = 'all compartment-id from-json help'
        'log-analytics namespace offboard' = 'from-json help max-wait-seconds namespace-name wait-for-state wait-interval-seconds'
        'log-analytics namespace onboard' = 'from-json help max-wait-seconds namespace-name wait-for-state wait-interval-seconds'
        'log-analytics object-collection-rule change-compartment' = 'compartment-id from-json help if-match namespace namespace-name object-collection-rule-id'
        'log-analytics object-collection-rule create' = 'char-encoding collection-type compartment-id defined-tags description entity-id freeform-tags from-json help is-enabled log-group-id log-source-name max-wait-seconds name namespace namespace-name os-bucket-name os-namespace overrides poll-since poll-till wait-for-state wait-interval-seconds'
        'log-analytics object-collection-rule delete' = 'force from-json help if-match namespace namespace-name object-collection-rule-id'
        'log-analytics object-collection-rule get' = 'from-json help namespace namespace-name object-collection-rule-id'
        'log-analytics object-collection-rule list' = 'all compartment-id from-json help lifecycle-state limit name namespace namespace-name page page-size sort-by sort-order'
        'log-analytics object-collection-rule update' = 'char-encoding defined-tags description entity-id force freeform-tags from-json help if-match is-enabled log-group-id log-source-name max-wait-seconds namespace namespace-name object-collection-rule-id overrides wait-for-state wait-interval-seconds'
        'log-analytics parser delete-parser' = 'force from-json help if-match namespace-name parser-name'
        'log-analytics parser extract-structured-log-field-paths' = 'content description display-name edit-version encoding example-content field-delimiter field-maps field-qualifier footer-content from-json header-content help is-default is-hidden is-parser-written-once is-single-line-content is-system is-user-deleted language log-type-test-request-version mapped-parsers name namespace-name parser-filter parser-functions parser-ignoreline-chars parser-sequence parser-timezone parser-type sources sources-count time-updated tokenize-original-text type'
        'log-analytics parser extract-structured-log-header-paths' = 'content description display-name edit-version encoding example-content field-delimiter field-maps field-qualifier footer-content from-json header-content help is-default is-hidden is-parser-written-once is-single-line-content is-system is-user-deleted language log-type-test-request-version mapped-parsers name namespace-name parser-filter parser-functions parser-ignoreline-chars parser-sequence parser-timezone parser-type sources sources-count time-updated tokenize-original-text type'
        'log-analytics parser get-parser' = 'from-json help namespace-name parser-name'
        'log-analytics parser get-parser-summary' = 'from-json help namespace-name'
        'log-analytics parser list-parser-functions' = 'all from-json help limit namespace-name page page-size parser-name sort-by sort-order'
        'log-analytics parser list-parser-meta-plugins' = 'all from-json help limit namespace-name page page-size sort-by sort-order'
        'log-analytics parser list-parsers' = 'all from-json help is-match-all is-system limit namespace-name page page-size parser-display-text parser-name parser-type sort-by sort-order source-type'
        'log-analytics parser test-parser' = 'content description display-name encoding example-content field-delimiter field-maps field-qualifier footer-content from-json header-content help is-default is-hidden is-parser-written-once is-single-line-content is-system language log-type-test-request-version metadata name namespace-name parser-functions parser-ignoreline-chars parser-sequence parser-timezone req-origin-module scope time-updated tokenize-original-text type'
        'log-analytics parser upsert-parser' = 'content description display-name edit-version encoding example-content field-delimiter field-maps field-qualifier footer-content from-json header-content help if-match is-default is-parser-written-once is-single-line-content is-system language log-type-test-request-version name namespace-name parser-functions parser-ignoreline-chars parser-sequence parser-timezone tokenize-original-text type'
        'log-analytics query export' = 'compartment-id compartment-id-in-subtree file from-json help max-total-count namespace namespace-name output-format query-string query-timeout-in-seconds scope-filters should-include-columns should-localize should-use-acceleration sub-system time-end time-start timezone'
        'log-analytics query filter' = 'filters from-json help namespace namespace-name query-string sub-system'
        'log-analytics query get-query-result' = 'from-json help limit namespace namespace-name output-mode page should-include-columns should-include-fields work-request-id'
        'log-analytics query parse' = 'from-json help namespace namespace-name query-string sub-system'
        'log-analytics query search' = 'async-mode compartment-id compartment-id-in-subtree from-json help limit max-total-count max-wait-seconds namespace namespace-name page query-string query-timeout-in-seconds scope-filters should-include-columns should-include-fields should-include-total-count should-run-async should-use-acceleration sub-system time-end time-start timezone wait-for-state wait-interval-seconds'
        'log-analytics query suggest' = 'compartment-id compartment-id-in-subtree from-json help namespace namespace-name query-string sub-system'
        'log-analytics query-work-request background' = 'from-json help if-match namespace namespace-name work-request-id'
        'log-analytics query-work-request cancel' = 'force from-json help if-match namespace namespace-name work-request-id'
        'log-analytics query-work-request get' = 'from-json help namespace namespace-name work-request-id'
        'log-analytics query-work-request list' = 'all compartment-id from-json help limit mode namespace namespace-name page page-size sort-by sort-order'
        'log-analytics scheduled-task change-compartment' = 'compartment-id from-json help if-match namespace namespace-name scheduled-task-id'
        'log-analytics scheduled-task clean' = 'from-json help namespace namespace-name scheduled-task-id time-end time-start'
        'log-analytics scheduled-task create-acceleration-task' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds namespace namespace-name saved-search-id wait-for-state wait-interval-seconds'
        'log-analytics scheduled-task create-standard-task' = 'action compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds namespace namespace-name schedules task-type wait-for-state wait-interval-seconds'
        'log-analytics scheduled-task delete' = 'force from-json help if-match namespace namespace-name scheduled-task-id'
        'log-analytics scheduled-task get' = 'from-json help namespace namespace-name scheduled-task-id'
        'log-analytics scheduled-task list' = 'all compartment-id display-name display-name-contains from-json help limit namespace namespace-name page page-size saved-search-id sort-by sort-order task-type'
        'log-analytics scheduled-task pause' = 'from-json help if-match max-wait-seconds namespace namespace-name scheduled-task-id wait-for-state wait-interval-seconds'
        'log-analytics scheduled-task resume' = 'from-json help if-match max-wait-seconds namespace namespace-name scheduled-task-id wait-for-state wait-interval-seconds'
        'log-analytics scheduled-task run' = 'from-json help namespace namespace-name scheduled-task-id time-end time-start'
        'log-analytics scheduled-task update' = 'action defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds namespace namespace-name scheduled-task-id schedules wait-for-state wait-interval-seconds'
        'log-analytics source add-event-types' = 'from-json help items namespace-name source-name'
        'log-analytics source delete-source' = 'force from-json help if-match namespace-name source-name'
        'log-analytics source disable-auto-assoc' = 'from-json help items max-wait-seconds namespace-name source-name wait-for-state wait-interval-seconds'
        'log-analytics source disable-event-types' = 'from-json help items namespace-name source-name'
        'log-analytics source enable-auto-assoc' = 'from-json help items max-wait-seconds namespace-name source-name wait-for-state wait-interval-seconds'
        'log-analytics source enable-event-types' = 'from-json help items namespace-name source-name'
        'log-analytics source get-column-names' = 'from-json help namespace-name sql-query'
        'log-analytics source get-source' = 'compartment-id from-json help namespace-name source-name'
        'log-analytics source get-source-summary' = 'from-json help namespace-name'
        'log-analytics source list-associable-entities' = 'all compartment-id from-json help limit namespace-name page page-size search-text sort-by sort-order source-name type'
        'log-analytics source list-auto-assocs' = 'all from-json help limit namespace-name page page-size sort-by sort-order source-name'
        'log-analytics source list-event-types' = 'all display-text from-json help is-enabled is-system limit namespace-name page page-size sort-by sort-order source-name'
        'log-analytics source list-meta-source-types' = 'all from-json help limit namespace-name page page-size sort-by sort-order'
        'log-analytics source list-source-extfield-defs' = 'all from-json help limit namespace-name page page-size sort-by sort-order source-name'
        'log-analytics source list-source-functions' = 'all from-json help limit namespace-name page page-size sort-by sort-order'
        'log-analytics source list-source-label-operators' = 'all from-json help limit namespace-name page page-size sort-by sort-order'
        'log-analytics source list-source-patterns' = 'all from-json help is-include limit namespace-name page page-size sort-by sort-order source-name'
        'log-analytics source list-sources' = 'all compartment-id entity-type from-json help is-auto-associated is-simplified is-system limit name namespace-name page page-size sort-by sort-order source-display-text'
        'log-analytics source remove-event-types' = 'from-json help items namespace-name source-name'
        'log-analytics source upsert-source' = 'create-like-source-id data-filter-definitions database-credential description display-name edit-version entity-types extfield-defs from-json functions help if-match is-for-cloud is-ignore-warning is-incremental is-secure-content is-system is-timezone-override label-conditions label-definitions labels metadata-fields metric-definitions metrics name namespace-name oob-parsers parameters parsers patterns rule-id source-id type-name user-parsers warning-config'
        'log-analytics source validate-source' = 'create-like-source-id data-filter-definitions database-credential description display-name edit-version entity-types extfield-defs from-json functions help is-for-cloud is-ignore-warning is-incremental is-secure-content is-system is-timezone-override label-conditions label-definitions labels metadata-fields metric-definitions metrics name namespace-name oob-parsers parameters parsers patterns rule-id source-id type-name user-parsers warning-config'
        'log-analytics source validate-source-extfield-details' = 'assoc-count assoc-entity data-filter-definitions database-credential description display-name edit-version entity-types event-types extfield-defs from-json functions help is-auto-assoc-enabled is-auto-assoc-override is-for-cloud is-secure-content is-system is-timezone-override label-conditions label-definitions labels metadata-fields metric-definitions metrics name namespace-name oob-parsers parameters parsers pattern-count patterns rule-id source-id time-updated type-display-name type-name user-parsers warning-config'
        'log-analytics storage disable-archiving' = 'from-json help if-match namespace-name'
        'log-analytics storage enable-archiving' = 'from-json help if-match namespace-name'
        'log-analytics storage estimate-purge-data-size' = 'compartment-id compartment-id-in-subtree data-type from-json help if-match namespace-name purge-query-string time-data-ended'
        'log-analytics storage estimate-recall-data-size' = 'from-json help namespace-name time-data-ended time-data-started'
        'log-analytics storage estimate-release-data-size' = 'from-json help namespace-name time-data-ended time-data-started'
        'log-analytics storage get' = 'from-json help namespace-name'
        'log-analytics storage get-storage-usage' = 'from-json help namespace-name'
        'log-analytics storage get-storage-work-request' = 'from-json help namespace-name work-request-id'
        'log-analytics storage list-log-sets' = 'all from-json help limit namespace-name page page-size sort-order'
        'log-analytics storage list-recalled-data' = 'all from-json help limit namespace-name page page-size sort-by sort-order time-data-ended-less-than time-data-started-greater-than-or-equal'
        'log-analytics storage list-storage-work-request-errors' = 'all compartment-id from-json help limit namespace-name page page-size sort-by sort-order work-request-id'
        'log-analytics storage list-storage-work-requests' = 'all compartment-id from-json help limit namespace-name operation-type page page-size policy-id policy-name sort-by sort-order status time-finished time-started'
        'log-analytics storage purge-storage-data' = 'compartment-id compartment-id-in-subtree data-type from-json help if-match max-wait-seconds namespace-name purge-query-string time-data-ended wait-for-state wait-interval-seconds'
        'log-analytics storage recall-archived-data' = 'compartment-id data-type from-json help if-match max-wait-seconds namespace-name time-data-ended time-data-started wait-for-state wait-interval-seconds'
        'log-analytics storage release-recalled-data' = 'compartment-id data-type from-json help if-match max-wait-seconds namespace-name time-data-ended time-data-started wait-for-state wait-interval-seconds'
        'log-analytics storage update' = 'archiving-configuration force from-json help if-match namespace-name'
        'log-analytics timezone-collection list-supported-timezones' = 'all from-json help limit namespace namespace-name page page-size'
        'log-analytics upload delete' = 'force from-json help if-match namespace namespace-name upload-reference'
        'log-analytics upload delete-upload-file' = 'file-reference force from-json help namespace namespace-name upload-reference'
        'log-analytics upload delete-upload-warning' = 'force from-json help namespace namespace-name upload-reference warning-reference'
        'log-analytics upload get' = 'from-json help namespace namespace-name upload-reference'
        'log-analytics upload list' = 'all from-json help limit name name-contains namespace namespace-name page page-size sort-by sort-order warnings-filter'
        'log-analytics upload list-upload-files' = 'all from-json help limit namespace namespace-name page page-size search-str sort-by sort-order status upload-reference'
        'log-analytics upload list-upload-warnings' = 'all from-json help limit namespace namespace-name page page-size upload-reference'
        'log-analytics upload upload-log-events-file' = 'content-type file from-json help log-group-id log-set namespace namespace-name payload-type'
        'log-analytics upload upload-log-file' = 'char-encoding content-md5 content-type date-format date-year entity-id file filename from-json help invalidate-cache log-set log-source-name namespace namespace-name opc-meta-loggrpid timezone upload-name'
        'log-analytics upload validate-file' = 'filename from-json help namespace namespace-name object-location'
        'log-analytics upload validate-source-mapping' = 'filename from-json help log-source-name namespace namespace-name object-location'
        'log-analytics warning list' = 'all compartment-id end-time entity-name entity-type from-json help is-no-source limit namespace-name page page-size sort-by sort-order source-name source-pattern start-time warning-message warning-state warning-type'
        'log-analytics warning suppress' = 'compartment-id from-json help namespace-name warning-references'
        'log-analytics warning unsuppress' = 'compartment-id from-json help namespace-name warning-references'
        'log-analytics work-request get' = 'from-json help namespace-name work-request-id'
        'log-analytics work-request list' = 'all compartment-id from-json help limit namespace-name page page-size'
        'log-analytics work-request-error list' = 'all from-json help limit namespace-name page page-size work-request-id'
        'log-analytics work-request-log list' = 'all from-json help limit namespace-name page page-size work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_log_analytics() {
    $ociCommandsToShortParams = @{
        'log-analytics assoc delete-assocs' = '? c h'
        'log-analytics assoc get-assoc-summary' = '? c h'
        'log-analytics assoc list-associated-entities' = '? c h'
        'log-analytics assoc list-entity-source-assocs' = '? c h'
        'log-analytics assoc list-source-assocs' = '? c h'
        'log-analytics assoc upsert-assocs' = '? c h'
        'log-analytics assoc validate-assoc-params' = '? c h'
        'log-analytics char-encoding-collection list-supported-encodings' = '? h ns'
        'log-analytics config-work-request get-config-work-request' = '? h'
        'log-analytics config-work-request list-config-work-requests' = '? c h'
        'log-analytics content-export export-custom-content' = '? h'
        'log-analytics content-import import-custom-content' = '? h'
        'log-analytics em-bridge change-compartment' = '? c h ns'
        'log-analytics em-bridge create' = '? c h ns'
        'log-analytics em-bridge delete' = '? h ns'
        'log-analytics em-bridge get' = '? h ns'
        'log-analytics em-bridge list' = '? c h ns'
        'log-analytics em-bridge summary' = '? c h ns'
        'log-analytics em-bridge update' = '? h ns'
        'log-analytics entity add-associations' = '? h ns'
        'log-analytics entity change-compartment' = '? c h ns'
        'log-analytics entity create' = '? c h ns'
        'log-analytics entity delete' = '? h ns'
        'log-analytics entity get' = '? h ns'
        'log-analytics entity list' = '? c h ns'
        'log-analytics entity list-associations' = '? h ns'
        'log-analytics entity remove-associations' = '? h ns'
        'log-analytics entity summary' = '? c h ns'
        'log-analytics entity update' = '? h ns'
        'log-analytics entity-type create' = '? h ns'
        'log-analytics entity-type delete' = '? h ns'
        'log-analytics entity-type get' = '? h ns'
        'log-analytics entity-type list' = '? h lc ns'
        'log-analytics entity-type update' = '? h ns'
        'log-analytics field delete-field' = '? h'
        'log-analytics field get-field' = '? h'
        'log-analytics field get-fields-summary' = '? h'
        'log-analytics field list-fields' = '? h'
        'log-analytics field upsert-field' = '? h'
        'log-analytics label batch-get-basic-info' = '? h'
        'log-analytics label delete-label' = '? h'
        'log-analytics label get-label' = '? h'
        'log-analytics label get-label-summary' = '? h'
        'log-analytics label list-label-priorities' = '? h'
        'log-analytics label list-label-source-details' = '? h'
        'log-analytics label list-labels' = '? h'
        'log-analytics label upsert-label' = '? h'
        'log-analytics log-group change-compartment' = '? c h'
        'log-analytics log-group create' = '? c h'
        'log-analytics log-group delete' = '? h'
        'log-analytics log-group get' = '? h'
        'log-analytics log-group get-log-analytics-log-groups-summary' = '? c h'
        'log-analytics log-group list' = '? c h'
        'log-analytics log-group update' = '? h'
        'log-analytics lookup append-data' = '? h'
        'log-analytics lookup delete' = '? h'
        'log-analytics lookup get' = '? h'
        'log-analytics lookup get-summary' = '? h'
        'log-analytics lookup list' = '? h'
        'log-analytics lookup register-lookup' = '? h'
        'log-analytics lookup update' = '? h'
        'log-analytics lookup update-data' = '? h'
        'log-analytics namespace get' = '? h'
        'log-analytics namespace list' = '? c h'
        'log-analytics namespace offboard' = '? h'
        'log-analytics namespace onboard' = '? h'
        'log-analytics object-collection-rule change-compartment' = '? c h ns'
        'log-analytics object-collection-rule create' = '? c h ns'
        'log-analytics object-collection-rule delete' = '? h ns'
        'log-analytics object-collection-rule get' = '? h ns'
        'log-analytics object-collection-rule list' = '? c h ns'
        'log-analytics object-collection-rule update' = '? h ns'
        'log-analytics parser delete-parser' = '? h'
        'log-analytics parser extract-structured-log-field-paths' = '? h'
        'log-analytics parser extract-structured-log-header-paths' = '? h'
        'log-analytics parser get-parser' = '? h'
        'log-analytics parser get-parser-summary' = '? h'
        'log-analytics parser list-parser-functions' = '? h'
        'log-analytics parser list-parser-meta-plugins' = '? h'
        'log-analytics parser list-parsers' = '? h'
        'log-analytics parser test-parser' = '? h'
        'log-analytics parser upsert-parser' = '? h'
        'log-analytics query export' = '? c h ns'
        'log-analytics query filter' = '? h ns'
        'log-analytics query get-query-result' = '? h ns'
        'log-analytics query parse' = '? h ns'
        'log-analytics query search' = '? c h ns'
        'log-analytics query suggest' = '? c h ns'
        'log-analytics query-work-request background' = '? h ns'
        'log-analytics query-work-request cancel' = '? h ns'
        'log-analytics query-work-request get' = '? h ns'
        'log-analytics query-work-request list' = '? c h ns'
        'log-analytics scheduled-task change-compartment' = '? c h ns'
        'log-analytics scheduled-task clean' = '? h ns'
        'log-analytics scheduled-task create-acceleration-task' = '? c h ns'
        'log-analytics scheduled-task create-standard-task' = '? c h ns'
        'log-analytics scheduled-task delete' = '? h ns'
        'log-analytics scheduled-task get' = '? h ns'
        'log-analytics scheduled-task list' = '? c h ns'
        'log-analytics scheduled-task pause' = '? h ns'
        'log-analytics scheduled-task resume' = '? h ns'
        'log-analytics scheduled-task run' = '? h ns'
        'log-analytics scheduled-task update' = '? h ns'
        'log-analytics source add-event-types' = '? h'
        'log-analytics source delete-source' = '? h'
        'log-analytics source disable-auto-assoc' = '? h'
        'log-analytics source disable-event-types' = '? h'
        'log-analytics source enable-auto-assoc' = '? h'
        'log-analytics source enable-event-types' = '? h'
        'log-analytics source get-column-names' = '? h'
        'log-analytics source get-source' = '? c h'
        'log-analytics source get-source-summary' = '? h'
        'log-analytics source list-associable-entities' = '? c h'
        'log-analytics source list-auto-assocs' = '? h'
        'log-analytics source list-event-types' = '? h'
        'log-analytics source list-meta-source-types' = '? h'
        'log-analytics source list-source-extfield-defs' = '? h'
        'log-analytics source list-source-functions' = '? h'
        'log-analytics source list-source-label-operators' = '? h'
        'log-analytics source list-source-patterns' = '? h'
        'log-analytics source list-sources' = '? c h'
        'log-analytics source remove-event-types' = '? h'
        'log-analytics source upsert-source' = '? h'
        'log-analytics source validate-source' = '? h'
        'log-analytics source validate-source-extfield-details' = '? h'
        'log-analytics storage disable-archiving' = '? h'
        'log-analytics storage enable-archiving' = '? h'
        'log-analytics storage estimate-purge-data-size' = '? c h'
        'log-analytics storage estimate-recall-data-size' = '? h'
        'log-analytics storage estimate-release-data-size' = '? h'
        'log-analytics storage get' = '? h'
        'log-analytics storage get-storage-usage' = '? h'
        'log-analytics storage get-storage-work-request' = '? h'
        'log-analytics storage list-log-sets' = '? h'
        'log-analytics storage list-recalled-data' = '? h'
        'log-analytics storage list-storage-work-request-errors' = '? c h'
        'log-analytics storage list-storage-work-requests' = '? c h'
        'log-analytics storage purge-storage-data' = '? c h'
        'log-analytics storage recall-archived-data' = '? c h'
        'log-analytics storage release-recalled-data' = '? c h'
        'log-analytics storage update' = '? h'
        'log-analytics timezone-collection list-supported-timezones' = '? h ns'
        'log-analytics upload delete' = '? h ns'
        'log-analytics upload delete-upload-file' = '? h ns'
        'log-analytics upload delete-upload-warning' = '? h ns'
        'log-analytics upload get' = '? h ns'
        'log-analytics upload list' = '? h ns'
        'log-analytics upload list-upload-files' = '? h ns'
        'log-analytics upload list-upload-warnings' = '? h ns'
        'log-analytics upload upload-log-events-file' = '? h ns'
        'log-analytics upload upload-log-file' = '? h ns'
        'log-analytics upload validate-file' = '? h ns'
        'log-analytics upload validate-source-mapping' = '? h ns'
        'log-analytics warning list' = '? c h'
        'log-analytics warning suppress' = '? c h'
        'log-analytics warning unsuppress' = '? c h'
        'log-analytics work-request get' = '? h'
        'log-analytics work-request list' = '? c h'
        'log-analytics work-request-error list' = '? h'
        'log-analytics work-request-log list' = '? h'
    }
    return $ociCommandsToShortParams
}