function GetOciTopLevelCommand_vulnerability_scanning() {
    return 'vulnerability-scanning'
}

function GetOciSubcommands_vulnerability_scanning() {
    $ociSubcommands = @{
        'vulnerability-scanning' = 'container host work-request work-request-error work-request-log-entry'
        'vulnerability-scanning container' = 'scan'
        'vulnerability-scanning container scan' = 'recipe result target'
        'vulnerability-scanning container scan recipe' = 'change-compartment create delete get list update'
        'vulnerability-scanning container scan result' = 'change-compartment delete get list'
        'vulnerability-scanning container scan target' = 'change-compartment create delete get list update'
        'vulnerability-scanning host' = 'scan vulnerability'
        'vulnerability-scanning host scan' = 'recipe result target'
        'vulnerability-scanning host scan recipe' = 'change-compartment create delete get list update'
        'vulnerability-scanning host scan result' = 'agent cis-benchmark endpoint-protection port'
        'vulnerability-scanning host scan result agent' = 'change-compartment delete export-csv get list'
        'vulnerability-scanning host scan result cis-benchmark' = 'change-compartment delete get list'
        'vulnerability-scanning host scan result endpoint-protection' = 'change-compartment delete get list'
        'vulnerability-scanning host scan result port' = 'change-compartment delete get list'
        'vulnerability-scanning host scan target' = 'change-compartment create delete get list update'
        'vulnerability-scanning host vulnerability' = 'export-csv get list list-impacted-hosts'
        'vulnerability-scanning work-request' = 'get list'
        'vulnerability-scanning work-request-error' = 'list'
        'vulnerability-scanning work-request-log-entry' = 'list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_vulnerability_scanning() {
    $ociCommandsToLongParams = @{
        'vulnerability-scanning container scan recipe change-compartment' = 'compartment-id container-scan-recipe-id from-json help if-match'
        'vulnerability-scanning container scan recipe create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds scan-settings wait-for-state wait-interval-seconds'
        'vulnerability-scanning container scan recipe delete' = 'container-scan-recipe-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning container scan recipe get' = 'container-scan-recipe-id from-json help'
        'vulnerability-scanning container scan recipe list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'vulnerability-scanning container scan recipe update' = 'container-scan-recipe-id defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds scan-settings wait-for-state wait-interval-seconds'
        'vulnerability-scanning container scan result change-compartment' = 'compartment-id container-scan-result-id from-json help if-match'
        'vulnerability-scanning container scan result delete' = 'container-scan-result-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning container scan result get' = 'container-scan-result-id from-json help'
        'vulnerability-scanning container scan result list' = 'all are-subcompartments-included compartment-id from-json help highest-problem-severity image limit page page-size repository sort-by sort-order time-started-greater-than-or-equal-to time-started-less-than-or-equal-to'
        'vulnerability-scanning container scan target change-compartment' = 'compartment-id container-scan-target-id from-json help if-match'
        'vulnerability-scanning container scan target create' = 'compartment-id container-scan-recipe-id defined-tags description display-name freeform-tags from-json help max-wait-seconds target-registry wait-for-state wait-interval-seconds'
        'vulnerability-scanning container scan target delete' = 'container-scan-target-id force from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning container scan target get' = 'container-scan-target-id from-json help'
        'vulnerability-scanning container scan target list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'vulnerability-scanning container scan target update' = 'container-scan-recipe-id container-scan-target-id defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds target-registry wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan recipe change-compartment' = 'compartment-id from-json help host-scan-recipe-id if-match'
        'vulnerability-scanning host scan recipe create' = 'agent-settings compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds port-settings schedule wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan recipe delete' = 'force from-json help host-scan-recipe-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan recipe get' = 'from-json help host-scan-recipe-id'
        'vulnerability-scanning host scan recipe list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'vulnerability-scanning host scan recipe update' = 'agent-settings defined-tags display-name force freeform-tags from-json help host-scan-recipe-id if-match max-wait-seconds port-settings schedule wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan result agent change-compartment' = 'compartment-id from-json help host-agent-scan-result-id if-match'
        'vulnerability-scanning host scan result agent delete' = 'force from-json help host-agent-scan-result-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan result agent export-csv' = 'compartment-id file from-json help highest-problem-severity instance-id operating-system time-started-after time-started-before'
        'vulnerability-scanning host scan result agent get' = 'from-json help host-agent-scan-result-id'
        'vulnerability-scanning host scan result agent list' = 'all compartment-id display-name from-json help highest-problem-severity instance-id limit operating-system page page-size sort-by sort-order time-started-greater-than-or-equal-to time-started-less-than-or-equal-to'
        'vulnerability-scanning host scan result cis-benchmark change-compartment' = 'compartment-id from-json help host-cis-benchmark-scan-result-id if-match'
        'vulnerability-scanning host scan result cis-benchmark delete' = 'force from-json help host-cis-benchmark-scan-result-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan result cis-benchmark get' = 'from-json help host-cis-benchmark-scan-result-id'
        'vulnerability-scanning host scan result cis-benchmark list' = 'all compartment-id display-name from-json help highest-problem-severity instance-id limit page page-size sort-by sort-order time-started-greater-than-or-equal-to time-started-less-than-or-equal-to'
        'vulnerability-scanning host scan result endpoint-protection change-compartment' = 'compartment-id from-json help host-endpoint-protection-scan-result-id if-match'
        'vulnerability-scanning host scan result endpoint-protection delete' = 'force from-json help host-endpoint-protection-scan-result-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan result endpoint-protection get' = 'from-json help host-endpoint-protection-scan-result-id'
        'vulnerability-scanning host scan result endpoint-protection list' = 'all compartment-id display-name from-json help highest-problem-severity instance-id limit page page-size sort-by sort-order time-started-greater-than-or-equal-to time-started-less-than-or-equal-to'
        'vulnerability-scanning host scan result port change-compartment' = 'compartment-id from-json help host-port-scan-result-id if-match'
        'vulnerability-scanning host scan result port delete' = 'force from-json help host-port-scan-result-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan result port get' = 'from-json help host-port-scan-result-id'
        'vulnerability-scanning host scan result port list' = 'all compartment-id display-name from-json help highest-problem-severity instance-id limit page page-size sort-by sort-order time-started-greater-than-or-equal-to time-started-less-than-or-equal-to'
        'vulnerability-scanning host scan target change-compartment' = 'compartment-id from-json help host-scan-target-id if-match'
        'vulnerability-scanning host scan target create' = 'compartment-id defined-tags description display-name freeform-tags from-json help host-scan-recipe-id instance-ids max-wait-seconds target-compartment-id wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan target delete' = 'force from-json help host-scan-target-id if-match max-wait-seconds wait-for-state wait-interval-seconds'
        'vulnerability-scanning host scan target get' = 'from-json help host-scan-target-id'
        'vulnerability-scanning host scan target list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'vulnerability-scanning host scan target update' = 'defined-tags description display-name force freeform-tags from-json help host-scan-recipe-id host-scan-target-id if-match instance-ids max-wait-seconds target-compartment-id wait-for-state wait-interval-seconds'
        'vulnerability-scanning host vulnerability export-csv' = 'compartment-id file from-json help time-last-detected-greater-than-or-equal-to time-last-detected-less-than-or-equal-to'
        'vulnerability-scanning host vulnerability get' = 'from-json help host-vulnerability-id'
        'vulnerability-scanning host vulnerability list' = 'all compartment-id cve-reference from-json help limit name page page-size severity sort-by sort-order vulnerability-type'
        'vulnerability-scanning host vulnerability list-impacted-hosts' = 'all from-json help host-vulnerability-id limit page page-size sort-by sort-order'
        'vulnerability-scanning work-request get' = 'from-json help work-request-id'
        'vulnerability-scanning work-request list' = 'all compartment-id from-json help limit page page-size'
        'vulnerability-scanning work-request-error list' = 'all from-json help limit page page-size work-request-id'
        'vulnerability-scanning work-request-log-entry list' = 'all from-json help limit page page-size work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_vulnerability_scanning() {
    $ociCommandsToShortParams = @{
        'vulnerability-scanning container scan recipe change-compartment' = '? c h'
        'vulnerability-scanning container scan recipe create' = '? c h'
        'vulnerability-scanning container scan recipe delete' = '? h'
        'vulnerability-scanning container scan recipe get' = '? h'
        'vulnerability-scanning container scan recipe list' = '? c h'
        'vulnerability-scanning container scan recipe update' = '? h'
        'vulnerability-scanning container scan result change-compartment' = '? c h'
        'vulnerability-scanning container scan result delete' = '? h'
        'vulnerability-scanning container scan result get' = '? h'
        'vulnerability-scanning container scan result list' = '? c h'
        'vulnerability-scanning container scan target change-compartment' = '? c h'
        'vulnerability-scanning container scan target create' = '? c h'
        'vulnerability-scanning container scan target delete' = '? h'
        'vulnerability-scanning container scan target get' = '? h'
        'vulnerability-scanning container scan target list' = '? c h'
        'vulnerability-scanning container scan target update' = '? h'
        'vulnerability-scanning host scan recipe change-compartment' = '? c h'
        'vulnerability-scanning host scan recipe create' = '? c h'
        'vulnerability-scanning host scan recipe delete' = '? h'
        'vulnerability-scanning host scan recipe get' = '? h'
        'vulnerability-scanning host scan recipe list' = '? c h'
        'vulnerability-scanning host scan recipe update' = '? h'
        'vulnerability-scanning host scan result agent change-compartment' = '? c h'
        'vulnerability-scanning host scan result agent delete' = '? h'
        'vulnerability-scanning host scan result agent export-csv' = '? c h'
        'vulnerability-scanning host scan result agent get' = '? h'
        'vulnerability-scanning host scan result agent list' = '? c h'
        'vulnerability-scanning host scan result cis-benchmark change-compartment' = '? c h'
        'vulnerability-scanning host scan result cis-benchmark delete' = '? h'
        'vulnerability-scanning host scan result cis-benchmark get' = '? h'
        'vulnerability-scanning host scan result cis-benchmark list' = '? c h'
        'vulnerability-scanning host scan result endpoint-protection change-compartment' = '? c h'
        'vulnerability-scanning host scan result endpoint-protection delete' = '? h'
        'vulnerability-scanning host scan result endpoint-protection get' = '? h'
        'vulnerability-scanning host scan result endpoint-protection list' = '? c h'
        'vulnerability-scanning host scan result port change-compartment' = '? c h'
        'vulnerability-scanning host scan result port delete' = '? h'
        'vulnerability-scanning host scan result port get' = '? h'
        'vulnerability-scanning host scan result port list' = '? c h'
        'vulnerability-scanning host scan target change-compartment' = '? c h'
        'vulnerability-scanning host scan target create' = '? c h'
        'vulnerability-scanning host scan target delete' = '? h'
        'vulnerability-scanning host scan target get' = '? h'
        'vulnerability-scanning host scan target list' = '? c h'
        'vulnerability-scanning host scan target update' = '? h'
        'vulnerability-scanning host vulnerability export-csv' = '? c h'
        'vulnerability-scanning host vulnerability get' = '? h'
        'vulnerability-scanning host vulnerability list' = '? c h'
        'vulnerability-scanning host vulnerability list-impacted-hosts' = '? h'
        'vulnerability-scanning work-request get' = '? h'
        'vulnerability-scanning work-request list' = '? c h'
        'vulnerability-scanning work-request-error list' = '? h'
        'vulnerability-scanning work-request-log-entry list' = '? h'
    }
    return $ociCommandsToShortParams
}