# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201210

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.rover.src.oci_cli_rover.generated import rover_service_cli


@click.command(cli_util.override('rover_bundle.rover_bundle_root_group.command_name', 'rover-bundle'), cls=CommandGroupWithAlias, help=cli_util.override('rover_bundle.rover_bundle_root_group.help', """A description of the RoverCloudService API."""), short_help=cli_util.override('rover_bundle.rover_bundle_root_group.short_help', """RoverCloudService API"""))
@cli_util.help_option_group
def rover_bundle_root_group():
    pass


@click.command(cli_util.override('rover_bundle.rover_cluster_group.command_name', 'rover-cluster'), cls=CommandGroupWithAlias, help="""Description of RoverCluster.""")
@cli_util.help_option_group
def rover_cluster_group():
    pass


@click.command(cli_util.override('rover_bundle.rover_node_group.command_name', 'rover-node'), cls=CommandGroupWithAlias, help="""Information about a RoverNode.""")
@cli_util.help_option_group
def rover_node_group():
    pass


rover_service_cli.rover_service_group.add_command(rover_bundle_root_group)
rover_bundle_root_group.add_command(rover_cluster_group)
rover_bundle_root_group.add_command(rover_node_group)


@rover_cluster_group.command(name=cli_util.override('rover_bundle.list_rover_cluster_rover_bundle_requests.command_name', 'list-rover-cluster-rover-bundle-requests'), help=u"""List all the roverBundleRequests for a given roverClusterId. \n[Command Reference](listRoverClusterRoverBundleRequests)""")
@cli_util.option('--rover-cluster-id', required=True, help=u"""Unique RoverCluster identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeTaskCreated"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeTaskCreated is descending. If no value is specified timeTaskCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'rover', 'class': 'RoverBundleRequestCollection'})
@cli_util.wrap_exceptions
def list_rover_cluster_rover_bundle_requests(ctx, from_json, all_pages, page_size, rover_cluster_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(rover_cluster_id, six.string_types) and len(rover_cluster_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-cluster-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_rover_cluster_rover_bundle_requests,
            rover_cluster_id=rover_cluster_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_rover_cluster_rover_bundle_requests,
            limit,
            page_size,
            rover_cluster_id=rover_cluster_id,
            **kwargs
        )
    else:
        result = client.list_rover_cluster_rover_bundle_requests(
            rover_cluster_id=rover_cluster_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@rover_node_group.command(name=cli_util.override('rover_bundle.list_rover_node_rover_bundle_requests.command_name', 'list-rover-node-rover-bundle-requests'), help=u"""List all the roverBundleRequests for a given roverNodeId. \n[Command Reference](listRoverNodeRoverBundleRequests)""")
@cli_util.option('--rover-node-id', required=True, help=u"""Unique RoverNode identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeTaskCreated"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeTaskCreated is descending. If no value is specified timeTaskCreated is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'rover', 'class': 'RoverBundleRequestCollection'})
@cli_util.wrap_exceptions
def list_rover_node_rover_bundle_requests(ctx, from_json, all_pages, page_size, rover_node_id, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(rover_node_id, six.string_types) and len(rover_node_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-node-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_rover_node_rover_bundle_requests,
            rover_node_id=rover_node_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_rover_node_rover_bundle_requests,
            limit,
            page_size,
            rover_node_id=rover_node_id,
            **kwargs
        )
    else:
        result = client.list_rover_node_rover_bundle_requests(
            rover_node_id=rover_node_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@rover_cluster_group.command(name=cli_util.override('rover_bundle.request_bundle_rover_cluster.command_name', 'request-bundle'), help=u"""Request to get rover bundle to the bucket in customer's tenancy. \n[Command Reference](requestBundleRoverCluster)""")
@cli_util.option('--destination-compartment-id', required=True, help=u"""The compartment OCID of destination compartment that the bundle will be copied to.""")
@cli_util.option('--destination-bucket-name', required=True, help=u"""The destination bucket name the bundle will be copied to.""")
@cli_util.option('--bundle-version', required=True, help=u"""The bundle version that customer wants to upgrade to.""")
@cli_util.option('--rover-cluster-id', required=True, help=u"""Unique RoverCluster identifier""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def request_bundle_rover_cluster(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, destination_compartment_id, destination_bucket_name, bundle_version, rover_cluster_id):

    if isinstance(rover_cluster_id, six.string_types) and len(rover_cluster_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-cluster-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['destinationCompartmentId'] = destination_compartment_id
    _details['destinationBucketName'] = destination_bucket_name
    _details['bundleVersion'] = bundle_version

    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    result = client.request_bundle_rover_cluster(
        rover_cluster_id=rover_cluster_id,
        request_rover_bundle_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('rover', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@rover_node_group.command(name=cli_util.override('rover_bundle.request_bundle_rover_node.command_name', 'request-bundle'), help=u"""Request to get rover bundle to the bucket in customer's tenancy. \n[Command Reference](requestBundleRoverNode)""")
@cli_util.option('--destination-compartment-id', required=True, help=u"""The compartment OCID of destination compartment that the bundle will be copied to.""")
@cli_util.option('--destination-bucket-name', required=True, help=u"""The destination bucket name the bundle will be copied to.""")
@cli_util.option('--bundle-version', required=True, help=u"""The bundle version that customer wants to upgrade to.""")
@cli_util.option('--rover-node-id', required=True, help=u"""Unique RoverNode identifier""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def request_bundle_rover_node(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, destination_compartment_id, destination_bucket_name, bundle_version, rover_node_id):

    if isinstance(rover_node_id, six.string_types) and len(rover_node_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-node-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['destinationCompartmentId'] = destination_compartment_id
    _details['destinationBucketName'] = destination_bucket_name
    _details['bundleVersion'] = bundle_version

    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    result = client.request_bundle_rover_node(
        rover_node_id=rover_node_id,
        request_rover_bundle_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('rover', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@rover_cluster_group.command(name=cli_util.override('rover_bundle.retrieve_available_bundle_versions_rover_cluster.command_name', 'retrieve-available-bundle-versions'), help=u"""Retrieve the latest available rover bundle version that can be upgraded to based on current bundle version. \n[Command Reference](retrieveAvailableBundleVersionsRoverCluster)""")
@cli_util.option('--current-rover-bundle-version', required=True, help=u"""The version of current rover bundle on customer's roverNode or roverCluster device.""")
@cli_util.option('--rover-cluster-id', required=True, help=u"""Unique RoverCluster identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'rover', 'class': 'RoverBundleVersion'})
@cli_util.wrap_exceptions
def retrieve_available_bundle_versions_rover_cluster(ctx, from_json, current_rover_bundle_version, rover_cluster_id):

    if isinstance(rover_cluster_id, six.string_types) and len(rover_cluster_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-cluster-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['currentRoverBundleVersion'] = current_rover_bundle_version

    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    result = client.retrieve_available_bundle_versions_rover_cluster(
        rover_cluster_id=rover_cluster_id,
        current_rover_bundle_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@rover_node_group.command(name=cli_util.override('rover_bundle.retrieve_available_bundle_versions_rover_node.command_name', 'retrieve-available-bundle-versions'), help=u"""Retrieve the latest available rover bundle version that can be upgraded to based on current bundle version. \n[Command Reference](retrieveAvailableBundleVersionsRoverNode)""")
@cli_util.option('--current-rover-bundle-version', required=True, help=u"""The version of current rover bundle on customer's roverNode or roverCluster device.""")
@cli_util.option('--rover-node-id', required=True, help=u"""Unique RoverNode identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'rover', 'class': 'RoverBundleVersion'})
@cli_util.wrap_exceptions
def retrieve_available_bundle_versions_rover_node(ctx, from_json, current_rover_bundle_version, rover_node_id):

    if isinstance(rover_node_id, six.string_types) and len(rover_node_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-node-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['currentRoverBundleVersion'] = current_rover_bundle_version

    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    result = client.retrieve_available_bundle_versions_rover_node(
        rover_node_id=rover_node_id,
        current_rover_bundle_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@rover_cluster_group.command(name=cli_util.override('rover_bundle.retrieve_bundle_status_rover_cluster.command_name', 'retrieve-bundle-status'), help=u"""Retrieve the status and progress of a rover bundle copy request. \n[Command Reference](retrieveBundleStatusRoverCluster)""")
@cli_util.option('--work-request-id', required=True, help=u"""The workRequestId for an async copyObject operation.""")
@cli_util.option('--rover-cluster-id', required=True, help=u"""Unique RoverCluster identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'rover', 'class': 'RoverBundleStatus'})
@cli_util.wrap_exceptions
def retrieve_bundle_status_rover_cluster(ctx, from_json, work_request_id, rover_cluster_id):

    if isinstance(rover_cluster_id, six.string_types) and len(rover_cluster_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-cluster-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['workRequestId'] = work_request_id

    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    result = client.retrieve_bundle_status_rover_cluster(
        rover_cluster_id=rover_cluster_id,
        rover_bundle_status_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@rover_node_group.command(name=cli_util.override('rover_bundle.retrieve_bundle_status_rover_node.command_name', 'retrieve-bundle-status'), help=u"""Retrieve the status and progress of a rover bundle copy request. \n[Command Reference](retrieveBundleStatusRoverNode)""")
@cli_util.option('--work-request-id', required=True, help=u"""The workRequestId for an async copyObject operation.""")
@cli_util.option('--rover-node-id', required=True, help=u"""Unique RoverNode identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'rover', 'class': 'RoverBundleStatus'})
@cli_util.wrap_exceptions
def retrieve_bundle_status_rover_node(ctx, from_json, work_request_id, rover_node_id):

    if isinstance(rover_node_id, six.string_types) and len(rover_node_id.strip()) == 0:
        raise click.UsageError('Parameter --rover-node-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['workRequestId'] = work_request_id

    client = cli_util.build_client('rover', 'rover_bundle', ctx)
    result = client.retrieve_bundle_status_rover_node(
        rover_node_id=rover_node_id,
        rover_bundle_status_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
