function GetOciTopLevelCommand_os_management() {
    return 'os-management'
}

function GetOciSubcommands_os_management() {
    $ociSubcommands = @{
        'os-management' = 'erratum erratum-summary managed-instance managed-instance-group scheduled-job software-source windows-update work-request'
        'os-management erratum' = 'get'
        'os-management erratum-summary' = 'list-errata'
        'os-management managed-instance' = 'attach-child attach-parent detach-child detach-parent get install-all-updates install-all-windows-updates install-package install-update install-windows-update list list-available-packages list-available-software-sources list-available-updates list-available-windows-updates list-installed-packages list-installed-windows-updates list-managed-instance-errata remove-package'
        'os-management managed-instance-group' = 'attach change-compartment create delete detach get list update'
        'os-management scheduled-job' = 'change-compartment create delete get list list-upcoming run-now skip-next-execution update'
        'os-management software-source' = 'add-packages change-compartment create delete get get-package list list-packages remove-packages search-packages update'
        'os-management windows-update' = 'get list'
        'os-management work-request' = 'get list list-errors list-logs'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_os_management() {
    $ociCommandsToLongParams = @{
        'os-management erratum get' = 'erratum-id from-json help'
        'os-management erratum-summary list-errata' = 'advisory-name all compartment-id erratum-id from-json help limit page page-size sort-by sort-order time-issue-date-end time-issue-date-start'
        'os-management managed-instance attach-child' = 'from-json help managed-instance-id software-source-id'
        'os-management managed-instance attach-parent' = 'from-json help managed-instance-id software-source-id'
        'os-management managed-instance detach-child' = 'from-json help managed-instance-id software-source-id'
        'os-management managed-instance detach-parent' = 'from-json help managed-instance-id software-source-id'
        'os-management managed-instance get' = 'from-json help managed-instance-id'
        'os-management managed-instance install-all-updates' = 'from-json help managed-instance-id max-wait-seconds wait-for-state wait-interval-seconds'
        'os-management managed-instance install-all-windows-updates' = 'from-json help managed-instance-id max-wait-seconds wait-for-state wait-interval-seconds'
        'os-management managed-instance install-package' = 'from-json help managed-instance-id max-wait-seconds package-name wait-for-state wait-interval-seconds'
        'os-management managed-instance install-update' = 'from-json help managed-instance-id max-wait-seconds package-name wait-for-state wait-interval-seconds'
        'os-management managed-instance install-windows-update' = 'from-json help managed-instance-id max-wait-seconds wait-for-state wait-interval-seconds windows-update-name'
        'os-management managed-instance list' = 'all compartment-id display-name from-json help limit os-family page page-size sort-by sort-order'
        'os-management managed-instance list-available-packages' = 'all compartment-id display-name from-json help limit managed-instance-id page page-size sort-by sort-order'
        'os-management managed-instance list-available-software-sources' = 'all compartment-id display-name from-json help limit managed-instance-id page page-size sort-by sort-order'
        'os-management managed-instance list-available-updates' = 'all compartment-id display-name from-json help limit managed-instance-id page page-size sort-by sort-order'
        'os-management managed-instance list-available-windows-updates' = 'all compartment-id display-name from-json help is-eligible-for-installation limit managed-instance-id page page-size sort-by sort-order'
        'os-management managed-instance list-installed-packages' = 'all compartment-id display-name from-json help limit managed-instance-id page page-size sort-by sort-order'
        'os-management managed-instance list-installed-windows-updates' = 'all compartment-id display-name from-json help limit managed-instance-id page page-size sort-by sort-order'
        'os-management managed-instance list-managed-instance-errata' = 'all compartment-id display-name from-json help limit managed-instance-id page page-size sort-by sort-order'
        'os-management managed-instance remove-package' = 'from-json help managed-instance-id max-wait-seconds package-name wait-for-state wait-interval-seconds'
        'os-management managed-instance-group attach' = 'from-json help managed-instance-group-id managed-instance-id'
        'os-management managed-instance-group change-compartment' = 'compartment-id from-json help if-match managed-instance-group-id'
        'os-management managed-instance-group create' = 'compartment-id defined-tags description display-name freeform-tags from-json help max-wait-seconds os-family wait-for-state wait-interval-seconds'
        'os-management managed-instance-group delete' = 'force from-json help if-match managed-instance-group-id max-wait-seconds wait-for-state wait-interval-seconds'
        'os-management managed-instance-group detach' = 'from-json help managed-instance-group-id managed-instance-id'
        'os-management managed-instance-group get' = 'from-json help managed-instance-group-id'
        'os-management managed-instance-group list' = 'all compartment-id display-name from-json help lifecycle-state limit os-family page page-size sort-by sort-order'
        'os-management managed-instance-group update' = 'defined-tags description display-name force freeform-tags from-json help if-match managed-instance-group-id max-wait-seconds wait-for-state wait-interval-seconds'
        'os-management scheduled-job change-compartment' = 'compartment-id from-json help if-match scheduled-job-id'
        'os-management scheduled-job create' = 'compartment-id defined-tags description display-name freeform-tags from-json help interval-type interval-value managed-instance-groups managed-instances max-wait-seconds operation-type os-family package-names schedule-type time-next-execution update-names update-type wait-for-state wait-interval-seconds'
        'os-management scheduled-job delete' = 'force from-json help if-match max-wait-seconds scheduled-job-id wait-for-state wait-interval-seconds'
        'os-management scheduled-job get' = 'from-json help scheduled-job-id'
        'os-management scheduled-job list' = 'all compartment-id display-name from-json help lifecycle-state limit managed-instance-group-id managed-instance-id operation-type os-family page page-size sort-by sort-order'
        'os-management scheduled-job list-upcoming' = 'all compartment-id display-name from-json help lifecycle-state limit os-family page page-size sort-by sort-order tag-name tag-value time-end'
        'os-management scheduled-job run-now' = 'from-json help if-match scheduled-job-id'
        'os-management scheduled-job skip-next-execution' = 'from-json help if-match scheduled-job-id'
        'os-management scheduled-job update' = 'defined-tags description display-name force freeform-tags from-json help if-match interval-type interval-value max-wait-seconds operation-type package-names schedule-type scheduled-job-id time-next-execution update-names update-type wait-for-state wait-interval-seconds'
        'os-management software-source add-packages' = 'from-json help package-names software-source-id'
        'os-management software-source change-compartment' = 'compartment-id from-json help if-match software-source-id'
        'os-management software-source create' = 'arch-type checksum-type compartment-id defined-tags description display-name freeform-tags from-json help maintainer-email maintainer-name maintainer-phone max-wait-seconds parent-id wait-for-state wait-interval-seconds'
        'os-management software-source delete' = 'force from-json help if-match max-wait-seconds software-source-id wait-for-state wait-interval-seconds'
        'os-management software-source get' = 'from-json help software-source-id'
        'os-management software-source get-package' = 'from-json help package-name software-source-id'
        'os-management software-source list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'os-management software-source list-packages' = 'all compartment-id display-name from-json help limit page page-size software-source-id sort-by sort-order'
        'os-management software-source remove-packages' = 'from-json help package-names software-source-id'
        'os-management software-source search-packages' = 'cve-name display-name from-json help limit package-name page sort-by sort-order'
        'os-management software-source update' = 'checksum-type defined-tags description display-name force freeform-tags from-json help if-match maintainer-email maintainer-name maintainer-phone max-wait-seconds software-source-id wait-for-state wait-interval-seconds'
        'os-management windows-update get' = 'from-json help windows-update'
        'os-management windows-update list' = 'all compartment-id display-name from-json help limit page page-size sort-by sort-order'
        'os-management work-request get' = 'from-json help work-request-id'
        'os-management work-request list' = 'all compartment-id display-name from-json help limit managed-instance-id os-family page page-size sort-by sort-order'
        'os-management work-request list-errors' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'os-management work-request list-logs' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_os_management() {
    $ociCommandsToShortParams = @{
        'os-management erratum get' = '? h'
        'os-management erratum-summary list-errata' = '? c h'
        'os-management managed-instance attach-child' = '? h'
        'os-management managed-instance attach-parent' = '? h'
        'os-management managed-instance detach-child' = '? h'
        'os-management managed-instance detach-parent' = '? h'
        'os-management managed-instance get' = '? h'
        'os-management managed-instance install-all-updates' = '? h'
        'os-management managed-instance install-all-windows-updates' = '? h'
        'os-management managed-instance install-package' = '? h'
        'os-management managed-instance install-update' = '? h'
        'os-management managed-instance install-windows-update' = '? h'
        'os-management managed-instance list' = '? c h'
        'os-management managed-instance list-available-packages' = '? c h'
        'os-management managed-instance list-available-software-sources' = '? c h'
        'os-management managed-instance list-available-updates' = '? c h'
        'os-management managed-instance list-available-windows-updates' = '? c h'
        'os-management managed-instance list-installed-packages' = '? c h'
        'os-management managed-instance list-installed-windows-updates' = '? c h'
        'os-management managed-instance list-managed-instance-errata' = '? c h'
        'os-management managed-instance remove-package' = '? h'
        'os-management managed-instance-group attach' = '? h'
        'os-management managed-instance-group change-compartment' = '? c h'
        'os-management managed-instance-group create' = '? c h'
        'os-management managed-instance-group delete' = '? h'
        'os-management managed-instance-group detach' = '? h'
        'os-management managed-instance-group get' = '? h'
        'os-management managed-instance-group list' = '? c h'
        'os-management managed-instance-group update' = '? h'
        'os-management scheduled-job change-compartment' = '? c h'
        'os-management scheduled-job create' = '? c h'
        'os-management scheduled-job delete' = '? h'
        'os-management scheduled-job get' = '? h'
        'os-management scheduled-job list' = '? c h'
        'os-management scheduled-job list-upcoming' = '? c h'
        'os-management scheduled-job run-now' = '? h'
        'os-management scheduled-job skip-next-execution' = '? h'
        'os-management scheduled-job update' = '? h'
        'os-management software-source add-packages' = '? h'
        'os-management software-source change-compartment' = '? c h'
        'os-management software-source create' = '? c h'
        'os-management software-source delete' = '? h'
        'os-management software-source get' = '? h'
        'os-management software-source get-package' = '? h'
        'os-management software-source list' = '? c h'
        'os-management software-source list-packages' = '? c h'
        'os-management software-source remove-packages' = '? h'
        'os-management software-source search-packages' = '? h'
        'os-management software-source update' = '? h'
        'os-management windows-update get' = '? h'
        'os-management windows-update list' = '? c h'
        'os-management work-request get' = '? h'
        'os-management work-request list' = '? c h'
        'os-management work-request list-errors' = '? h'
        'os-management work-request list-logs' = '? h'
    }
    return $ociCommandsToShortParams
}