function GetOciTopLevelCommand_data_integration() {
    return 'data-integration'
}

function GetOciSubcommands_data_integration() {
    $ociSubcommands = @{
        'data-integration' = 'application connection connection-validation data-asset data-entity data-flow data-flow-validation external-publication external-publication-validation folder pipeline pipeline-validation project reference schema task task-run task-run-log task-validation work-request workspace'
        'data-integration application' = 'create create-patch delete delete-patch get get-dependent-object get-patch get-published-object list list-dependent-objects list-patch-changes list-patches list-published-objects update'
        'data-integration connection' = 'create delete get list update'
        'data-integration connection-validation' = 'create delete get list'
        'data-integration data-asset' = 'create delete get list update'
        'data-integration data-entity' = 'create-entity-shape-from-file get list'
        'data-integration data-flow' = 'create delete get list update'
        'data-integration data-flow-validation' = 'create delete get list'
        'data-integration external-publication' = 'create delete get list update'
        'data-integration external-publication-validation' = 'create delete get list'
        'data-integration folder' = 'create delete get list update'
        'data-integration pipeline' = 'create delete get list update'
        'data-integration pipeline-validation' = 'create delete get list'
        'data-integration project' = 'create delete get get-count-statistic list update'
        'data-integration reference' = 'get list update'
        'data-integration schema' = 'get list'
        'data-integration task' = 'create-data-loader-task create-integration-task create-pipeline-task delete get list update-data-loader-task update-integration-task update-pipeline-task'
        'data-integration task-run' = 'create delete get list update'
        'data-integration task-run-log' = 'list'
        'data-integration task-validation' = 'create-from-data-loader-task create-from-integration-task create-from-pipeline-task delete get list'
        'data-integration work-request' = 'get list list-work-request-errors list-work-request-logs'
        'data-integration workspace' = 'change-compartment create delete get list start stop update'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_data_integration() {
    $ociCommandsToLongParams = @{
        'data-integration application create' = 'description from-json help identifier key model-type model-version name object-status registry-metadata source-application-info workspace-id'
        'data-integration application create-patch' = 'application-key description from-json help identifier key model-version name object-keys object-status patch-type registry-metadata workspace-id'
        'data-integration application delete' = 'application-key force from-json help if-match workspace-id'
        'data-integration application delete-patch' = 'application-key force from-json help if-match patch-key workspace-id'
        'data-integration application get' = 'application-key from-json help workspace-id'
        'data-integration application get-dependent-object' = 'application-key dependent-object-key from-json help workspace-id'
        'data-integration application get-patch' = 'application-key from-json help patch-key workspace-id'
        'data-integration application get-published-object' = 'application-key expand-references from-json help published-object-key workspace-id'
        'data-integration application list' = 'all fields from-json help identifier limit name page page-size sort-by sort-order workspace-id'
        'data-integration application list-dependent-objects' = 'all application-key fields from-json help identifier limit name page page-size sort-by sort-order type type-in-subtree workspace-id'
        'data-integration application list-patch-changes' = 'all application-key from-json help limit name page page-size since-patch sort-by sort-order to-patch workspace-id'
        'data-integration application list-patches' = 'all application-key fields from-json help identifier limit name page page-size sort-by sort-order workspace-id'
        'data-integration application list-published-objects' = 'all application-key fields from-json help identifier limit name page page-size sort-by sort-order type type-in-subtree workspace-id'
        'data-integration application update' = 'application-key application-version description force from-json help identifier if-match key metadata model-type model-version name object-status object-version parent-ref workspace-id'
        'data-integration connection create' = 'connection-properties credential-file-content description finger-print from-json help identifier key model-type model-version name object-status parent-ref pass-phrase password registry-metadata user-id username workspace-id'
        'data-integration connection delete' = 'connection-key force from-json help if-match workspace-id'
        'data-integration connection get' = 'connection-key from-json help workspace-id'
        'data-integration connection list' = 'all data-asset-key fields from-json help limit name page page-size sort-by sort-order type workspace-id'
        'data-integration connection update' = 'connection-key connection-properties credential-file-content description finger-print force from-json help identifier if-match key model-type model-version name object-status object-version parent-ref pass-phrase password registry-metadata user-id username workspace-id'
        'data-integration connection-validation create' = 'connection data-asset from-json help registry-metadata workspace-id'
        'data-integration connection-validation delete' = 'con-validation-key force from-json help if-match workspace-id'
        'data-integration connection-validation get' = 'con-validation-key from-json help workspace-id'
        'data-integration connection-validation list' = 'all fields from-json help identifier key limit name page page-size sort-by sort-order workspace-id'
        'data-integration data-asset create' = 'asset-properties credential-file-content data-asset-type default-connection description driver-class external-key from-json help host identifier key model-type model-version name namespace object-status port registry-metadata service-name sid tenancy-id url workspace-id'
        'data-integration data-asset delete' = 'data-asset-key force from-json help if-match workspace-id'
        'data-integration data-asset get' = 'data-asset-key from-json help workspace-id'
        'data-integration data-asset list' = 'all fields from-json help limit name page page-size sort-by sort-order type workspace-id'
        'data-integration data-asset update' = 'asset-properties credential-file-content data-asset-key data-asset-type default-connection description driver-class external-key force from-json help host identifier if-match key model-type model-version name namespace object-status object-version port registry-metadata service-name sid tenancy-id url workspace-id'
        'data-integration data-entity create-entity-shape-from-file' = 'connection-key data-format description entity-type external-key foreign-keys from-json help identifier if-match key model-version name object-status object-version other-type-label parent-ref resource-name schema-resource-name shape shape-id types unique-keys workspace-id'
        'data-integration data-entity get' = 'connection-key data-entity-key from-json help schema-resource-name workspace-id'
        'data-integration data-entity list' = 'all connection-key fields from-json help is-pattern limit name name-list page page-size schema-resource-name sort-by sort-order type workspace-id'
        'data-integration data-flow create' = 'description flow-config-values from-json help identifier key model-version name nodes object-status parameters parent-ref registry-metadata workspace-id'
        'data-integration data-flow delete' = 'data-flow-key force from-json help if-match workspace-id'
        'data-integration data-flow get' = 'data-flow-key from-json help workspace-id'
        'data-integration data-flow list' = 'all fields folder-id from-json help identifier limit name page page-size sort-by sort-order workspace-id'
        'data-integration data-flow update' = 'data-flow-key description flow-config-values force from-json help identifier if-match key model-type model-version name nodes object-status object-version parameters parent-ref registry-metadata workspace-id'
        'data-integration data-flow-validation create' = 'description flow-config-values from-json help identifier key key-map metadata model-type model-version name nodes object-status object-version parameters parent-ref workspace-id'
        'data-integration data-flow-validation delete' = 'df-validation-key force from-json help if-match workspace-id'
        'data-integration data-flow-validation get' = 'df-validation-key from-json help workspace-id'
        'data-integration data-flow-validation list' = 'all fields from-json help identifier key limit name page page-size sort-by sort-order workspace-id'
        'data-integration external-publication create' = 'application-compartment-id application-id configuration-details description display-name from-json help resource-configuration task-key workspace-id'
        'data-integration external-publication delete' = 'external-publications-key force from-json help if-match task-key workspace-id'
        'data-integration external-publication get' = 'external-publications-key from-json help task-key workspace-id'
        'data-integration external-publication list' = 'all fields from-json help limit name page page-size sort-by sort-order task-key workspace-id'
        'data-integration external-publication update' = 'application-compartment-id application-id configuration-details description display-name external-publications-key force from-json help if-match resource-configuration task-key workspace-id'
        'data-integration external-publication-validation create' = 'from-json help key task-key workspace-id'
        'data-integration external-publication-validation delete' = 'external-publication-validation-key force from-json help if-match task-key workspace-id'
        'data-integration external-publication-validation get' = 'external-publication-validation-key from-json help task-key workspace-id'
        'data-integration external-publication-validation list' = 'all fields from-json help identifier limit name page page-size sort-by sort-order task-key workspace-id'
        'data-integration folder create' = 'category-name description from-json help identifier key model-version name object-status registry-metadata workspace-id'
        'data-integration folder delete' = 'folder-key force from-json help if-match workspace-id'
        'data-integration folder get' = 'folder-key from-json help workspace-id'
        'data-integration folder list' = 'aggregator-key all fields from-json help identifier limit name page page-size sort-by sort-order workspace-id'
        'data-integration folder update' = 'category-name description folder-key force from-json help identifier if-match key model-type model-version name object-status object-version parent-ref registry-metadata workspace-id'
        'data-integration pipeline create' = 'description flow-config-values from-json help identifier key model-type model-version name nodes object-status object-version parameters parent-ref registry-metadata variables workspace-id'
        'data-integration pipeline delete' = 'force from-json help if-match pipeline-key workspace-id'
        'data-integration pipeline get' = 'from-json help pipeline-key workspace-id'
        'data-integration pipeline list' = 'aggregator-key all fields from-json help identifier limit name page page-size sort-by sort-order workspace-id'
        'data-integration pipeline update' = 'description flow-config-values force from-json help identifier if-match key model-type model-version name nodes object-status object-version parameters parent-ref pipeline-key registry-metadata variables workspace-id'
        'data-integration pipeline-validation create' = 'description flow-config-values from-json help identifier key metadata model-type model-version name nodes object-status object-version parameters parent-ref variables workspace-id'
        'data-integration pipeline-validation delete' = 'force from-json help if-match pipeline-validation-key workspace-id'
        'data-integration pipeline-validation get' = 'from-json help pipeline-validation-key workspace-id'
        'data-integration pipeline-validation list' = 'all fields from-json help identifier key limit name page page-size sort-by sort-order workspace-id'
        'data-integration project create' = 'description from-json help identifier key model-version name object-status registry-metadata workspace-id'
        'data-integration project delete' = 'force from-json help if-match project-key workspace-id'
        'data-integration project get' = 'from-json help project-key workspace-id'
        'data-integration project get-count-statistic' = 'count-statistic-key from-json help workspace-id'
        'data-integration project list' = 'all fields from-json help identifier limit name page page-size sort-by sort-order workspace-id'
        'data-integration project update' = 'description force from-json help identifier if-match key model-type model-version name object-status object-version parent-ref project-key registry-metadata workspace-id'
        'data-integration reference get' = 'application-key from-json help reference-key workspace-id'
        'data-integration reference list' = 'all application-key from-json help limit name page page-size sort-by sort-order workspace-id'
        'data-integration reference update' = 'application-key child-references force from-json help if-match options reference-key target-object workspace-id'
        'data-integration schema get' = 'connection-key from-json help schema-resource-name workspace-id'
        'data-integration schema list' = 'all connection-key fields from-json help limit name name-list page page-size schema-resource-name sort-by sort-order workspace-id'
        'data-integration task create-data-loader-task' = 'config-provider-delegate data-flow description from-json help identifier input-ports key model-version name object-status op-config-values output-ports parameters parent-ref registry-metadata workspace-id'
        'data-integration task create-integration-task' = 'config-provider-delegate data-flow description from-json help identifier input-ports key model-version name object-status op-config-values output-ports parameters parent-ref registry-metadata workspace-id'
        'data-integration task create-pipeline-task' = 'config-provider description from-json help identifier input-ports key model-version name object-status op-config-values output-ports parameters parent-ref pipeline registry-metadata workspace-id'
        'data-integration task delete' = 'force from-json help if-match task-key workspace-id'
        'data-integration task get' = 'expand-references from-json help task-key workspace-id'
        'data-integration task list' = 'all fields folder-id from-json help identifier key limit name page page-size sort-by sort-order type workspace-id'
        'data-integration task update-data-loader-task' = 'config-provider-delegate data-flow description force from-json help identifier if-match input-ports key model-version name object-status object-version op-config-values output-ports parameters parent-ref registry-metadata task-key workspace-id'
        'data-integration task update-integration-task' = 'config-provider-delegate data-flow description force from-json help identifier if-match input-ports key model-version name object-status object-version op-config-values output-ports parameters parent-ref registry-metadata task-key workspace-id'
        'data-integration task update-pipeline-task' = 'config-provider description force from-json help identifier if-match input-ports key model-version name object-status object-version op-config-values output-ports parameters parent-ref pipeline registry-metadata task-key workspace-id'
        'data-integration task-run create' = 'application-key config-provider description from-json help identifier key model-type model-version name registry-metadata workspace-id'
        'data-integration task-run delete' = 'application-key force from-json help if-match task-run-key workspace-id'
        'data-integration task-run get' = 'application-key from-json help task-run-key workspace-id'
        'data-integration task-run list' = 'aggregator-key all application-key fields from-json help identifier limit name page page-size sort-by sort-order workspace-id'
        'data-integration task-run update' = 'application-key description force from-json help if-match key model-type model-version name object-version registry-metadata status task-run-key workspace-id'
        'data-integration task-run-log list' = 'all application-key from-json help limit page page-size sort-by sort-order task-run-key workspace-id'
        'data-integration task-validation create-from-data-loader-task' = 'config-provider-delegate data-flow description from-json help identifier input-ports key metadata model-version name object-status object-version op-config-values output-ports parameters parent-ref workspace-id'
        'data-integration task-validation create-from-integration-task' = 'config-provider-delegate data-flow description from-json help identifier input-ports key metadata model-version name object-status object-version op-config-values output-ports parameters parent-ref workspace-id'
        'data-integration task-validation create-from-pipeline-task' = 'config-provider description from-json help identifier input-ports key metadata model-version name object-status object-version op-config-values output-ports parameters parent-ref pipeline workspace-id'
        'data-integration task-validation delete' = 'force from-json help if-match task-validation-key workspace-id'
        'data-integration task-validation get' = 'from-json help task-validation-key workspace-id'
        'data-integration task-validation list' = 'all fields from-json help identifier key limit name page page-size sort-by sort-order workspace-id'
        'data-integration work-request get' = 'from-json help work-request-id'
        'data-integration work-request list' = 'all compartment-id from-json help limit page page-size sort-by sort-order work-request-status workspace-id'
        'data-integration work-request list-work-request-errors' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'data-integration work-request list-work-request-logs' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'data-integration workspace change-compartment' = 'compartment-id from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds workspace-id'
        'data-integration workspace create' = 'compartment-id defined-tags description display-name dns-server-ip dns-server-zone freeform-tags from-json help is-private-network max-wait-seconds subnet-id vcn-id wait-for-state wait-interval-seconds'
        'data-integration workspace delete' = 'force from-json help if-match is-force-operation max-wait-seconds quiesce-timeout wait-for-state wait-interval-seconds workspace-id'
        'data-integration workspace get' = 'from-json help workspace-id'
        'data-integration workspace list' = 'all compartment-id from-json help lifecycle-state limit name page page-size sort-by sort-order'
        'data-integration workspace start' = 'from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds workspace-id'
        'data-integration workspace stop' = 'from-json help if-match is-force-operation max-wait-seconds quiesce-timeout wait-for-state wait-interval-seconds workspace-id'
        'data-integration workspace update' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds wait-for-state wait-interval-seconds workspace-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_data_integration() {
    $ociCommandsToShortParams = @{
        'data-integration application create' = '? h'
        'data-integration application create-patch' = '? h'
        'data-integration application delete' = '? h'
        'data-integration application delete-patch' = '? h'
        'data-integration application get' = '? h'
        'data-integration application get-dependent-object' = '? h'
        'data-integration application get-patch' = '? h'
        'data-integration application get-published-object' = '? h'
        'data-integration application list' = '? h'
        'data-integration application list-dependent-objects' = '? h'
        'data-integration application list-patch-changes' = '? h'
        'data-integration application list-patches' = '? h'
        'data-integration application list-published-objects' = '? h'
        'data-integration application update' = '? h'
        'data-integration connection create' = '? h'
        'data-integration connection delete' = '? h'
        'data-integration connection get' = '? h'
        'data-integration connection list' = '? h'
        'data-integration connection update' = '? h'
        'data-integration connection-validation create' = '? h'
        'data-integration connection-validation delete' = '? h'
        'data-integration connection-validation get' = '? h'
        'data-integration connection-validation list' = '? h'
        'data-integration data-asset create' = '? h'
        'data-integration data-asset delete' = '? h'
        'data-integration data-asset get' = '? h'
        'data-integration data-asset list' = '? h'
        'data-integration data-asset update' = '? h'
        'data-integration data-entity create-entity-shape-from-file' = '? h'
        'data-integration data-entity get' = '? h'
        'data-integration data-entity list' = '? h'
        'data-integration data-flow create' = '? h'
        'data-integration data-flow delete' = '? h'
        'data-integration data-flow get' = '? h'
        'data-integration data-flow list' = '? h'
        'data-integration data-flow update' = '? h'
        'data-integration data-flow-validation create' = '? h'
        'data-integration data-flow-validation delete' = '? h'
        'data-integration data-flow-validation get' = '? h'
        'data-integration data-flow-validation list' = '? h'
        'data-integration external-publication create' = '? h'
        'data-integration external-publication delete' = '? h'
        'data-integration external-publication get' = '? h'
        'data-integration external-publication list' = '? h'
        'data-integration external-publication update' = '? h'
        'data-integration external-publication-validation create' = '? h'
        'data-integration external-publication-validation delete' = '? h'
        'data-integration external-publication-validation get' = '? h'
        'data-integration external-publication-validation list' = '? h'
        'data-integration folder create' = '? h'
        'data-integration folder delete' = '? h'
        'data-integration folder get' = '? h'
        'data-integration folder list' = '? h'
        'data-integration folder update' = '? h'
        'data-integration pipeline create' = '? h'
        'data-integration pipeline delete' = '? h'
        'data-integration pipeline get' = '? h'
        'data-integration pipeline list' = '? h'
        'data-integration pipeline update' = '? h'
        'data-integration pipeline-validation create' = '? h'
        'data-integration pipeline-validation delete' = '? h'
        'data-integration pipeline-validation get' = '? h'
        'data-integration pipeline-validation list' = '? h'
        'data-integration project create' = '? h'
        'data-integration project delete' = '? h'
        'data-integration project get' = '? h'
        'data-integration project get-count-statistic' = '? h'
        'data-integration project list' = '? h'
        'data-integration project update' = '? h'
        'data-integration reference get' = '? h'
        'data-integration reference list' = '? h'
        'data-integration reference update' = '? h'
        'data-integration schema get' = '? h'
        'data-integration schema list' = '? h'
        'data-integration task create-data-loader-task' = '? h'
        'data-integration task create-integration-task' = '? h'
        'data-integration task create-pipeline-task' = '? h'
        'data-integration task delete' = '? h'
        'data-integration task get' = '? h'
        'data-integration task list' = '? h'
        'data-integration task update-data-loader-task' = '? h'
        'data-integration task update-integration-task' = '? h'
        'data-integration task update-pipeline-task' = '? h'
        'data-integration task-run create' = '? h'
        'data-integration task-run delete' = '? h'
        'data-integration task-run get' = '? h'
        'data-integration task-run list' = '? h'
        'data-integration task-run update' = '? h'
        'data-integration task-run-log list' = '? h'
        'data-integration task-validation create-from-data-loader-task' = '? h'
        'data-integration task-validation create-from-integration-task' = '? h'
        'data-integration task-validation create-from-pipeline-task' = '? h'
        'data-integration task-validation delete' = '? h'
        'data-integration task-validation get' = '? h'
        'data-integration task-validation list' = '? h'
        'data-integration work-request get' = '? h'
        'data-integration work-request list' = '? c h'
        'data-integration work-request list-work-request-errors' = '? h'
        'data-integration work-request list-work-request-logs' = '? h'
        'data-integration workspace change-compartment' = '? c h'
        'data-integration workspace create' = '? c h'
        'data-integration workspace delete' = '? h'
        'data-integration workspace get' = '? h'
        'data-integration workspace list' = '? c h'
        'data-integration workspace start' = '? h'
        'data-integration workspace stop' = '? h'
        'data-integration workspace update' = '? h'
    }
    return $ociCommandsToShortParams
}