# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.os_management_hub.src.oci_cli_os_management_hub.generated import os_management_hub_service_cli


@click.command(cli_util.override('reporting_managed_instance.reporting_managed_instance_root_group.command_name', 'reporting-managed-instance'), cls=CommandGroupWithAlias, help=cli_util.override('reporting_managed_instance.reporting_managed_instance_root_group.help', """Use the OS Management Hub API to manage and monitor updates and patches for the operating system environments in your private data centers through a single management console. For more information, see [Overview of OS Management Hub]."""), short_help=cli_util.override('reporting_managed_instance.reporting_managed_instance_root_group.short_help', """OS Management Hub API"""))
@cli_util.help_option_group
def reporting_managed_instance_root_group():
    pass


@click.command(cli_util.override('reporting_managed_instance.managed_instance_group.command_name', 'managed-instance'), cls=CommandGroupWithAlias, help="""Detail information for an OCI Compute instance that is being managed.""")
@cli_util.help_option_group
def managed_instance_group():
    pass


@click.command(cli_util.override('reporting_managed_instance.managed_instance_analytic_collection_group.command_name', 'managed-instance-analytic-collection'), cls=CommandGroupWithAlias, help="""Collection of ManagedInstanceAnalyticSummary.""")
@cli_util.help_option_group
def managed_instance_analytic_collection_group():
    pass


os_management_hub_service_cli.os_management_hub_service_group.add_command(reporting_managed_instance_root_group)
reporting_managed_instance_root_group.add_command(managed_instance_group)
reporting_managed_instance_root_group.add_command(managed_instance_analytic_collection_group)


@managed_instance_group.command(name=cli_util.override('reporting_managed_instance.get_managed_instance_analytic_content.command_name', 'get-managed-instance-analytic-content'), help=u"""Returns a CSV format report of managed instances matching the given filters. \n[Command Reference](getManagedInstanceAnalyticContent)""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@cli_util.option('--compartment-id', help=u"""This compartmentId is used to list managed instances within a compartment. Or serve as an additional filter to restrict only managed instances with in certain compartment if other filter presents.""")
@cli_util.option('--managed-instance-group-id', help=u"""The OCID of the managed instance group for which to list resources.""")
@cli_util.option('--lifecycle-environment-id', help=u"""The OCID of the lifecycle environment.""")
@cli_util.option('--lifecycle-stage-id', help=u"""The OCID of the lifecycle stage for which to list resources.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["NORMAL", "UNREACHABLE", "ERROR", "WARNING", "REGISTRATION_ERROR"]), multiple=True, help=u"""A filter to return only instances whose managed instance status matches the given status.""")
@cli_util.option('--display-name', multiple=True, help=u"""A filter to return resources that match the given display names.""")
@cli_util.option('--display-name-contains', help=u"""A filter to return resources that may partially match the given display name.""")
@cli_util.option('--instance-location', type=custom_types.CliCaseInsensitiveChoice(["ON_PREMISE", "OCI_COMPUTE", "AZURE", "EC2"]), help=u"""Filter instances by Location. Used when report target type is compartment or group.""")
@cli_util.option('--security-updates-available-equals-to', type=click.INT, help=u"""A filter to return instances with number of available security updates equals to the number specified.""")
@cli_util.option('--bug-updates-available-equals-to', type=click.INT, help=u"""A filter to return instances with number of available bug updates equals to the number specified.""")
@cli_util.option('--security-updates-available-greater-than', type=click.INT, help=u"""A filter to return instances with number of available security updates greater than the number specified.""")
@cli_util.option('--bug-updates-available-greater-than', type=click.INT, help=u"""A filter to return instances with number of available bug updates greater than the number specified.""")
@json_skeleton_utils.get_cli_json_input_option({'display-name': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'display-name': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def get_managed_instance_analytic_content(ctx, from_json, file, compartment_id, managed_instance_group_id, lifecycle_environment_id, lifecycle_stage_id, status, display_name, display_name_contains, instance_location, security_updates_available_equals_to, bug_updates_available_equals_to, security_updates_available_greater_than, bug_updates_available_greater_than):

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if managed_instance_group_id is not None:
        kwargs['managed_instance_group_id'] = managed_instance_group_id
    if lifecycle_environment_id is not None:
        kwargs['lifecycle_environment_id'] = lifecycle_environment_id
    if lifecycle_stage_id is not None:
        kwargs['lifecycle_stage_id'] = lifecycle_stage_id
    if status is not None and len(status) > 0:
        kwargs['status'] = status
    if display_name is not None and len(display_name) > 0:
        kwargs['display_name'] = display_name
    if display_name_contains is not None:
        kwargs['display_name_contains'] = display_name_contains
    if instance_location is not None:
        kwargs['instance_location'] = instance_location
    if security_updates_available_equals_to is not None:
        kwargs['security_updates_available_equals_to'] = security_updates_available_equals_to
    if bug_updates_available_equals_to is not None:
        kwargs['bug_updates_available_equals_to'] = bug_updates_available_equals_to
    if security_updates_available_greater_than is not None:
        kwargs['security_updates_available_greater_than'] = security_updates_available_greater_than
    if bug_updates_available_greater_than is not None:
        kwargs['bug_updates_available_greater_than'] = bug_updates_available_greater_than
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'reporting_managed_instance', ctx)
    result = client.get_managed_instance_analytic_content(
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@managed_instance_group.command(name=cli_util.override('reporting_managed_instance.get_managed_instance_content.command_name', 'get-managed-instance-content'), help=u"""Returns a CSV format report of a single managed instance whose associated Erratas match the given filters. \n[Command Reference](getManagedInstanceContent)""")
@cli_util.option('--managed-instance-id', required=True, help=u"""The OCID of the managed instance.""")
@cli_util.option('--file', type=click.File(mode='wb'), required=True, help="The name of the file that will receive the response data, or '-' to write to STDOUT.")
@cli_util.option('--advisory-name', multiple=True, help=u"""The assigned erratum name. It's unique and not changeable.

Example: `ELSA-2020-5804`""")
@cli_util.option('--advisory-name-contains', help=u"""A filter to return resources that may partially match the erratum advisory name given.""")
@cli_util.option('--advisory-type', type=custom_types.CliCaseInsensitiveChoice(["SECURITY", "BUGFIX", "ENHANCEMENT"]), multiple=True, help=u"""A filter to return only errata that match the given advisory types.""")
@json_skeleton_utils.get_cli_json_input_option({'advisory-name': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'advisory-name': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.wrap_exceptions
def get_managed_instance_content(ctx, from_json, file, managed_instance_id, advisory_name, advisory_name_contains, advisory_type):

    if isinstance(managed_instance_id, six.string_types) and len(managed_instance_id.strip()) == 0:
        raise click.UsageError('Parameter --managed-instance-id cannot be whitespace or empty string')

    kwargs = {}
    if advisory_name is not None and len(advisory_name) > 0:
        kwargs['advisory_name'] = advisory_name
    if advisory_name_contains is not None:
        kwargs['advisory_name_contains'] = advisory_name_contains
    if advisory_type is not None and len(advisory_type) > 0:
        kwargs['advisory_type'] = advisory_type
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'reporting_managed_instance', ctx)
    result = client.get_managed_instance_content(
        managed_instance_id=managed_instance_id,
        **kwargs
    )

    # If outputting to stdout we don't want to print a progress bar because it will get mixed up with the output
    # Also we need a non-zero Content-Length in order to display a meaningful progress bar
    bar = None
    if hasattr(file, 'name') and file.name != '<stdout>' and 'Content-Length' in result.headers:
        content_length = int(result.headers['Content-Length'])
        if content_length > 0:
            bar = click.progressbar(length=content_length, label='Downloading file')

    try:
        if bar:
            bar.__enter__()

        # TODO: Make the download size a configurable option
        # use decode_content=True to automatically unzip service responses (this should be overridden for object storage)
        for chunk in result.data.raw.stream(cli_constants.MEBIBYTE, decode_content=True):
            if bar:
                bar.update(len(chunk))
            file.write(chunk)
    finally:
        if bar:
            bar.render_finish()
        file.close()


@managed_instance_analytic_collection_group.command(name=cli_util.override('reporting_managed_instance.summarize_managed_instance_analytics.command_name', 'summarize-managed-instance-analytics'), help=u"""Returns a list of user specified metrics for a collection of managed instances. \n[Command Reference](summarizeManagedInstanceAnalytics)""")
@cli_util.option('--metric-names', required=True, type=custom_types.CliCaseInsensitiveChoice(["TOTAL_INSTANCE_COUNT", "INSTANCE_WITH_AVAILABLE_SECURITY_UPDATES_COUNT", "INSTANCE_WITH_AVAILABLE_BUGFIX_UPDATES_COUNT", "NORMAL_INSTANCE_COUNT", "ERROR_INSTANCE_COUNT", "WARNING_INSTANCE_COUNT", "UNREACHABLE_INSTANCE_COUNT", "REGISTRATION_FAILED_INSTANCE_COUNT", "INSTANCE_SECURITY_UPDATES_COUNT", "INSTANCE_BUGFIX_UPDATES_COUNT"]), multiple=True, help=u"""A filter to return only metrics whose name matches the given metric names.""")
@cli_util.option('--compartment-id', help=u"""This compartmentId is used to list managed instances within a compartment. Or serve as an additional filter to restrict only managed instances with in certain compartment if other filter presents.""")
@cli_util.option('--managed-instance-group-id', help=u"""The OCID of the managed instance group for which to list resources.""")
@cli_util.option('--lifecycle-environment-id', help=u"""The OCID of the lifecycle environment.""")
@cli_util.option('--lifecycle-stage-id', help=u"""The OCID of the lifecycle stage for which to list resources.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["NORMAL", "UNREACHABLE", "ERROR", "WARNING", "REGISTRATION_ERROR"]), multiple=True, help=u"""A filter to return only instances whose managed instance status matches the given status.""")
@cli_util.option('--display-name', multiple=True, help=u"""A filter to return resources that match the given display names.""")
@cli_util.option('--display-name-contains', help=u"""A filter to return resources that may partially match the given display name.""")
@cli_util.option('--instance-location', type=custom_types.CliCaseInsensitiveChoice(["ON_PREMISE", "OCI_COMPUTE", "AZURE", "EC2"]), help=u"""Filter instances by Location. Used when report target type is compartment or group.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["name"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for name is ascending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@json_skeleton_utils.get_cli_json_input_option({'display-name': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'display-name': {'module': 'os_management_hub', 'class': 'list[string]'}}, output_type={'module': 'os_management_hub', 'class': 'ManagedInstanceAnalyticCollection'})
@cli_util.wrap_exceptions
def summarize_managed_instance_analytics(ctx, from_json, metric_names, compartment_id, managed_instance_group_id, lifecycle_environment_id, lifecycle_stage_id, status, display_name, display_name_contains, instance_location, limit, page, sort_by, sort_order):

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if managed_instance_group_id is not None:
        kwargs['managed_instance_group_id'] = managed_instance_group_id
    if lifecycle_environment_id is not None:
        kwargs['lifecycle_environment_id'] = lifecycle_environment_id
    if lifecycle_stage_id is not None:
        kwargs['lifecycle_stage_id'] = lifecycle_stage_id
    if status is not None and len(status) > 0:
        kwargs['status'] = status
    if display_name is not None and len(display_name) > 0:
        kwargs['display_name'] = display_name
    if display_name_contains is not None:
        kwargs['display_name_contains'] = display_name_contains
    if instance_location is not None:
        kwargs['instance_location'] = instance_location
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'reporting_managed_instance', ctx)
    result = client.summarize_managed_instance_analytics(
        metric_names=metric_names,
        **kwargs
    )
    cli_util.render_response(result, ctx)
