function GetOciTopLevelCommand_os() {
    return 'os'
}

function GetOciSubcommands_os() {
    $ociSubcommands = @{
        'os' = 'bucket multipart ns object object-lifecycle-policy preauth-request replication retention-rule work-request work-request-error work-request-log-entry'
        'os bucket' = 'create delete get list reencrypt update'
        'os multipart' = 'abort list'
        'os ns' = 'get get-metadata update-metadata'
        'os object' = 'bulk-delete bulk-delete-versions bulk-download bulk-upload copy delete get head list list-object-versions put reencrypt rename restore restore-status resume-put update-storage-tier'
        'os object-lifecycle-policy' = 'delete get put'
        'os preauth-request' = 'create delete get list'
        'os replication' = 'create-replication-policy delete-replication-policy get-replication-policy list-replication-policies list-replication-sources make-bucket-writable'
        'os retention-rule' = 'create delete get list update'
        'os work-request' = 'cancel get list'
        'os work-request-error' = 'list'
        'os work-request-log-entry' = 'list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_os() {
    $ociCommandsToLongParams = @{
        'os bucket create' = 'auto-tiering compartment-id defined-tags freeform-tags from-json help kms-key-id metadata name namespace namespace-name object-events-enabled public-access-type storage-tier versioning'
        'os bucket delete' = 'bucket-name force from-json help if-match name namespace namespace-name'
        'os bucket get' = 'bucket-name fields from-json help if-match if-none-match name namespace namespace-name'
        'os bucket list' = 'all compartment-id fields from-json help limit namespace namespace-name page page-size'
        'os bucket reencrypt' = 'bucket-name from-json help max-wait-seconds namespace namespace-name wait-for-state wait-interval-seconds'
        'os bucket update' = 'auto-tiering bucket-name compartment-id defined-tags freeform-tags from-json help if-match kms-key-id metadata name namespace namespace-name object-events-enabled public-access-type versioning'
        'os multipart abort' = 'bucket-name force from-json help namespace namespace-name object-name upload-id'
        'os multipart list' = 'all bucket-name from-json help limit namespace namespace-name page page-size'
        'os ns get' = 'compartment-id from-json help'
        'os ns get-metadata' = 'from-json help namespace namespace-name'
        'os ns update-metadata' = 'default-s3-compartment-id default-swift-compartment-id from-json help namespace namespace-name'
        'os object bulk-delete' = 'bucket-name delimiter dry-run exclude force from-json help include namespace namespace-name parallel-operations-count prefix'
        'os object bulk-delete-versions' = 'bucket-name delimiter dry-run exclude force from-json help include namespace namespace-name object-name parallel-operations-count prefix'
        'os object bulk-download' = 'bucket-name delimiter download-dir dry-run encryption-key-file exclude from-json help include multipart-download-threshold namespace namespace-name no-overwrite overwrite parallel-operations-count part-size prefix'
        'os object bulk-upload' = 'bucket-name content-encoding content-language content-type disable-parallel-uploads dry-run encryption-key-file exclude from-json help include metadata namespace namespace-name no-multipart no-overwrite object-prefix overwrite parallel-upload-count part-size src-dir storage-tier verify-checksum'
        'os object copy' = 'bucket-name destination-bucket destination-namespace destination-object-if-match-e-tag destination-object-if-none-match-e-tag destination-object-metadata destination-object-name destination-object-storage-tier destination-region encryption-key-file from-json help max-wait-seconds namespace namespace-name source-encryption-key-file source-object-if-match-e-tag source-object-name source-version-id wait-for-state wait-interval-seconds'
        'os object delete' = 'bucket-name force from-json help if-match name namespace namespace-name object-name version-id'
        'os object get' = 'bucket-name encryption-key-file file from-json help http-response-cache-control http-response-content-disposition http-response-content-encoding http-response-content-language http-response-content-type http-response-expires if-match if-none-match multipart-download-threshold name namespace namespace-name parallel-download-count part-size range version-id'
        'os object head' = 'bucket-name encryption-key-file from-json help if-match if-none-match name namespace namespace-name version-id'
        'os object list' = 'all bucket-name delimiter end fields from-json help limit namespace namespace-name page-size prefix start stream-output'
        'os object list-object-versions' = 'all bucket bucket-name delimiter end fields from-json help limit namespace namespace-name page page-size prefix start start-after'
        'os object put' = 'bucket-name cache-control content-disposition content-encoding content-language content-md5 content-type disable-parallel-uploads encryption-key-file file force from-json help if-match metadata name namespace namespace-name no-multipart no-overwrite parallel-upload-count part-size storage-tier verify-checksum'
        'os object reencrypt' = 'bucket-name encryption-key-file from-json help kms-key-id name namespace namespace-name object-name source-encryption-key-file version-id'
        'os object rename' = 'bucket bucket-name from-json help name namespace namespace-name new-if-match new-if-none-match new-name new-obj-if-match-e-tag new-obj-if-none-match-e-tag source-name src-if-match src-obj-if-match-e-tag'
        'os object restore' = 'bucket bucket-name from-json help hours name namespace namespace-name version-id'
        'os object restore-status' = 'bucket-name from-json help name namespace namespace-name'
        'os object resume-put' = 'bucket-name disable-parallel-uploads file from-json help name namespace namespace-name parallel-upload-count part-size upload-id'
        'os object update-storage-tier' = 'bucket bucket-name from-json help namespace namespace-name object-name storage-tier version-id'
        'os object-lifecycle-policy delete' = 'bucket-name force from-json help if-match namespace namespace-name'
        'os object-lifecycle-policy get' = 'bucket-name from-json help namespace namespace-name'
        'os object-lifecycle-policy put' = 'bucket-name force from-json help if-match if-none-match items namespace namespace-name'
        'os preauth-request create' = 'access-type bucket-listing-action bucket-name from-json help name namespace namespace-name object-name time-expires'
        'os preauth-request delete' = 'bucket-name force from-json help namespace namespace-name par-id'
        'os preauth-request get' = 'bucket-name from-json help namespace namespace-name par-id'
        'os preauth-request list' = 'all bucket-name from-json help limit namespace namespace-name object-name-prefix page page-size'
        'os replication create-replication-policy' = 'bucket bucket-name destination-bucket destination-region from-json help name namespace namespace-name'
        'os replication delete-replication-policy' = 'bucket bucket-name force from-json help namespace namespace-name replication-id'
        'os replication get-replication-policy' = 'bucket bucket-name from-json help namespace namespace-name replication-id'
        'os replication list-replication-policies' = 'all bucket bucket-name from-json help limit namespace namespace-name page page-size'
        'os replication list-replication-sources' = 'all bucket bucket-name from-json help limit namespace namespace-name page page-size'
        'os replication make-bucket-writable' = 'bucket bucket-name from-json help namespace namespace-name'
        'os retention-rule create' = 'bucket bucket-name display-name from-json help namespace namespace-name time-amount time-rule-locked time-unit'
        'os retention-rule delete' = 'bucket bucket-name force from-json help if-match namespace namespace-name retention-rule-id'
        'os retention-rule get' = 'bucket bucket-name from-json help namespace namespace-name retention-rule-id'
        'os retention-rule list' = 'all bucket bucket-name from-json help namespace namespace-name page'
        'os retention-rule update' = 'bucket bucket-name display-name from-json help if-match namespace namespace-name retention-rule-id time-amount time-rule-locked time-unit'
        'os work-request cancel' = 'force from-json help work-request-id'
        'os work-request get' = 'from-json help work-request-id'
        'os work-request list' = 'all compartment-id from-json help limit page page-size'
        'os work-request-error list' = 'all from-json help limit page page-size work-request-id'
        'os work-request-log-entry list' = 'all from-json help limit page page-size work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_os() {
    $ociCommandsToShortParams = @{
        'os bucket create' = '? c h ns'
        'os bucket delete' = '? bn h ns'
        'os bucket get' = '? bn h ns'
        'os bucket list' = '? c h ns'
        'os bucket reencrypt' = '? bn h ns'
        'os bucket update' = '? bn c h ns'
        'os multipart abort' = '? bn h ns on'
        'os multipart list' = '? bn h ns'
        'os ns get' = '? c h'
        'os ns get-metadata' = '? h ns'
        'os ns update-metadata' = '? h ns'
        'os object bulk-delete' = '? bn h ns'
        'os object bulk-delete-versions' = '? bn h ns'
        'os object bulk-download' = '? bn h ns'
        'os object bulk-upload' = '? bn h ns'
        'os object copy' = '? bn h ns'
        'os object delete' = '? bn h ns'
        'os object get' = '? bn h ns'
        'os object head' = '? bn h ns'
        'os object list' = '? bn h ns'
        'os object list-object-versions' = '? bn h ns'
        'os object put' = '? bn h ns'
        'os object reencrypt' = '? bn h ns on'
        'os object rename' = '? bn h ns'
        'os object restore' = '? bn h ns'
        'os object restore-status' = '? bn h ns'
        'os object resume-put' = '? bn h ns'
        'os object update-storage-tier' = '? bn h ns'
        'os object-lifecycle-policy delete' = '? bn h ns'
        'os object-lifecycle-policy get' = '? bn h ns'
        'os object-lifecycle-policy put' = '? bn h ns'
        'os preauth-request create' = '? bn h ns on'
        'os preauth-request delete' = '? bn h ns'
        'os preauth-request get' = '? bn h ns'
        'os preauth-request list' = '? bn h ns'
        'os replication create-replication-policy' = '? bn h ns'
        'os replication delete-replication-policy' = '? bn h ns'
        'os replication get-replication-policy' = '? bn h ns'
        'os replication list-replication-policies' = '? bn h ns'
        'os replication list-replication-sources' = '? bn h ns'
        'os replication make-bucket-writable' = '? bn h ns'
        'os retention-rule create' = '? bn h ns'
        'os retention-rule delete' = '? bn h ns'
        'os retention-rule get' = '? bn h ns'
        'os retention-rule list' = '? bn h ns'
        'os retention-rule update' = '? bn h ns'
        'os work-request cancel' = '? h'
        'os work-request get' = '? h'
        'os work-request list' = '? c h'
        'os work-request-error list' = '? h'
        'os work-request-log-entry list' = '? h'
    }
    return $ociCommandsToShortParams
}