# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.os_management_hub.src.oci_cli_os_management_hub.generated import os_management_hub_service_cli


@click.command(cli_util.override('software_source.software_source_root_group.command_name', 'software-source'), cls=CommandGroupWithAlias, help=cli_util.override('software_source.software_source_root_group.help', """Use the OS Management Hub API to manage and monitor updates and patches for the operating system environments in your private data centers through a single management console. For more information, see [Overview of OS Management Hub]."""), short_help=cli_util.override('software_source.software_source_root_group.short_help', """OS Management Hub API"""))
@cli_util.help_option_group
def software_source_root_group():
    pass


@click.command(cli_util.override('software_source.software_source_group.command_name', 'software-source'), cls=CommandGroupWithAlias, help="""A software source contains a collection of packages.""")
@cli_util.help_option_group
def software_source_group():
    pass


@click.command(cli_util.override('software_source.erratum_group.command_name', 'erratum'), cls=CommandGroupWithAlias, help="""Details about the erratum.""")
@cli_util.help_option_group
def erratum_group():
    pass


@click.command(cli_util.override('software_source.module_stream_group.command_name', 'module-stream'), cls=CommandGroupWithAlias, help="""A module stream provided by a software source.""")
@cli_util.help_option_group
def module_stream_group():
    pass


@click.command(cli_util.override('software_source.module_stream_profile_group.command_name', 'module-stream-profile'), cls=CommandGroupWithAlias, help="""A module stream profile provided by a software source.""")
@cli_util.help_option_group
def module_stream_profile_group():
    pass


@click.command(cli_util.override('software_source.package_group_group.command_name', 'package-group'), cls=CommandGroupWithAlias, help="""Yum/DNF package group, category or environment.""")
@cli_util.help_option_group
def package_group_group():
    pass


os_management_hub_service_cli.os_management_hub_service_group.add_command(software_source_root_group)
software_source_root_group.add_command(software_source_group)
software_source_root_group.add_command(erratum_group)
software_source_root_group.add_command(module_stream_group)
software_source_root_group.add_command(module_stream_profile_group)
software_source_root_group.add_command(package_group_group)


@software_source_group.command(name=cli_util.override('software_source.change_availability_of_software_sources.command_name', 'change-availability-of'), help=u"""Updates the availability for a list of specified software sources. \n[Command Reference](changeAvailabilityOfSoftwareSources)""")
@cli_util.option('--software-source-availabilities', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of objects containing software source ids and its availability.

This option is a JSON list with items of type SoftwareSourceAvailability.  For documentation on SoftwareSourceAvailability please see our API reference: https://docs.cloud.oracle.com/api/#/en/softwaresource/20220901/datatypes/SoftwareSourceAvailability.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'software-source-availabilities': {'module': 'os_management_hub', 'class': 'list[SoftwareSourceAvailability]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'software-source-availabilities': {'module': 'os_management_hub', 'class': 'list[SoftwareSourceAvailability]'}})
@cli_util.wrap_exceptions
def change_availability_of_software_sources(ctx, from_json, software_source_availabilities):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if software_source_availabilities is not None:
        _details['softwareSourceAvailabilities'] = cli_util.parse_json_parameter("software_source_availabilities", software_source_availabilities)

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.change_availability_of_software_sources(
        change_availability_of_software_sources_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.create_entitlement.command_name', 'create-entitlement'), help=u"""Registers the necessary entitlement credentials for OS vendor software sources. \n[Command Reference](createEntitlement)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the tenancy containing the entitlement.""")
@cli_util.option('--csi', required=True, help=u"""A Customer Support Identifier (CSI) is a unique key given to a customer to unlock software sources. It uniquely identifies the entitlement.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def create_entitlement(ctx, from_json, compartment_id, csi):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['csi'] = csi

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.create_entitlement(
        create_entitlement_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.create_software_source.command_name', 'create'), help=u"""Creates a new versioned or custom software source. \n[Command Reference](createSoftwareSource)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the tenancy containing the software source.""")
@cli_util.option('--display-name', required=True, help=u"""User friendly name for the software source.""")
@cli_util.option('--software-source-type', required=True, type=custom_types.CliCaseInsensitiveChoice(["VENDOR", "CUSTOM", "VERSIONED"]), help=u"""Type of the software source.""")
@cli_util.option('--description', help=u"""Information specified by the user about the software source.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSource'})
@cli_util.wrap_exceptions
def create_software_source(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, display_name, software_source_type, description, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['displayName'] = display_name
    _details['softwareSourceType'] = software_source_type

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.create_software_source(
        create_software_source_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.create_software_source_create_custom_software_source_details.command_name', 'create-software-source-create-custom-software-source-details'), help=u"""Creates a new versioned or custom software source. \n[Command Reference](createSoftwareSource)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the tenancy containing the software source.""")
@cli_util.option('--display-name', required=True, help=u"""User friendly name for the software source.""")
@cli_util.option('--vendor-software-sources', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of vendor software sources.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--description', help=u"""Information specified by the user about the software source.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--custom-software-source-filter', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-automatically-updated', type=click.BOOL, help=u"""Indicates whether service should automatically update the custom software source for the user.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}, 'vendor-software-sources': {'module': 'os_management_hub', 'class': 'list[Id]'}, 'custom-software-source-filter': {'module': 'os_management_hub', 'class': 'CustomSoftwareSourceFilter'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}, 'vendor-software-sources': {'module': 'os_management_hub', 'class': 'list[Id]'}, 'custom-software-source-filter': {'module': 'os_management_hub', 'class': 'CustomSoftwareSourceFilter'}}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSource'})
@cli_util.wrap_exceptions
def create_software_source_create_custom_software_source_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, display_name, vendor_software_sources, description, freeform_tags, defined_tags, custom_software_source_filter, is_automatically_updated):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['displayName'] = display_name
    _details['vendorSoftwareSources'] = cli_util.parse_json_parameter("vendor_software_sources", vendor_software_sources)

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if custom_software_source_filter is not None:
        _details['customSoftwareSourceFilter'] = cli_util.parse_json_parameter("custom_software_source_filter", custom_software_source_filter)

    if is_automatically_updated is not None:
        _details['isAutomaticallyUpdated'] = is_automatically_updated

    _details['softwareSourceType'] = 'CUSTOM'

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.create_software_source(
        create_software_source_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.create_software_source_create_versioned_custom_software_source_details.command_name', 'create-software-source-create-versioned-custom-software-source-details'), help=u"""Creates a new versioned or custom software source. \n[Command Reference](createSoftwareSource)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the tenancy containing the software source.""")
@cli_util.option('--display-name', required=True, help=u"""User friendly name for the software source.""")
@cli_util.option('--vendor-software-sources', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of vendor software sources.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--software-source-version', required=True, help=u"""The version to assign to this custom software source.""")
@cli_util.option('--description', help=u"""Information specified by the user about the software source.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--custom-software-source-filter', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}, 'vendor-software-sources': {'module': 'os_management_hub', 'class': 'list[Id]'}, 'custom-software-source-filter': {'module': 'os_management_hub', 'class': 'CustomSoftwareSourceFilter'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}, 'vendor-software-sources': {'module': 'os_management_hub', 'class': 'list[Id]'}, 'custom-software-source-filter': {'module': 'os_management_hub', 'class': 'CustomSoftwareSourceFilter'}}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSource'})
@cli_util.wrap_exceptions
def create_software_source_create_versioned_custom_software_source_details(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, display_name, vendor_software_sources, software_source_version, description, freeform_tags, defined_tags, custom_software_source_filter):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['displayName'] = display_name
    _details['vendorSoftwareSources'] = cli_util.parse_json_parameter("vendor_software_sources", vendor_software_sources)
    _details['softwareSourceVersion'] = software_source_version

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if custom_software_source_filter is not None:
        _details['customSoftwareSourceFilter'] = cli_util.parse_json_parameter("custom_software_source_filter", custom_software_source_filter)

    _details['softwareSourceType'] = 'VERSIONED'

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.create_software_source(
        create_software_source_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.delete_software_source.command_name', 'delete'), help=u"""Deletes the specified software source. \n[Command Reference](deleteSoftwareSource)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help="""This operation creates, modifies or deletes a resource that has a defined lifecycle state. Specify this option to perform the action and then wait until the resource reaches a given lifecycle state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the resource to reach the lifecycle state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the resource has reached the lifecycle state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_software_source(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, software_source_id, if_match):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.delete_software_source(
        software_source_id=software_source_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_software_source') and callable(getattr(client, 'get_software_source')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the resource has entered state: {}'.format(wait_for_state), file=sys.stderr)
                oci.wait_until(client, client.get_software_source(software_source_id), 'lifecycle_state', wait_for_state, succeed_on_not_found=True, **wait_period_kwargs)
            except oci.exceptions.ServiceError as e:
                # We make an initial service call so we can pass the result to oci.wait_until(), however if we are waiting on the
                # outcome of a delete operation it is possible that the resource is already gone and so the initial service call
                # will result in an exception that reflects a HTTP 404. In this case, we can exit with success (rather than raising
                # the exception) since this would have been the behaviour in the waiter anyway (as for delete we provide the argument
                # succeed_on_not_found=True to the waiter).
                #
                # Any non-404 should still result in the exception being thrown.
                if e.status == 404:
                    pass
                else:
                    raise
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the resource entered the specified state. Please retrieve the resource to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for resource to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the resource to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@erratum_group.command(name=cli_util.override('software_source.get_erratum.command_name', 'get'), help=u"""Gets information about the specified erratum by its advisory name. \n[Command Reference](getErratum)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the resources to list. This parameter is required.""")
@cli_util.option('--name', required=True, help=u"""The erratum name (e.g. ELSA-2023-34678).""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'Erratum'})
@cli_util.wrap_exceptions
def get_erratum(ctx, from_json, compartment_id, name):

    if isinstance(name, six.string_types) and len(name.strip()) == 0:
        raise click.UsageError('Parameter --name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.get_erratum(
        compartment_id=compartment_id,
        name=name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@module_stream_group.command(name=cli_util.override('software_source.get_module_stream.command_name', 'get'), help=u"""Gets information about the specified module stream in a software source. \n[Command Reference](getModuleStream)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--module-name', required=True, help=u"""The name of the module.""")
@cli_util.option('--stream-name', required=True, help=u"""The name of the stream of the containing module.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'ModuleStream'})
@cli_util.wrap_exceptions
def get_module_stream(ctx, from_json, software_source_id, module_name, stream_name):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    if isinstance(module_name, six.string_types) and len(module_name.strip()) == 0:
        raise click.UsageError('Parameter --module-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.get_module_stream(
        software_source_id=software_source_id,
        module_name=module_name,
        stream_name=stream_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@module_stream_profile_group.command(name=cli_util.override('software_source.get_module_stream_profile.command_name', 'get'), help=u"""Gets information about the specified module stream profile in a software source. \n[Command Reference](getModuleStreamProfile)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--profile-name', required=True, help=u"""The name of the profile of the containing module stream.""")
@cli_util.option('--module-name', required=True, help=u"""The name of a module.""")
@cli_util.option('--stream-name', required=True, help=u"""The name of the stream of the containing module.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'ModuleStreamProfile'})
@cli_util.wrap_exceptions
def get_module_stream_profile(ctx, from_json, software_source_id, profile_name, module_name, stream_name):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    if isinstance(profile_name, six.string_types) and len(profile_name.strip()) == 0:
        raise click.UsageError('Parameter --profile-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.get_module_stream_profile(
        software_source_id=software_source_id,
        profile_name=profile_name,
        module_name=module_name,
        stream_name=stream_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@package_group_group.command(name=cli_util.override('software_source.get_package_group.command_name', 'get'), help=u"""Gets information about the specified package group from a software source. \n[Command Reference](getPackageGroup)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--package-group-id', required=True, help=u"""The unique package group identifier.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'PackageGroup'})
@cli_util.wrap_exceptions
def get_package_group(ctx, from_json, software_source_id, package_group_id):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    if isinstance(package_group_id, six.string_types) and len(package_group_id.strip()) == 0:
        raise click.UsageError('Parameter --package-group-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.get_package_group(
        software_source_id=software_source_id,
        package_group_id=package_group_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.get_software_package.command_name', 'get-software-package'), help=u"""Gets information about the specified software package. \n[Command Reference](getSoftwarePackage)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--software-package-name', required=True, help=u"""The name of the software package.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'SoftwarePackage'})
@cli_util.wrap_exceptions
def get_software_package(ctx, from_json, software_source_id, software_package_name):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    if isinstance(software_package_name, six.string_types) and len(software_package_name.strip()) == 0:
        raise click.UsageError('Parameter --software-package-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.get_software_package(
        software_source_id=software_source_id,
        software_package_name=software_package_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.get_software_source.command_name', 'get'), help=u"""Gets information about the specified software source. \n[Command Reference](getSoftwareSource)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSource'})
@cli_util.wrap_exceptions
def get_software_source(ctx, from_json, software_source_id):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.get_software_source(
        software_source_id=software_source_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.list_entitlements.command_name', 'list-entitlements'), help=u"""Lists entitlements in the specified tenancy OCID. Filter the list against a variety of criteria including but not limited to its CSI, and vendor name. \n[Command Reference](listEntitlements)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the resources to list. This parameter is required.""")
@cli_util.option('--csi', help=u"""A filter to return entitlements that match the given CSI.""")
@cli_util.option('--vendor-name', type=custom_types.CliCaseInsensitiveChoice(["ORACLE"]), help=u"""A filter to return only profiles that match the given vendorName.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["csi", "vendorName"]), help=u"""The field to sort entitlements by. Only one sort order may be provided.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'EntitlementCollection'})
@cli_util.wrap_exceptions
def list_entitlements(ctx, from_json, all_pages, page_size, compartment_id, csi, vendor_name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if csi is not None:
        kwargs['csi'] = csi
    if vendor_name is not None:
        kwargs['vendor_name'] = vendor_name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_entitlements,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_entitlements,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_entitlements(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@erratum_group.command(name=cli_util.override('software_source.list_errata.command_name', 'list-errata'), help=u"""Lists all of the currently available errata. Filter the list against a variety of criteria including but not limited to its name, classification type, advisory severity, and OS family. \n[Command Reference](listErrata)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the resources to list. This parameter is required.""")
@cli_util.option('--name', multiple=True, help=u"""The assigned erratum name. It's unique and not changeable.

Example: `ELSA-2020-5804`""")
@cli_util.option('--name-contains', help=u"""A filter to return resources that may partially match the erratum name given.""")
@cli_util.option('--classification-type', type=custom_types.CliCaseInsensitiveChoice(["SECURITY", "BUGFIX", "ENHANCEMENT", "OTHER"]), multiple=True, help=u"""A filter to return only packages that match the given update classification type.""")
@cli_util.option('--os-family', type=custom_types.CliCaseInsensitiveChoice(["ORACLE_LINUX_9", "ORACLE_LINUX_8", "ORACLE_LINUX_7"]), help=u"""A filter to return only profiles that match the given osFamily.""")
@cli_util.option('--advisory-severity', type=custom_types.CliCaseInsensitiveChoice(["LOW", "MODERATE", "IMPORTANT", "CRITICAL"]), multiple=True, help=u"""The advisory severity.""")
@cli_util.option('--time-issue-date-start', type=custom_types.CLI_DATETIME, help=u"""The issue date after which to list all errata, in ISO 8601 format

Example: 2017-07-14T02:40:00.000Z""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--time-issue-date-end', type=custom_types.CLI_DATETIME, help=u"""The issue date before which to list all errata, in ISO 8601 format

Example: 2017-07-14T02:40:00.000Z""" + custom_types.CLI_DATETIME.VALID_DATETIME_CLI_HELP_MESSAGE)
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeIssued", "name"]), help=u"""The field to sort errata by. Only one sort order may be provided. Default order for timeIssued is descending. Default order for name is ascending. If no value is specified timeIssued is default.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({'name': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'name': {'module': 'os_management_hub', 'class': 'list[string]'}}, output_type={'module': 'os_management_hub', 'class': 'ErratumCollection'})
@cli_util.wrap_exceptions
def list_errata(ctx, from_json, all_pages, page_size, compartment_id, name, name_contains, classification_type, os_family, advisory_severity, time_issue_date_start, time_issue_date_end, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if name is not None and len(name) > 0:
        kwargs['name'] = name
    if name_contains is not None:
        kwargs['name_contains'] = name_contains
    if classification_type is not None and len(classification_type) > 0:
        kwargs['classification_type'] = classification_type
    if os_family is not None:
        kwargs['os_family'] = os_family
    if advisory_severity is not None and len(advisory_severity) > 0:
        kwargs['advisory_severity'] = advisory_severity
    if time_issue_date_start is not None:
        kwargs['time_issue_date_start'] = time_issue_date_start
    if time_issue_date_end is not None:
        kwargs['time_issue_date_end'] = time_issue_date_end
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_errata,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_errata,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_errata(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.list_module_stream_profiles.command_name', 'list-module-stream-profiles'), help=u"""Lists module stream profiles from the specified software source OCID. Filter the list against a variety of criteria including but not limited to its module name, stream name, and (profile) name. \n[Command Reference](listModuleStreamProfiles)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--module-name', help=u"""The name of a module. This parameter is required if a streamName is specified.""")
@cli_util.option('--stream-name', help=u"""The name of the stream of the containing module.  This parameter is required if a profileName is specified.""")
@cli_util.option('--name', help=u"""The name of the entity to be queried.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["moduleName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for moduleName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'ModuleStreamProfileCollection'})
@cli_util.wrap_exceptions
def list_module_stream_profiles(ctx, from_json, all_pages, page_size, software_source_id, module_name, stream_name, name, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    kwargs = {}
    if module_name is not None:
        kwargs['module_name'] = module_name
    if stream_name is not None:
        kwargs['stream_name'] = stream_name
    if name is not None:
        kwargs['name'] = name
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_module_stream_profiles,
            software_source_id=software_source_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_module_stream_profiles,
            limit,
            page_size,
            software_source_id=software_source_id,
            **kwargs
        )
    else:
        result = client.list_module_stream_profiles(
            software_source_id=software_source_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.list_module_streams.command_name', 'list-module-streams'), help=u"""Lists module streams from the specified software source OCID. Filter the list against a variety of criteria including but not limited to its module name and (stream) name. \n[Command Reference](listModuleStreams)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--module-name', help=u"""The name of a module. This parameter is required if a streamName is specified.""")
@cli_util.option('--name', help=u"""The name of the entity to be queried.""")
@cli_util.option('--is-latest', type=click.BOOL, help=u"""A boolean variable that is used to list only the latest versions of packages, module streams, and stream profiles when set to true. All packages, module streams, and stream profiles are returned when set to false.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["moduleName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for moduleName is ascending.""")
@cli_util.option('--module-name-contains', help=u"""A filter to return resources that may partially match the module name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'ModuleStreamCollection'})
@cli_util.wrap_exceptions
def list_module_streams(ctx, from_json, all_pages, page_size, software_source_id, module_name, name, is_latest, limit, page, sort_order, sort_by, module_name_contains):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    kwargs = {}
    if module_name is not None:
        kwargs['module_name'] = module_name
    if name is not None:
        kwargs['name'] = name
    if is_latest is not None:
        kwargs['is_latest'] = is_latest
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if module_name_contains is not None:
        kwargs['module_name_contains'] = module_name_contains
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_module_streams,
            software_source_id=software_source_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_module_streams,
            limit,
            page_size,
            software_source_id=software_source_id,
            **kwargs
        )
    else:
        result = client.list_module_streams(
            software_source_id=software_source_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.list_package_groups.command_name', 'list-package-groups'), help=u"""Lists package groups that associate with the specified software source OCID. Filter the list against a variety of criteria including but not limited to its name, and package group type. \n[Command Reference](listPackageGroups)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--compartment-id', help=u"""The OCID of the compartment that contains the resources to list.""")
@cli_util.option('--name', help=u"""The name of the entity to be queried.""")
@cli_util.option('--name-contains', help=u"""A filter to return resources that may partially match the name given.""")
@cli_util.option('--group-type', type=custom_types.CliCaseInsensitiveChoice(["GROUP", "ENVIRONMENT", "CATEGORY"]), multiple=True, help=u"""A filter to return only package groups of the specified type.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'PackageGroupCollection'})
@cli_util.wrap_exceptions
def list_package_groups(ctx, from_json, all_pages, page_size, software_source_id, compartment_id, name, name_contains, group_type, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if name is not None:
        kwargs['name'] = name
    if name_contains is not None:
        kwargs['name_contains'] = name_contains
    if group_type is not None and len(group_type) > 0:
        kwargs['group_type'] = group_type
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_package_groups,
            software_source_id=software_source_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_package_groups,
            limit,
            page_size,
            software_source_id=software_source_id,
            **kwargs
        )
    else:
        result = client.list_package_groups(
            software_source_id=software_source_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.list_software_packages.command_name', 'list-software-packages'), help=u"""Lists software packages in the specified software source.  Filter the list against a variety of criteria including but not limited to its name. \n[Command Reference](listSoftwarePackages)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable.

Example: `My new resource`""")
@cli_util.option('--display-name-contains', help=u"""A filter to return resources that may partially match the given display name.""")
@cli_util.option('--is-latest', type=click.BOOL, help=u"""A boolean variable that is used to list only the latest versions of packages, module streams, and stream profiles when set to true. All packages, module streams, and stream profiles are returned when set to false.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'SoftwarePackageCollection'})
@cli_util.wrap_exceptions
def list_software_packages(ctx, from_json, all_pages, page_size, software_source_id, display_name, display_name_contains, is_latest, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if display_name_contains is not None:
        kwargs['display_name_contains'] = display_name_contains
    if is_latest is not None:
        kwargs['is_latest'] = is_latest
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_software_packages,
            software_source_id=software_source_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_software_packages,
            limit,
            page_size,
            software_source_id=software_source_id,
            **kwargs
        )
    else:
        result = client.list_software_packages(
            software_source_id=software_source_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.list_software_source_vendors.command_name', 'list-software-source-vendors'), help=u"""Lists available software source vendors. Filter the list against a variety of criteria including but not limited to its name. \n[Command Reference](listSoftwareSourceVendors)""")
@cli_util.option('--compartment-id', required=True, help=u"""The OCID of the compartment that contains the resources to list. This parameter is required.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["name"]), help=u"""The field to sort software source vendors by. Only one sort order may be provided. Default order for name is ascending.""")
@cli_util.option('--name', help=u"""The name of the entity to be queried.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSourceVendorCollection'})
@cli_util.wrap_exceptions
def list_software_source_vendors(ctx, from_json, all_pages, compartment_id, sort_order, sort_by, name):

    kwargs = {}
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if name is not None:
        kwargs['name'] = name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.list_software_source_vendors(
        compartment_id=compartment_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.list_software_sources.command_name', 'list'), help=u"""Lists software sources that match the specified tenancy or software source OCID. Filter the list against a variety of criteria including but not limited to its name, status, architecture, and OS family. \n[Command Reference](listSoftwareSources)""")
@cli_util.option('--compartment-id', help=u"""The OCID of the compartment that contains the resources to list.""")
@cli_util.option('--software-source-id', help=u"""The OCID for the software source.""")
@cli_util.option('--software-source-type', type=custom_types.CliCaseInsensitiveChoice(["VENDOR", "CUSTOM", "VERSIONED"]), multiple=True, help=u"""The type of the software source.""")
@cli_util.option('--vendor-name', type=custom_types.CliCaseInsensitiveChoice(["ORACLE"]), help=u"""A filter to return only profiles that match the given vendorName.""")
@cli_util.option('--os-family', type=custom_types.CliCaseInsensitiveChoice(["ORACLE_LINUX_9", "ORACLE_LINUX_8", "ORACLE_LINUX_7"]), multiple=True, help=u"""A filter to return only instances whose OS family type matches the given OS family.""")
@cli_util.option('--arch-type', type=custom_types.CliCaseInsensitiveChoice(["X86_64", "AARCH64", "I686", "NOARCH", "SRC"]), multiple=True, help=u"""A filter to return only instances whose architecture type matches the given architecture.""")
@cli_util.option('--availability', type=custom_types.CliCaseInsensitiveChoice(["AVAILABLE", "SELECTED", "RESTRICTED"]), multiple=True, help=u"""The availabilities of the software source for a tenant.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable.

Example: `My new resource`""")
@cli_util.option('--display-name-contains', help=u"""A filter to return resources that may partially match the given display name.""")
@cli_util.option('--display-name-not-equal-to', multiple=True, help=u"""A multi filter to return resources that do not contains the given display names.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]), multiple=True, help=u"""A filter to return only resources whose lifecycleState matches the given lifecycleStates.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({'display-name-not-equal-to': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'display-name-not-equal-to': {'module': 'os_management_hub', 'class': 'list[string]'}}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSourceCollection'})
@cli_util.wrap_exceptions
def list_software_sources(ctx, from_json, all_pages, page_size, compartment_id, software_source_id, software_source_type, vendor_name, os_family, arch_type, availability, display_name, display_name_contains, display_name_not_equal_to, limit, page, sort_order, sort_by, lifecycle_state):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if compartment_id is not None:
        kwargs['compartment_id'] = compartment_id
    if software_source_id is not None:
        kwargs['software_source_id'] = software_source_id
    if software_source_type is not None and len(software_source_type) > 0:
        kwargs['software_source_type'] = software_source_type
    if vendor_name is not None:
        kwargs['vendor_name'] = vendor_name
    if os_family is not None and len(os_family) > 0:
        kwargs['os_family'] = os_family
    if arch_type is not None and len(arch_type) > 0:
        kwargs['arch_type'] = arch_type
    if availability is not None and len(availability) > 0:
        kwargs['availability'] = availability
    if display_name is not None:
        kwargs['display_name'] = display_name
    if display_name_contains is not None:
        kwargs['display_name_contains'] = display_name_contains
    if display_name_not_equal_to is not None and len(display_name_not_equal_to) > 0:
        kwargs['display_name_not_equal_to'] = display_name_not_equal_to
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if lifecycle_state is not None and len(lifecycle_state) > 0:
        kwargs['lifecycle_state'] = lifecycle_state
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_software_sources,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_software_sources,
            limit,
            page_size,
            **kwargs
        )
    else:
        result = client.list_software_sources(
            **kwargs
        )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.search_software_source_module_streams.command_name', 'search-software-source-module-streams'), help=u"""Lists modules from a list of software sources. Filter the list against a variety of criteria including the module name. \n[Command Reference](searchSoftwareSourceModuleStreams)""")
@cli_util.option('--software-source-ids', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of software source OCIDs.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order.""")
@cli_util.option('--module-name', help=u"""The name of a module.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["MODULENAME"]), help=u"""The field to sort by.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@json_skeleton_utils.get_cli_json_input_option({'software-source-ids': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'software-source-ids': {'module': 'os_management_hub', 'class': 'list[string]'}}, output_type={'module': 'os_management_hub', 'class': 'ModuleStreamCollection'})
@cli_util.wrap_exceptions
def search_software_source_module_streams(ctx, from_json, software_source_ids, sort_order, module_name, sort_by, limit, page):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['softwareSourceIds'] = cli_util.parse_json_parameter("software_source_ids", software_source_ids)

    if sort_order is not None:
        _details['sortOrder'] = sort_order

    if module_name is not None:
        _details['moduleName'] = module_name

    if sort_by is not None:
        _details['sortBy'] = sort_by

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.search_software_source_module_streams(
        search_software_source_module_streams_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.search_software_source_modules.command_name', 'search-software-source-modules'), help=u"""Lists modules from a list of software sources. Filter the list against a variety of criteria including the (module) name. \n[Command Reference](searchSoftwareSourceModules)""")
@cli_util.option('--software-source-ids', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of software source OCIDs.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order.""")
@cli_util.option('--name', help=u"""The name of a module.""")
@cli_util.option('--name-contains', help=u"""filters results, allowing only those with a name which contains the string.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["NAME"]), help=u"""The field to sort by.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@json_skeleton_utils.get_cli_json_input_option({'software-source-ids': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'software-source-ids': {'module': 'os_management_hub', 'class': 'list[string]'}}, output_type={'module': 'os_management_hub', 'class': 'ModuleCollection'})
@cli_util.wrap_exceptions
def search_software_source_modules(ctx, from_json, software_source_ids, sort_order, name, name_contains, sort_by, limit, page):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['softwareSourceIds'] = cli_util.parse_json_parameter("software_source_ids", software_source_ids)

    if sort_order is not None:
        _details['sortOrder'] = sort_order

    if name is not None:
        _details['name'] = name

    if name_contains is not None:
        _details['nameContains'] = name_contains

    if sort_by is not None:
        _details['sortBy'] = sort_by

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.search_software_source_modules(
        search_software_source_modules_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.search_software_source_package_groups.command_name', 'search-software-source-package-groups'), help=u"""Searches the package groups from the specified list of software sources. Filter the list against a variety of criteria including but not limited to its name, and group type. \n[Command Reference](searchSoftwareSourcePackageGroups)""")
@cli_util.option('--software-source-ids', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of software source OCIDs.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["NAME"]), help=u"""The field to sort by.""")
@cli_util.option('--name-contains', help=u"""filters results, allowing only those with a Name which contains the string.""")
@cli_util.option('--group-type', help=u"""Indicates if this is a group, category or environment.""")
@cli_util.option('--limit', type=click.INT, help=u"""For list pagination. The maximum number of results per page, or items to return in a paginated \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `50`""")
@cli_util.option('--page', help=u"""For list pagination. The value of the `opc-next-page` response header from the previous \"List\" call. For important details about how pagination works, see [List Pagination].

Example: `3`""")
@json_skeleton_utils.get_cli_json_input_option({'software-source-ids': {'module': 'os_management_hub', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'software-source-ids': {'module': 'os_management_hub', 'class': 'list[string]'}}, output_type={'module': 'os_management_hub', 'class': 'PackageGroupCollection'})
@cli_util.wrap_exceptions
def search_software_source_package_groups(ctx, from_json, software_source_ids, sort_order, sort_by, name_contains, group_type, limit, page):

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['softwareSourceIds'] = cli_util.parse_json_parameter("software_source_ids", software_source_ids)

    if sort_order is not None:
        _details['sortOrder'] = sort_order

    if sort_by is not None:
        _details['sortBy'] = sort_by

    if name_contains is not None:
        _details['nameContains'] = name_contains

    if group_type is not None:
        _details['groupType'] = group_type

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.search_software_source_package_groups(
        search_software_source_package_groups_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.update_software_source.command_name', 'update'), help=u"""Updates the specified software source's details, including but not limited to name, description, and tags. \n[Command Reference](updateSoftwareSource)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--compartment-id', help=u"""The OCID of the tenancy containing the software source.""")
@cli_util.option('--display-name', help=u"""User friendly name for the software source.""")
@cli_util.option('--description', help=u"""Information specified by the user about the software source.""")
@cli_util.option('--software-source-type', type=custom_types.CliCaseInsensitiveChoice(["VENDOR", "CUSTOM", "VERSIONED"]), help=u"""Type of the software source.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSource'})
@cli_util.wrap_exceptions
def update_software_source(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, software_source_id, compartment_id, display_name, description, software_source_type, freeform_tags, defined_tags, if_match):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if software_source_type is not None:
        _details['softwareSourceType'] = software_source_type

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.update_software_source(
        software_source_id=software_source_id,
        update_software_source_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.update_software_source_update_custom_software_source_details.command_name', 'update-software-source-update-custom-software-source-details'), help=u"""Updates the specified software source's details, including but not limited to name, description, and tags. \n[Command Reference](updateSoftwareSource)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--compartment-id', help=u"""The OCID of the tenancy containing the software source.""")
@cli_util.option('--display-name', help=u"""User friendly name for the software source.""")
@cli_util.option('--description', help=u"""Information specified by the user about the software source.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--vendor-software-sources', type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of vendor software sources.

This option is a JSON list with items of type Id.  For documentation on Id please see our API reference: https://docs.cloud.oracle.com/api/#/en/softwaresource/20220901/datatypes/Id.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--custom-software-source-filter', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--is-automatically-updated', type=click.BOOL, help=u"""Indicates whether service should automatically update the custom software source for the user.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}, 'vendor-software-sources': {'module': 'os_management_hub', 'class': 'list[Id]'}, 'custom-software-source-filter': {'module': 'os_management_hub', 'class': 'CustomSoftwareSourceFilter'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}, 'vendor-software-sources': {'module': 'os_management_hub', 'class': 'list[Id]'}, 'custom-software-source-filter': {'module': 'os_management_hub', 'class': 'CustomSoftwareSourceFilter'}}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSource'})
@cli_util.wrap_exceptions
def update_software_source_update_custom_software_source_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, software_source_id, compartment_id, display_name, description, freeform_tags, defined_tags, vendor_software_sources, custom_software_source_filter, is_automatically_updated, if_match):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags or vendor_software_sources or custom_software_source_filter:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags and vendor-software-sources and custom-software-source-filter will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if vendor_software_sources is not None:
        _details['vendorSoftwareSources'] = cli_util.parse_json_parameter("vendor_software_sources", vendor_software_sources)

    if custom_software_source_filter is not None:
        _details['customSoftwareSourceFilter'] = cli_util.parse_json_parameter("custom_software_source_filter", custom_software_source_filter)

    if is_automatically_updated is not None:
        _details['isAutomaticallyUpdated'] = is_automatically_updated

    _details['softwareSourceType'] = 'CUSTOM'

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.update_software_source(
        software_source_id=software_source_id,
        update_software_source_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@software_source_group.command(name=cli_util.override('software_source.update_software_source_update_vendor_software_source_details.command_name', 'update-software-source-update-vendor-software-source-details'), help=u"""Updates the specified software source's details, including but not limited to name, description, and tags. \n[Command Reference](updateSoftwareSource)""")
@cli_util.option('--software-source-id', required=True, help=u"""The software source OCID.""")
@cli_util.option('--compartment-id', help=u"""The OCID of the tenancy containing the software source.""")
@cli_util.option('--display-name', help=u"""User friendly name for the software source.""")
@cli_util.option('--description', help=u"""Information specified by the user about the software source.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'os_management_hub', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'os_management_hub', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'os_management_hub', 'class': 'SoftwareSource'})
@cli_util.wrap_exceptions
def update_software_source_update_vendor_software_source_details(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, software_source_id, compartment_id, display_name, description, freeform_tags, defined_tags, if_match):

    if isinstance(software_source_id, six.string_types) and len(software_source_id.strip()) == 0:
        raise click.UsageError('Parameter --software-source-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if description is not None:
        _details['description'] = description

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    _details['softwareSourceType'] = 'VENDOR'

    client = cli_util.build_client('os_management_hub', 'software_source', ctx)
    result = client.update_software_source(
        software_source_id=software_source_id,
        update_software_source_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
