# `nvm` Charter

nvm is a version manager for Node.js, designed to be installed per-user, and invoked per-shell. nvm works on any POSIX-compliant shell (sh, dash, ksh, zsh, bash), in particular on these platforms: unix, macOS, and Windows WSL.

## Section 0: Guiding Principles

The `nvm` project is part of the [OpenJS Foundation][openjs foundation], which operates transparently, openly, collaboratively, and ethically. Project proposals, timelines, and status must not merely be open, but also easily visible to outsiders.

## Section 1: Scope

`nvm` is a node version manager, focused on making it easy to install and manage multiple Node.js versions. Any features related to managing the installation and removal of Node.js on any node-supported platform are potentially in scope.

## Section 2: Relationship with OpenJS Foundation CPC.

Technical leadership for the projects within the [OpenJS Foundation][openjs foundation] is delegated to the projects through their project charters by the [OpenJS Foundation Cross-Project Council](https://openjsf.org/about/governance/) (CPC). In the case of the `nvm` project, it is delegated to the [`nvm` Maintainers](README.md#maintainers) (the “Maintainers”). The OpenJS Foundation's business leadership is the Board of Directors (the “Board”).

This `nvm` Charter reflects a carefully constructed balanced role for the Maintainers and the CPC in the governance of the OpenJS Foundation. The charter amendment process is for the Maintainers to propose changes using simple majority of the full Maintainers, the proposed changes being subject to review and approval by the CPC. The CPC may additionally make amendments to the project charter at any time, though the CPC will not interfere with day-to-day discussions, votes or meetings of the Maintainers.

### 2.1 Other Formal Project Relationships

Section Intentionally Left Blank

## Section 3: `nvm`'s Maintainers Governing Body

`nvm` is governed by its [maintainers](README.md#maintainers).

## Section 4: Roles & Responsibilities

The roles and responsibilities of `nvm`'s Maintainers are described in [GOVERNANCE.md](./GOVERNANCE.md).

### Section 4.1 Project Operations & Management

Section Intentionally Left Blank

### Section 4.2: Decision-making, Voting, and/or Elections

Section Intentionally Left Blank

### Section 4.3: Other Project Roles

Section Intentionally Left Blank

## Section 5: Definitions

  - *Contributors*: contribute code or other artifacts, but do not have the right to commit to the codebase. Contributors work with the project’s maintainers to have code committed to the code base. A Contributor may be promoted to a Maintainer by the Maintainers. Contributors should rarely be encumbered by the Maintainers and never by the CPC or OpenJS Foundation Board.

  - *Maintainers*: Contributors with any kind of decision-making authority in the project.

[openjs foundation]: https://openjsf.org
