## The NSM_Alias class simply keeps track of all the
## defined aliases and provides methods to update, add
## delete or query an alias

class NSM_Alias
  ## Retreive an alias by it's name
  def NSM_Alias.get_alias(name)
    @aliases = {} if @aliases.nil?
    return @aliases[name]
  end

  ## Set a new alias or update an existing one
  def NSM_Alias.set_alias(name,val)
    @aliases = {} if @aliases.nil?
    @aliases[name.to_s] = val.to_s
  end
  
  ## Delete an alias
  def NSM_Alias.del_alias(name)
    @aliases = {} if @aliases.nil?
    @aliases.delete(name)
  end

  ## Get a hash of the current aliases
  def NSM_Alias.get_aliases
    @aliases = {} if @aliases.nil?
    return @aliases
  end
  
  ## Return an array of alias names
  def NSM_Alias.get_alias_names
    results = []
    @aliases.each { |k,v|
      results.push(k)
    }
    return results
  end
end