# Code of Conduct

The Node.js project has a [Code of Conduct][] that *all* contributors are
expected to follow. This code describes the *minimum* behavior expectations
for all contributors.

As a contributor to Node.js, how you choose to act and interact towards your
fellow contributors, as well as to the community, will reflect back not only
on yourself but on the project as a whole. The Code of Conduct is designed and
intended, above all else, to help establish a culture within the project that
allows anyone and everyone who wants to contribute to feel safe doing so.

Should any individual act in any way that is considered in violation of the
[Code of Conduct][], corrective actions will be taken. It is possible, however,
for any individual to *act* in such a manner that is not in violation of the
strict letter of the Code of Conduct guidelines while still going completely
against the spirit of what that Code is intended to accomplish.

Open, diverse, and inclusive communities live and die on the basis of trust.
Contributors can disagree with one another so long as they trust that those
disagreements are in good faith and everyone is working towards a common goal.

## Bad actors

All contributors to Node.js tacitly agree to abide by both the letter and
spirit of the [Code of Conduct][]. Failure, or unwillingness, to do so will
result in contributions being respectfully declined.

A *bad actor* is someone who repeatedly violates the spirit of the Code of
Conduct through failure to regulate how they
interact with others. In doing so, bad actors
alienate other contributors, discourage collaboration, and generally reflect
poorly on the project as a whole.

Being a bad actor may be intentional or unintentional. Typically, unintentional
bad behavior can be easily corrected by being quick to apologize and correct
course *even if you are not entirely convinced you need to*. Giving other
contributors the benefit of the doubt and having a sincere willingness to admit
that you *might* be wrong is critical for any successful open collaboration.

Don't be a bad actor.

[Code of Conduct]: https://github.com/nodejs/admin/blob/HEAD/CODE_OF_CONDUCT.md
